/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.blockentity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import thedarkcolour.exdeorum.blockentity.AbstractMachineBlockEntity;
import thedarkcolour.exdeorum.blockentity.AbstractSieveBlockEntity;
import thedarkcolour.exdeorum.blockentity.helper.ItemHelper;
import thedarkcolour.exdeorum.blockentity.logic.SieveLogic;
import thedarkcolour.exdeorum.config.EConfig;
import thedarkcolour.exdeorum.menu.MechanicalSieveMenu;
import thedarkcolour.exdeorum.recipe.RecipeUtil;
import thedarkcolour.exdeorum.registry.EBlockEntities;
import thedarkcolour.exdeorum.tag.EItemTags;

public class MechanicalSieveBlockEntity
extends AbstractMachineBlockEntity<MechanicalSieveBlockEntity>
implements SieveLogic.Owner {
    private static final Component TITLE = Component.translatable((String)"exdeorum.container.mechanical_sieve");
    private static final int INPUT_SLOT = 0;
    public static final int MESH_SLOT = 1;
    private final SieveLogic logic = new SieveLogic(this, true);

    public MechanicalSieveBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EBlockEntities.MECHANICAL_SIEVE.get(), pos, state, ItemHandler::new, (Integer)EConfig.SERVER.mechanicalSieveEnergyStorage.get());
    }

    @Override
    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        this.logic.saveNbt(nbt, registries);
    }

    @Override
    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.logic.loadNbt(nbt, registries);
    }

    @Override
    protected boolean isRunning() {
        return !this.logic.getContents().isEmpty();
    }

    @Override
    protected void tryStartRunning() {
        ItemStack input = this.inventory.getStackInSlot(0);
        if (this.logic.isValidInput(input)) {
            this.logic.startSifting(AbstractSieveBlockEntity.singleCopy(input));
            input.shrink(1);
        }
    }

    @Override
    protected void runMachineTick() {
        this.logic.sift(0.01f, Long.MAX_VALUE);
    }

    @Override
    protected int getEnergyConsumption() {
        return (Integer)EConfig.SERVER.mechanicalSieveEnergyConsumption.get();
    }

    @Override
    public void writeVisualData(RegistryFriendlyByteBuf buffer) {
        this.logic.writeVisualData(buffer);
    }

    @Override
    public void readVisualData(RegistryFriendlyByteBuf buffer) {
        this.logic.readVisualData(buffer);
    }

    @Override
    public void copyVisualData(BlockEntity fromIntegratedServer) {
        this.logic.copyVisualData(fromIntegratedServer);
    }

    @Override
    public boolean handleResultItem(ItemStack result, ServerLevel level, RandomSource rand) {
        ItemStack remainder = result.copy();
        for (int i = 2; i < 22; ++i) {
            boolean splitRemainder;
            ItemStack existing = this.inventory.getStackInSlot(i);
            int limit = this.inventory.getSlotLimit(i);
            if (!existing.isEmpty()) {
                if (!ItemStack.isSameItemSameComponents((ItemStack)remainder, (ItemStack)existing)) continue;
                limit -= existing.getCount();
            }
            if (limit <= 0) continue;
            boolean bl = splitRemainder = remainder.getCount() > limit;
            if (existing.isEmpty()) {
                this.inventory.setStackInSlot(i, splitRemainder ? remainder.copyWithCount(limit) : remainder);
            } else {
                existing.grow(splitRemainder ? limit : remainder.getCount());
            }
            if (splitRemainder) {
                remainder = remainder.copyWithCount(remainder.getCount() - limit);
                continue;
            }
            return true;
        }
        return remainder.getCount() < result.getCount();
    }

    public Component getDisplayName() {
        return TITLE;
    }

    public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player pPlayer) {
        return new MechanicalSieveMenu(containerId, playerInventory, this);
    }

    @Override
    public SieveLogic getLogic() {
        return this.logic;
    }

    @Override
    public ServerLevel getServerLevel() {
        return (ServerLevel)this.level;
    }

    private static class ItemHandler
    extends ItemHelper {
        private final MechanicalSieveBlockEntity sieve;

        public ItemHandler(MechanicalSieveBlockEntity sieve) {
            super(22);
            this.sieve = sieve;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (slot == 0) {
                return !RecipeUtil.getSieveRecipes(this.getStackInSlot(1).getItem(), stack).isEmpty();
            }
            if (slot == 1) {
                return stack.is(EItemTags.SIEVE_MESHES);
            }
            return false;
        }

        public int getSlotLimit(int slot) {
            return slot == 1 ? 1 : super.getSlotLimit(slot);
        }

        @Override
        public boolean canMachineExtract(int slot) {
            return slot > 1;
        }

        protected void onContentsChanged(int slot) {
            if (slot == 1) {
                this.sieve.logic.setMesh((HolderLookup.Provider)this.sieve.level.registryAccess(), this.sieve.inventory.getStackInSlot(1));
            }
        }

        public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
            super.deserializeNBT(provider, nbt);
            this.sieve.logic.setMesh(provider, this.sieve.inventory.getStackInSlot(1), false);
        }
    }
}

