/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.client;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import thedarkcolour.exdeorum.client.RenderUtil;

public interface RenderFace {
    public void renderFlatSpriteLerp(MultiBufferSource var1, PoseStack var2, float var3, int var4, int var5, int var6, int var7, float var8, float var9, float var10);

    public boolean isMissingTexture();

    public void renderCuboid(MultiBufferSource var1, PoseStack var2, float var3, float var4, int var5, int var6, int var7, int var8, float var9);

    public record CompositeLayer(RenderType renderType, TextureAtlasSprite sprite) {
    }

    public record Composite(CompositeLayer[] layers, boolean isMissingTexture) implements RenderFace
    {
        public Composite(CompositeLayer[] layers) {
            this(layers, Composite.areAnyMissing(layers));
        }

        @Override
        public void renderFlatSpriteLerp(MultiBufferSource buffers, PoseStack stack, float percentage, int r, int g, int b, int light, float edge, float yStart, float yEnd) {
            for (CompositeLayer layer : this.layers) {
                RenderUtil.renderFlatSpriteLerp(buffers.getBuffer(layer.renderType), stack, percentage, r, g, b, layer.sprite, light, edge, yStart, yEnd);
            }
        }

        @Override
        public void renderCuboid(MultiBufferSource buffers, PoseStack stack, float minY, float maxY, int r, int g, int b, int light, float edge) {
            for (CompositeLayer layer : this.layers) {
                RenderUtil.renderCuboid(buffers.getBuffer(layer.renderType), stack, minY, maxY, r, g, b, layer.sprite, light, edge);
            }
        }

        private static boolean areAnyMissing(CompositeLayer[] layers) {
            for (CompositeLayer layer : layers) {
                if (!RenderUtil.isMissingTexture(layer.sprite)) continue;
                return true;
            }
            return false;
        }
    }

    public record Single(RenderType renderType, TextureAtlasSprite sprite, boolean isMissingTexture) implements RenderFace
    {
        public Single(RenderType renderType, TextureAtlasSprite sprite) {
            this(renderType, sprite, RenderUtil.isMissingTexture(sprite));
        }

        @Override
        public void renderFlatSpriteLerp(MultiBufferSource buffers, PoseStack stack, float percentage, int r, int g, int b, int light, float edge, float yStart, float yEnd) {
            RenderUtil.renderFlatSpriteLerp(buffers.getBuffer(this.renderType), stack, percentage, r, g, b, this.sprite, light, edge, yStart, yEnd);
        }

        @Override
        public void renderCuboid(MultiBufferSource buffers, PoseStack stack, float minY, float maxY, int r, int g, int b, int light, float edge) {
            RenderUtil.renderCuboid(buffers.getBuffer(this.renderType), stack, minY, maxY, r, g, b, this.sprite, light, edge);
        }
    }
}

