/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.compat.emi;

import dev.emi.emi.api.neoforge.NeoForgeEmiIngredient;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import thedarkcolour.exdeorum.compat.emi.EEmiRecipe;
import thedarkcolour.exdeorum.compat.emi.EmiUtil;
import thedarkcolour.exdeorum.compat.emi.ExDeorumEmiPlugin;
import thedarkcolour.exdeorum.recipe.barrel.BarrelFluidMixingRecipe;
import thedarkcolour.exdeorum.recipe.barrel.BarrelMixingRecipe;

abstract class BarrelMixingEmiRecipe
extends EEmiRecipe {
    private final EmiIngredient base;
    private final EmiIngredient additive;
    private final List<EmiIngredient> inputs;
    private final List<EmiStack> outputs;

    public BarrelMixingEmiRecipe(EmiIngredient base, EmiIngredient additive, List<EmiStack> outputs, ResourceLocation id) {
        super(id);
        this.base = base;
        this.additive = additive;
        this.inputs = List.of(base, additive);
        this.outputs = outputs;
    }

    public List<EmiIngredient> getInputs() {
        return this.inputs;
    }

    public List<EmiStack> getOutputs() {
        return this.outputs;
    }

    public int getDisplayWidth() {
        return 120;
    }

    public int getDisplayHeight() {
        return 18;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addSlot(this.base, 0, 0);
        widgets.addTexture(EmiTexture.PLUS, 22, 2);
        widgets.addSlot(this.additive, 39, 0);
        widgets.addTexture(EmiTexture.EMPTY_ARROW, 63, 1);
        widgets.addSlot((EmiIngredient)this.outputs.getFirst(), 93, 0).recipeContext((EmiRecipe)this);
    }

    static class Fluids
    extends BarrelMixingEmiRecipe {
        public Fluids(BarrelFluidMixingRecipe recipe, ResourceLocation id) {
            super(NeoForgeEmiIngredient.of((SizedFluidIngredient)recipe.baseFluid()), NeoForgeEmiIngredient.of((FluidIngredient)recipe.additiveFluid()), EmiUtil.outputs(recipe.result()), id);
        }

        public EmiRecipeCategory getCategory() {
            return ExDeorumEmiPlugin.BARREL_FLUID_MIXING;
        }
    }

    static class Items
    extends BarrelMixingEmiRecipe {
        public Items(BarrelMixingRecipe recipe, ResourceLocation id) {
            super(NeoForgeEmiIngredient.of((SizedFluidIngredient)recipe.fluid), EmiIngredient.of((Ingredient)recipe.ingredient), EmiUtil.outputs(recipe.result), id);
        }

        public EmiRecipeCategory getCategory() {
            return ExDeorumEmiPlugin.BARREL_MIXING;
        }
    }
}

