/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.compat.kubejs;

import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.latvian.mods.kubejs.bindings.event.ServerEvents;
import dev.latvian.mods.kubejs.recipe.RecipesKubeEvent;
import dev.latvian.mods.kubejs.recipe.filter.RecipeFilterParseEvent;
import dev.latvian.mods.kubejs.recipe.match.ReplacementMatchInfo;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.type.TypeInfo;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.function.Consumer;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.registries.DeferredHolder;
import thedarkcolour.exdeorum.compat.kubejs.SieveMeshFilter;
import thedarkcolour.exdeorum.recipe.BlockPredicate;
import thedarkcolour.exdeorum.recipe.RecipeUtil;
import thedarkcolour.exdeorum.recipe.crucible.CrucibleHeatRecipe;
import thedarkcolour.exdeorum.registry.ERecipeTypes;

class ExDeorumKubeJsBindings {
    ExDeorumKubeJsBindings() {
    }

    public void setCrucibleHeatValue(Block block, int value) {
        this.setCrucibleHeatValueForBlock(block, value);
    }

    public void setCrucibleHeatValueForState(String stateString, int value) {
        ExDeorumKubeJsBindings.onRecipesEvent(event -> {
            BlockState state = RecipeUtil.parseBlockState(stateString);
            StatePropertiesPredicate.Builder properties = StatePropertiesPredicate.Builder.properties();
            for (Property prop : state.getProperties()) {
                ExDeorumKubeJsBindings.bypassTypeChecking(properties, prop, state);
            }
            event.custom(null, (JsonObject)CrucibleHeatRecipe.CODEC.encoder().encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)new CrucibleHeatRecipe(BlockPredicate.blockState(state.getBlock(), (StatePropertiesPredicate)properties.build().get()), value)).result().get());
        });
    }

    @HideFromJS
    private static <T extends Comparable<T>> void bypassTypeChecking(StatePropertiesPredicate.Builder properties, Property<T> prop, BlockState state) {
        properties.hasProperty(prop, prop.getName(state.getValue(prop)));
    }

    public void setCrucibleHeatValueForBlock(Block block, int value) {
        ExDeorumKubeJsBindings.onRecipesEvent(event -> event.custom(null, (JsonObject)CrucibleHeatRecipe.CODEC.encoder().encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)new CrucibleHeatRecipe(BlockPredicate.singleBlock(block), value)).result().get()));
    }

    public void removeDefaultSieveRecipes(RecipesKubeEvent recipesEvent) {
        ExDeorumKubeJsBindings.removeDefaultRecipes(recipesEvent, ERecipeTypes.SIEVE);
    }

    public void removeDefaultHeatSources() {
        ExDeorumKubeJsBindings.onRecipesEvent(event -> ExDeorumKubeJsBindings.removeDefaultRecipes(event, ERecipeTypes.CRUCIBLE_HEAT_SOURCE));
    }

    @HideFromJS
    private static void removeDefaultRecipes(RecipesKubeEvent event, DeferredHolder<? extends RecipeType<?>, ? extends RecipeType<?>> recipeType) {
        event.remove(null, (ctx, r) -> r.kjs$getType().equals((Object)recipeType.getId()) && r.kjs$getOrCreateId().getNamespace().equals("exdeorum"));
    }

    @HideFromJS
    private static void onRecipesEvent(Consumer<RecipesKubeEvent> action) {
        ServerEvents.RECIPES.listenJava(ScriptType.SERVER, null, jsEvent -> {
            action.accept((RecipesKubeEvent)jsEvent);
            return null;
        });
    }

    public static void onRecipeFilterParse(RecipeFilterParseEvent event) {
        Object sieveMesh = event.map.get("sieve_mesh");
        if (sieveMesh != null) {
            ReplacementMatchInfo m = ReplacementMatchInfo.wrap((Context)event.cx, sieveMesh, (TypeInfo)ReplacementMatchInfo.TYPE_INFO);
            if (m == ReplacementMatchInfo.NONE) {
                throw Context.reportRuntimeError((String)("Unable to parse recipe output filter `" + String.valueOf(sieveMesh) + "`"), (Context)event.cx);
            }
            event.filters.add(new SieveMeshFilter(m));
        }
    }
}

