/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.data;

import java.util.concurrent.CompletableFuture;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import thedarkcolour.exdeorum.data.Advancements;
import thedarkcolour.exdeorum.data.BlockModels;
import thedarkcolour.exdeorum.data.English;
import thedarkcolour.exdeorum.data.ItemModels;
import thedarkcolour.exdeorum.data.LootModifiers;
import thedarkcolour.exdeorum.data.LootTables;
import thedarkcolour.exdeorum.data.ModTags;
import thedarkcolour.exdeorum.data.Sounds;
import thedarkcolour.exdeorum.data.recipe.Recipes;
import thedarkcolour.modkit.data.DataHelper;

public class Data {
    public static void generateData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        PackOutput output = gen.getPackOutput();
        CompletableFuture registries = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        DataHelper dataHelper = new DataHelper("exdeorum", event);
        dataHelper.createEnglish(true, English::addTranslations);
        dataHelper.createBlockModels(BlockModels::addBlockModels);
        dataHelper.createItemModels(true, true, false, ItemModels::addItemModels);
        dataHelper.createRecipes(Recipes::addRecipes);
        dataHelper.createTags(Registries.BLOCK, ModTags::createBlockTags);
        dataHelper.createTags(Registries.ITEM, ModTags::createItemTags);
        dataHelper.createTags(Registries.FLUID, ModTags::createFluidTags);
        dataHelper.createTags(Registries.STRUCTURE_SET, ModTags::createStructureSetTags);
        dataHelper.createTags(Registries.WORLD_PRESET, ModTags::createWorldPresetTags);
        gen.addProvider(true, (DataProvider)new LootTables(output, registries));
        gen.addProvider(true, (DataProvider)new Advancements(output, registries, helper));
        gen.addProvider(true, (DataProvider)new Sounds(output, helper));
        gen.addProvider(true, (DataProvider)new LootModifiers(output, registries));
    }
}

