/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.item;

import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.exdeorum.registry.EFluids;
import thedarkcolour.exdeorum.registry.EItems;

public class PorcelainBucket
extends Item {
    private final Supplier<? extends Fluid> fluid;

    public PorcelainBucket(Supplier<? extends Fluid> fluid, Item.Properties properties) {
        super(properties);
        this.fluid = fluid;
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        if (target instanceof Cow && !target.isBaby()) {
            Level level = player.level();
            player.playSound(SoundEvents.COW_MILK, 1.0f, 1.0f);
            if (!level.isClientSide) {
                ItemStack result = ItemUtils.createFilledResult((ItemStack)(stack.getCount() == 1 ? stack.copy() : stack), (Player)player, (ItemStack)new ItemStack((ItemLike)EItems.PORCELAIN_MILK_BUCKET.get()));
                player.setItemInHand(hand, result);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand pHand) {
        ItemStack stack = player.getItemInHand(pHand);
        BlockHitResult hitResult = PorcelainBucket.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)(this.fluid.get() == Fluids.EMPTY ? ClipContext.Fluid.SOURCE_ONLY : ClipContext.Fluid.NONE));
        if (hitResult.getType() == HitResult.Type.MISS) {
            return InteractionResultHolder.pass((Object)stack);
        }
        if (hitResult.getType() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.pass((Object)stack);
        }
        BlockPos pos = hitResult.getBlockPos();
        Direction face = hitResult.getDirection();
        BlockPos relative = pos.relative(face);
        if (level.mayInteract(player, pos) && player.mayUseItemAt(relative, face, stack)) {
            BlockPos placePos;
            if (this.fluid.get() == Fluids.EMPTY) {
                Block block;
                BlockState state = level.getBlockState(pos);
                FluidType fluidType = state.getFluidState().getFluidType();
                if ((fluidType == NeoForgeMod.WATER_TYPE.value() || fluidType == NeoForgeMod.LAVA_TYPE.value() || fluidType == EFluids.WITCH_WATER_TYPE.value()) && (block = state.getBlock()) instanceof BucketPickup) {
                    BucketPickup pickup = (BucketPickup)block;
                    ItemStack result = pickup.pickupBlock(player, (LevelAccessor)level, pos, state);
                    result = fluidType == NeoForgeMod.WATER_TYPE.value() ? new ItemStack((ItemLike)EItems.PORCELAIN_WATER_BUCKET.get()) : (fluidType == NeoForgeMod.LAVA_TYPE.value() ? new ItemStack((ItemLike)EItems.PORCELAIN_LAVA_BUCKET.get()) : new ItemStack((ItemLike)EItems.PORCELAIN_WITCH_WATER_BUCKET.get()));
                    if (!result.isEmpty()) {
                        player.awardStat(Stats.ITEM_USED.get((Object)this));
                        pickup.getPickupSound(state).ifPresent(sound -> player.playSound(sound, 1.0f, 1.0f));
                        level.gameEvent((Entity)player, (Holder)GameEvent.FLUID_PICKUP, pos);
                        ItemStack filled = ItemUtils.createFilledResult((ItemStack)stack, (Player)player, (ItemStack)result);
                        if (!level.isClientSide) {
                            CriteriaTriggers.FILLED_BUCKET.trigger((ServerPlayer)player, result);
                        }
                        return InteractionResultHolder.sidedSuccess((Object)filled, (boolean)level.isClientSide());
                    }
                }
                return InteractionResultHolder.fail((Object)stack);
            }
            BlockState state = level.getBlockState(pos);
            BlockPos blockPos = placePos = this.canBlockContainFluid(player, level, pos, state) ? pos : relative;
            if (this.emptyContents(player, level, placePos, hitResult, stack)) {
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    CriteriaTriggers.PLACED_BLOCK.trigger(serverPlayer, placePos, stack);
                }
                player.awardStat(Stats.ITEM_USED.get((Object)this));
                return InteractionResultHolder.sidedSuccess((Object)this.getEmptySuccessItem(stack, player), (boolean)level.isClientSide());
            }
            return InteractionResultHolder.fail((Object)stack);
        }
        return InteractionResultHolder.fail((Object)stack);
    }

    private ItemStack getEmptySuccessItem(ItemStack stack, Player player) {
        if (!player.getAbilities().instabuild) {
            if (this.fluid.get() == Fluids.LAVA) {
                return ItemStack.EMPTY;
            }
            return new ItemStack((ItemLike)EItems.PORCELAIN_BUCKET.get());
        }
        return stack;
    }

    public boolean emptyContents(@Nullable Player player, Level level, BlockPos pos, @Nullable BlockHitResult hitResult, @Nullable ItemStack container) {
        LiquidBlockContainer liquidContainer;
        LiquidBlockContainer liquidContainer2;
        if (!(this.fluid.get() instanceof FlowingFluid)) {
            return false;
        }
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        boolean replacing = state.canBeReplaced(this.fluid.get());
        boolean canPlaceAtPos = state.isAir() || replacing || block instanceof LiquidBlockContainer && (liquidContainer2 = (LiquidBlockContainer)block).canPlaceLiquid(player, (BlockGetter)level, pos, state, this.fluid.get());
        Optional containedFluidStack = Optional.ofNullable(container).flatMap(FluidUtil::getFluidContained);
        if (!canPlaceAtPos) {
            return hitResult != null && this.emptyContents(player, level, hitResult.getBlockPos().relative(hitResult.getDirection()), null, container);
        }
        if (containedFluidStack.isPresent() && this.fluid.get().getFluidType().isVaporizedOnPlacement(level, pos, (FluidStack)containedFluidStack.get())) {
            this.fluid.get().getFluidType().onVaporize(player, level, pos, (FluidStack)containedFluidStack.get());
            return true;
        }
        if (level.dimensionType().ultraWarm() && this.fluid.get().is(FluidTags.WATER)) {
            int i = pos.getX();
            int j = pos.getY();
            int k = pos.getZ();
            level.playSound(player, pos, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 0.5f, 2.6f + (level.random.nextFloat() - level.random.nextFloat()) * 0.8f);
            for (int l = 0; l < 8; ++l) {
                level.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)i + Math.random(), (double)j + Math.random(), (double)k + Math.random(), 0.0, 0.0, 0.0);
            }
            return true;
        }
        if (block instanceof LiquidBlockContainer && (liquidContainer = (LiquidBlockContainer)block).canPlaceLiquid(player, (BlockGetter)level, pos, state, this.fluid.get())) {
            liquidContainer.placeLiquid((LevelAccessor)level, pos, state, ((FlowingFluid)this.fluid.get()).getSource(false));
            this.playEmptySound(player, (LevelAccessor)level, pos);
            return true;
        }
        if (!level.isClientSide && replacing && !state.liquid()) {
            level.destroyBlock(pos, true);
        }
        if (!level.setBlock(pos, this.fluid.get().defaultFluidState().createLegacyBlock(), 11) && !state.getFluidState().isSource()) {
            return false;
        }
        this.playEmptySound(player, (LevelAccessor)level, pos);
        return true;
    }

    protected void playEmptySound(@Nullable Player pPlayer, LevelAccessor pLevel, BlockPos pPos) {
        SoundEvent sound = this.fluid.get().getFluidType().getSound(pPlayer, (BlockGetter)pLevel, pPos, SoundActions.BUCKET_EMPTY);
        if (sound == null) {
            sound = this.fluid.get().is(FluidTags.LAVA) ? SoundEvents.BUCKET_EMPTY_LAVA : SoundEvents.BUCKET_EMPTY;
        }
        pLevel.playSound(pPlayer, pPos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
        pLevel.gameEvent((Entity)pPlayer, (Holder)GameEvent.FLUID_PLACE, pPos);
    }

    protected boolean canBlockContainFluid(Player player, Level level, BlockPos pos, BlockState state) {
        LiquidBlockContainer block;
        Block block2 = state.getBlock();
        return block2 instanceof LiquidBlockContainer && (block = (LiquidBlockContainer)block2).canPlaceLiquid(player, (BlockGetter)level, pos, state, this.fluid.get());
    }

    public static class ItemHandler
    implements IFluidHandlerItem {
        private ItemStack container;

        public ItemHandler(ItemStack container) {
            this.container = container;
        }

        @NotNull
        public ItemStack getContainer() {
            return this.container;
        }

        public int getTanks() {
            return 1;
        }

        @NotNull
        public FluidStack getFluidInTank(int tank) {
            return this.getFluid();
        }

        public int getTankCapacity(int tank) {
            return 1000;
        }

        public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
            return stack.getFluid() == Fluids.LAVA || stack.getFluid() == Fluids.WATER || stack.getFluid() == EFluids.WITCH_WATER.get() || NeoForgeMod.MILK.isBound() && stack.getFluid() == NeoForgeMod.MILK.value();
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (this.container.getCount() != 1 || resource.getAmount() < 1000 || !this.getFluid().isEmpty() || !this.isFluidValid(0, resource)) {
                return 0;
            }
            if (action.execute()) {
                this.setFluid(resource);
            }
            return 1000;
        }

        @NotNull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (this.container.getCount() != 1 || resource.getAmount() < 1000) {
                return FluidStack.EMPTY;
            }
            FluidStack stack = this.getFluid();
            if (!stack.isEmpty() && FluidStack.isSameFluidSameComponents((FluidStack)stack, (FluidStack)resource)) {
                if (action.execute()) {
                    this.setFluid(FluidStack.EMPTY);
                }
                return stack;
            }
            return FluidStack.EMPTY;
        }

        @NotNull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            if (this.container.getCount() != 1 || maxDrain < 1000) {
                return FluidStack.EMPTY;
            }
            FluidStack fluidStack = this.getFluid();
            if (!fluidStack.isEmpty()) {
                if (action.execute()) {
                    this.setFluid(FluidStack.EMPTY);
                }
                return fluidStack;
            }
            return FluidStack.EMPTY;
        }

        FluidStack getFluid() {
            Item item = this.container.getItem();
            if (item == EItems.PORCELAIN_LAVA_BUCKET.get()) {
                return new FluidStack((Fluid)Fluids.LAVA, 1000);
            }
            if (item == EItems.PORCELAIN_WATER_BUCKET.get()) {
                return new FluidStack((Fluid)Fluids.WATER, 1000);
            }
            if (item == EItems.PORCELAIN_WITCH_WATER_BUCKET.get()) {
                return new FluidStack((Fluid)EFluids.WITCH_WATER.get(), 1000);
            }
            if (item == EItems.PORCELAIN_MILK_BUCKET.get() && NeoForgeMod.MILK.isBound()) {
                return new FluidStack((Fluid)NeoForgeMod.MILK.get(), 1000);
            }
            return FluidStack.EMPTY;
        }

        protected void setFluid(FluidStack fluidStack) {
            if (fluidStack.isEmpty()) {
                this.container = new ItemStack((ItemLike)EItems.PORCELAIN_BUCKET.get());
            } else if (fluidStack.getFluid() == Fluids.LAVA) {
                this.container = new ItemStack((ItemLike)EItems.PORCELAIN_LAVA_BUCKET.get());
            } else if (fluidStack.getFluid() == Fluids.WATER) {
                this.container = new ItemStack((ItemLike)EItems.PORCELAIN_WATER_BUCKET.get());
            } else if (fluidStack.getFluid() == EFluids.WITCH_WATER.get()) {
                this.container = new ItemStack((ItemLike)EItems.PORCELAIN_WITCH_WATER_BUCKET.get());
            } else if (NeoForgeMod.MILK.isBound() && fluidStack.getFluid() == NeoForgeMod.MILK.get()) {
                this.container = new ItemStack((ItemLike)EItems.PORCELAIN_MILK_BUCKET.get());
            }
        }
    }
}

