/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.item;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import thedarkcolour.exdeorum.block.InfestedLeavesBlock;
import thedarkcolour.exdeorum.blockentity.InfestedLeavesBlockEntity;
import thedarkcolour.exdeorum.registry.EBlocks;
import thedarkcolour.exdeorum.registry.ESounds;

public class SilkwormItem
extends Item {
    public SilkwormItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockPos pos = context.getClickedPos();
        Level level = context.getLevel();
        BlockState state = level.getBlockState(pos);
        if (!state.isAir() && state.is(BlockTags.LEAVES) && state.getBlock() != EBlocks.INFESTED_LEAVES.get()) {
            if (!level.isClientSide) {
                InfestedLeavesBlock.setBlock(level, pos, state);
                level.playSound(null, pos, (SoundEvent)ESounds.SILK_WORM_INFEST.get(), SoundSource.BLOCKS);
                BlockEntity blockEntity = level.getBlockEntity(pos);
                if (blockEntity instanceof InfestedLeavesBlockEntity) {
                    InfestedLeavesBlockEntity leaves = (InfestedLeavesBlockEntity)blockEntity;
                    leaves.setMimic(state);
                }
                context.getItemInHand().shrink(1);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        if (entity.tickCount == 1 && entity.getOwner() == null) {
            entity.level().playSound(null, (Entity)entity, (SoundEvent)ESounds.SILK_WORM_DROP.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        return false;
    }
}

