/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.menu;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import thedarkcolour.exdeorum.ExDeorum;
import thedarkcolour.exdeorum.blockentity.MechanicalHammerBlockEntity;
import thedarkcolour.exdeorum.menu.AbstractMachineMenu;
import thedarkcolour.exdeorum.registry.EMenus;
import thedarkcolour.exdeorum.tag.EItemTags;

public class MechanicalHammerMenu
extends AbstractMachineMenu<MechanicalHammerBlockEntity> {
    private static final ResourceLocation EMPTY_SLOT_HAMMER = ExDeorum.loc("item/empty_slot_hammer");
    private static final int NUM_SLOTS = 3;

    public MechanicalHammerMenu(int containerId, Inventory playerInventory, FriendlyByteBuf data) {
        this(containerId, playerInventory, (MechanicalHammerBlockEntity)((Object)MechanicalHammerMenu.readPayload(playerInventory, data)));
    }

    public MechanicalHammerMenu(int containerId, Inventory playerInventory, MechanicalHammerBlockEntity machine) {
        super((MenuType)EMenus.MECHANICAL_HAMMER.get(), containerId, playerInventory, machine);
        this.addSlot((Slot)machine.inventory.createSlot(0, 32, 35));
        this.addSlot(machine.inventory.createSlot(1, 56, 35).setBackground(InventoryMenu.BLOCK_ATLAS, EMPTY_SLOT_HAMMER));
        this.addSlot((Slot)machine.inventory.createSlot(2, 116, 35));
        this.addPlayerSlots(playerInventory, 84);
        this.addDataSlot(new ProgressDataSlot());
    }

    public ItemStack quickMoveStack(Player player, int clickedSlot) {
        ItemStack stack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(clickedSlot);
        if (slot.hasItem()) {
            ItemStack clickedStack = slot.getItem();
            stack = clickedStack.copy();
            if (clickedSlot > 1 && clickedSlot < 3 ? !this.moveItemStackTo(clickedStack, 3, 39, true) : (clickedSlot < 2 ? !this.moveItemStackTo(clickedStack, 3, 39, false) : (MechanicalHammerBlockEntity.isValidInput(clickedStack) ? !this.moveItemStackTo(clickedStack, 0, 1, false) : (clickedStack.is(EItemTags.HAMMERS) ? !this.moveItemStackTo(clickedStack, 1, 2, false) : (clickedSlot < 30 ? !this.moveItemStackTo(clickedStack, 30, 39, false) : clickedSlot < 39 && !this.moveItemStackTo(clickedStack, 3, 30, false)))))) {
                return ItemStack.EMPTY;
            }
            if (clickedStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            }
            slot.setChanged();
            if (clickedStack.getCount() == stack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, clickedStack);
            this.broadcastChanges();
        }
        return stack;
    }

    private class ProgressDataSlot
    extends DataSlot {
        private ProgressDataSlot() {
        }

        public int get() {
            return ((MechanicalHammerBlockEntity)MechanicalHammerMenu.this.machine).getGuiProgress();
        }

        public void set(int value) {
            ((MechanicalHammerBlockEntity)MechanicalHammerMenu.this.machine).setGuiProgress(value);
        }
    }
}

