/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.recipe.barrel;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import thedarkcolour.exdeorum.recipe.CodecUtil;
import thedarkcolour.exdeorum.recipe.SingleIngredientRecipe;
import thedarkcolour.exdeorum.registry.ERecipeSerializers;
import thedarkcolour.exdeorum.registry.ERecipeTypes;

public class BarrelCompostRecipe
extends SingleIngredientRecipe {
    public static final MapCodec<BarrelCompostRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(CodecUtil.ingredientField(), (App)Codec.INT.fieldOf("volume").forGetter(BarrelCompostRecipe::getVolume)).apply((Applicative)instance, BarrelCompostRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, BarrelCompostRecipe> STREAM_CODEC = StreamCodec.of(BarrelCompostRecipe::toNetwork, BarrelCompostRecipe::fromNetwork);
    private final int volume;

    public BarrelCompostRecipe(Ingredient ingredient, int volume) {
        super(ingredient);
        this.volume = volume;
    }

    public int getVolume() {
        return this.volume;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ERecipeSerializers.BARREL_COMPOST.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ERecipeTypes.BARREL_COMPOST.get();
    }

    public static void toNetwork(RegistryFriendlyByteBuf buffer, BarrelCompostRecipe recipe) {
        Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.ingredient);
        buffer.writeVarInt(recipe.getVolume());
    }

    public static BarrelCompostRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
        Ingredient ingredient = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
        int volume = buffer.readVarInt();
        return new BarrelCompostRecipe(ingredient, volume);
    }

    public static class Serializer
    implements RecipeSerializer<BarrelCompostRecipe> {
        public MapCodec<BarrelCompostRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, BarrelCompostRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

