/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.recipe.crook;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import thedarkcolour.exdeorum.recipe.BlockPredicate;
import thedarkcolour.exdeorum.registry.ERecipeSerializers;
import thedarkcolour.exdeorum.registry.ERecipeTypes;

public record CrookRecipe(BlockPredicate blockPredicate, ItemStack result, float chance) implements Recipe<RecipeInput>
{
    public static final MapCodec<CrookRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockPredicate.CODEC.fieldOf("block_predicate").forGetter(CrookRecipe::blockPredicate), (App)ItemStack.CODEC.fieldOf("result").forGetter(CrookRecipe::result), (App)Codec.FLOAT.fieldOf("chance").forGetter(CrookRecipe::chance)).apply((Applicative)instance, CrookRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, CrookRecipe> STREAM_CODEC = StreamCodec.of(CrookRecipe::toNetwork, CrookRecipe::fromNetwork);

    public boolean matches(RecipeInput input, Level pLevel) {
        return false;
    }

    public ItemStack assemble(RecipeInput input, HolderLookup.Provider registries) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return false;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return this.result;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ERecipeSerializers.CROOK.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ERecipeTypes.CROOK.get();
    }

    public static void toNetwork(RegistryFriendlyByteBuf buffer, CrookRecipe recipe) {
        recipe.blockPredicate.toNetwork(buffer);
        ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.result);
        buffer.writeFloat(recipe.chance);
    }

    public static CrookRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
        BlockPredicate blockPredicate = (BlockPredicate)BlockPredicate.STREAM_CODEC.decode((Object)buffer);
        ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
        float chance = buffer.readFloat();
        return new CrookRecipe(blockPredicate, result, chance);
    }

    public static class Serializer
    implements RecipeSerializer<CrookRecipe> {
        public MapCodec<CrookRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, CrookRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

