/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.registry;

import com.google.common.collect.Iterables;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import thedarkcolour.exdeorum.compat.CompatUtil;
import thedarkcolour.exdeorum.item.CookedSilkwormItem;
import thedarkcolour.exdeorum.item.CrookItem;
import thedarkcolour.exdeorum.item.GrassSpreaderItem;
import thedarkcolour.exdeorum.item.HammerItem;
import thedarkcolour.exdeorum.item.MeshItem;
import thedarkcolour.exdeorum.item.NyliumSpreaderItem;
import thedarkcolour.exdeorum.item.PorcelainBucket;
import thedarkcolour.exdeorum.item.PorcelainMilkBucket;
import thedarkcolour.exdeorum.item.RandomResultItem;
import thedarkcolour.exdeorum.item.SculkCoreItem;
import thedarkcolour.exdeorum.item.SilkwormItem;
import thedarkcolour.exdeorum.item.WateringCanItem;
import thedarkcolour.exdeorum.item.WideWateringCanItem;
import thedarkcolour.exdeorum.recipe.RecipeUtil;
import thedarkcolour.exdeorum.registry.EBlocks;
import thedarkcolour.exdeorum.registry.ECompressedBlocks;
import thedarkcolour.exdeorum.registry.EFluids;
import thedarkcolour.exdeorum.tag.EItemTags;

public class EItems {
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"exdeorum");
    public static final DeferredItem<SilkwormItem> SILKWORM = ITEMS.register("silkworm", () -> new SilkwormItem(EItems.props()));
    public static final DeferredItem<Item> COOKED_SILKWORM = ITEMS.register("cooked_silkworm", () -> new CookedSilkwormItem(EItems.props().food(new FoodProperties.Builder().nutrition(2).saturationModifier(0.6f).build())));
    public static final DeferredItem<Item> CROOK = ITEMS.register("crook", () -> new CrookItem(EItems.props().durability(128), 2.0f));
    public static final DeferredItem<Item> BONE_CROOK = ITEMS.register("bone_crook", () -> new CrookItem(EItems.props().durability(312), 4.0f));
    public static final DeferredItem<Item> WOODEN_WATERING_CAN = ITEMS.register("wooden_watering_can", () -> new WateringCanItem(300, EItems.props().stacksTo(1)));
    public static final DeferredItem<Item> STONE_WATERING_CAN = ITEMS.register("stone_watering_can", () -> new WateringCanItem(1000, EItems.props().stacksTo(1)));
    public static final DeferredItem<Item> IRON_WATERING_CAN = ITEMS.register("iron_watering_can", () -> new WateringCanItem(2000, EItems.props().stacksTo(1)));
    public static final DeferredItem<Item> GOLDEN_WATERING_CAN = ITEMS.register("golden_watering_can", () -> new WateringCanItem(4000, EItems.props().stacksTo(1)));
    public static final DeferredItem<Item> DIAMOND_WATERING_CAN = ITEMS.register("diamond_watering_can", () -> new WideWateringCanItem(false, EItems.props().stacksTo(1)));
    public static final DeferredItem<Item> NETHERITE_WATERING_CAN = ITEMS.register("netherite_watering_can", () -> new WideWateringCanItem(true, EItems.props().stacksTo(1)));
    public static final DeferredItem<Item> STRING_MESH = ITEMS.register("string_mesh", () -> new MeshItem(EItems.props().stacksTo(16)));
    public static final DeferredItem<Item> FLINT_MESH = ITEMS.register("flint_mesh", () -> new MeshItem(EItems.props().stacksTo(16)));
    public static final DeferredItem<Item> IRON_MESH = ITEMS.register("iron_mesh", () -> new MeshItem(EItems.props().stacksTo(16)));
    public static final DeferredItem<Item> GOLDEN_MESH = ITEMS.register("golden_mesh", () -> new MeshItem(EItems.props().stacksTo(16)));
    public static final DeferredItem<Item> DIAMOND_MESH = ITEMS.register("diamond_mesh", () -> new MeshItem(EItems.props().stacksTo(16)));
    public static final DeferredItem<Item> NETHERITE_MESH = ITEMS.register("netherite_mesh", () -> new MeshItem(EItems.props().stacksTo(16)));
    public static final DeferredItem<Item> WOODEN_HAMMER = ITEMS.register("wooden_hammer", () -> new HammerItem((Tier)Tiers.WOOD, EItems.props()));
    public static final DeferredItem<Item> STONE_HAMMER = ITEMS.register("stone_hammer", () -> new HammerItem((Tier)Tiers.STONE, EItems.props()));
    public static final DeferredItem<Item> GOLDEN_HAMMER = ITEMS.register("golden_hammer", () -> new HammerItem((Tier)Tiers.GOLD, EItems.props()));
    public static final DeferredItem<Item> IRON_HAMMER = ITEMS.register("iron_hammer", () -> new HammerItem((Tier)Tiers.IRON, EItems.props()));
    public static final DeferredItem<Item> DIAMOND_HAMMER = ITEMS.register("diamond_hammer", () -> new HammerItem((Tier)Tiers.DIAMOND, EItems.props()));
    public static final DeferredItem<Item> NETHERITE_HAMMER = ITEMS.register("netherite_hammer", () -> new HammerItem((Tier)Tiers.NETHERITE, EItems.props()));
    public static final DeferredItem<Item> COMPRESSED_WOODEN_HAMMER = ITEMS.register("compressed_wooden_hammer", () -> new HammerItem((Tier)Tiers.WOOD, EItems.props()));
    public static final DeferredItem<Item> COMPRESSED_STONE_HAMMER = ITEMS.register("compressed_stone_hammer", () -> new HammerItem((Tier)Tiers.STONE, EItems.props()));
    public static final DeferredItem<Item> COMPRESSED_GOLDEN_HAMMER = ITEMS.register("compressed_golden_hammer", () -> new HammerItem((Tier)Tiers.GOLD, EItems.props()));
    public static final DeferredItem<Item> COMPRESSED_IRON_HAMMER = ITEMS.register("compressed_iron_hammer", () -> new HammerItem((Tier)Tiers.IRON, EItems.props()));
    public static final DeferredItem<Item> COMPRESSED_DIAMOND_HAMMER = ITEMS.register("compressed_diamond_hammer", () -> new HammerItem((Tier)Tiers.DIAMOND, EItems.props()));
    public static final DeferredItem<Item> COMPRESSED_NETHERITE_HAMMER = ITEMS.register("compressed_netherite_hammer", () -> new HammerItem((Tier)Tiers.NETHERITE, EItems.props()));
    public static final DeferredItem<Item> IRON_ORE_CHUNK = EItems.registerSimpleItem("iron_ore_chunk");
    public static final DeferredItem<Item> COPPER_ORE_CHUNK = EItems.registerSimpleItem("copper_ore_chunk");
    public static final DeferredItem<Item> GOLD_ORE_CHUNK = EItems.registerSimpleItem("gold_ore_chunk");
    public static final DeferredItem<Item> ALUMINUM_ORE_CHUNK = EItems.registerSimpleItem("aluminum_ore_chunk");
    public static final DeferredItem<Item> COBALT_ORE_CHUNK = EItems.registerSimpleItem("cobalt_ore_chunk");
    public static final DeferredItem<Item> SILVER_ORE_CHUNK = EItems.registerSimpleItem("silver_ore_chunk");
    public static final DeferredItem<Item> LEAD_ORE_CHUNK = EItems.registerSimpleItem("lead_ore_chunk");
    public static final DeferredItem<Item> PLATINUM_ORE_CHUNK = EItems.registerSimpleItem("platinum_ore_chunk");
    public static final DeferredItem<Item> NICKEL_ORE_CHUNK = EItems.registerSimpleItem("nickel_ore_chunk");
    public static final DeferredItem<Item> URANIUM_ORE_CHUNK = EItems.registerSimpleItem("uranium_ore_chunk");
    public static final DeferredItem<Item> OSMIUM_ORE_CHUNK = EItems.registerSimpleItem("osmium_ore_chunk");
    public static final DeferredItem<Item> TIN_ORE_CHUNK = EItems.registerSimpleItem("tin_ore_chunk");
    public static final DeferredItem<Item> ZINC_ORE_CHUNK = EItems.registerSimpleItem("zinc_ore_chunk");
    public static final DeferredItem<Item> IRIDIUM_ORE_CHUNK = EItems.registerSimpleItem("iridium_ore_chunk");
    public static final DeferredItem<Item> THORIUM_ORE_CHUNK = EItems.registerSimpleItem("thorium_ore_chunk");
    public static final DeferredItem<Item> MAGNESIUM_ORE_CHUNK = EItems.registerSimpleItem("magnesium_ore_chunk");
    public static final DeferredItem<Item> LITHIUM_ORE_CHUNK = EItems.registerSimpleItem("lithium_ore_chunk");
    public static final DeferredItem<Item> BORON_ORE_CHUNK = EItems.registerSimpleItem("boron_ore_chunk");
    public static final DeferredItem<Item> STONE_PEBBLE = EItems.registerSimpleItem("stone_pebble");
    public static final DeferredItem<Item> DIORITE_PEBBLE = EItems.registerSimpleItem("diorite_pebble");
    public static final DeferredItem<Item> GRANITE_PEBBLE = EItems.registerSimpleItem("granite_pebble");
    public static final DeferredItem<Item> ANDESITE_PEBBLE = EItems.registerSimpleItem("andesite_pebble");
    public static final DeferredItem<Item> DEEPSLATE_PEBBLE = EItems.registerSimpleItem("deepslate_pebble");
    public static final DeferredItem<Item> TUFF_PEBBLE = EItems.registerSimpleItem("tuff_pebble");
    public static final DeferredItem<Item> CALCITE_PEBBLE = EItems.registerSimpleItem("calcite_pebble");
    public static final DeferredItem<Item> BLACKSTONE_PEBBLE = EItems.registerSimpleItem("blackstone_pebble");
    public static final DeferredItem<Item> BASALT_PEBBLE = EItems.registerSimpleItem("basalt_pebble");
    public static final DeferredItem<Item> PORCELAIN_CLAY_BALL = EItems.registerSimpleItem("porcelain_clay_ball");
    public static final DeferredItem<Item> GRASS_SEEDS = ITEMS.register("grass_seeds", () -> new GrassSpreaderItem(EItems.props(), () -> ((Block)Blocks.GRASS_BLOCK).defaultBlockState()));
    public static final DeferredItem<Item> MYCELIUM_SPORES = ITEMS.register("mycelium_spores", () -> new GrassSpreaderItem(EItems.props(), () -> ((Block)Blocks.MYCELIUM).defaultBlockState()));
    public static final DeferredItem<Item> WARPED_NYLIUM_SPORES = ITEMS.register("warped_nylium_spores", () -> new NyliumSpreaderItem(EItems.props(), () -> ((Block)Blocks.WARPED_NYLIUM).defaultBlockState()));
    public static final DeferredItem<Item> CRIMSON_NYLIUM_SPORES = ITEMS.register("crimson_nylium_spores", () -> new NyliumSpreaderItem(EItems.props(), () -> ((Block)Blocks.CRIMSON_NYLIUM).defaultBlockState()));
    public static final DeferredItem<Item> SCULK_CORE = ITEMS.register("sculk_core", () -> new SculkCoreItem(EItems.props().stacksTo(1)));
    public static final DeferredItem<Item> RANDOM_POTTERY_SHERD = ITEMS.register("random_pottery_sherd", () -> new RandomResultItem(EItems.props(), EItemTags.RANDOM_SHERD_DROPS));
    public static final DeferredItem<Item> RANDOM_ARMOR_TRIM = ITEMS.register("random_armor_trim", () -> new RandomResultItem(EItems.props(), EItemTags.RANDOM_TRIM_DROPS));
    public static final DeferredItem<Item> WOOD_CHIPPINGS = EItems.registerSimpleItem("wood_chippings");
    public static final DeferredItem<Item> UNFIRED_PORCELAIN_BUCKET = EItems.registerSimpleItem("unfired_porcelain_bucket");
    public static final DeferredItem<Item> PORCELAIN_BUCKET = ITEMS.register("porcelain_bucket", () -> new PorcelainBucket(() -> Fluids.EMPTY, EItems.props().stacksTo(16)));
    public static final DeferredItem<Item> PORCELAIN_WATER_BUCKET = ITEMS.register("porcelain_water_bucket", () -> new PorcelainBucket(() -> Fluids.WATER, EItems.props().craftRemainder((Item)PORCELAIN_BUCKET.get()).stacksTo(1)));
    public static final DeferredItem<Item> PORCELAIN_LAVA_BUCKET = ITEMS.register("porcelain_lava_bucket", () -> new PorcelainBucket(() -> Fluids.LAVA, EItems.props().stacksTo(1)));
    public static final DeferredItem<Item> PORCELAIN_MILK_BUCKET = ITEMS.register("porcelain_milk_bucket", () -> new PorcelainMilkBucket(EItems.props().craftRemainder((Item)PORCELAIN_BUCKET.get()).stacksTo(1)));
    public static final DeferredItem<Item> PORCELAIN_WITCH_WATER_BUCKET = ITEMS.register("porcelain_witch_water_bucket", () -> new PorcelainBucket((Supplier<? extends Fluid>)EFluids.WITCH_WATER, EItems.props().craftRemainder((Item)PORCELAIN_BUCKET.get()).stacksTo(1)));
    public static final DeferredItem<Item> WITCH_WATER_BUCKET = ITEMS.register("witch_water_bucket", () -> new BucketItem((Fluid)EFluids.WITCH_WATER.get(), EItems.props().craftRemainder(Items.BUCKET).stacksTo(1)));
    public static final DeferredItem<BlockItem> DUST = EItems.registerItemBlock(EBlocks.DUST);
    public static final DeferredItem<BlockItem> CRUSHED_NETHERRACK = EItems.registerItemBlock(EBlocks.CRUSHED_NETHERRACK);
    public static final DeferredItem<BlockItem> CRUSHED_END_STONE = EItems.registerItemBlock(EBlocks.CRUSHED_END_STONE);
    public static final DeferredItem<BlockItem> CRUSHED_DEEPSLATE = EItems.registerItemBlock(EBlocks.CRUSHED_DEEPSLATE);
    public static final DeferredItem<BlockItem> CRUSHED_BLACKSTONE = EItems.registerItemBlock(EBlocks.CRUSHED_BLACKSTONE);
    public static final DeferredItem<BlockItem> MECHANICAL_SIEVE = EItems.registerItemBlock(EBlocks.MECHANICAL_SIEVE);
    public static final DeferredItem<BlockItem> MECHANICAL_HAMMER = EItems.registerItemBlock(EBlocks.MECHANICAL_HAMMER);
    public static final DeferredItem<BlockItem> UNFIRED_PORCELAIN_CRUCIBLE = EItems.registerItemBlock(EBlocks.UNFIRED_PORCELAIN_CRUCIBLE);
    public static final DeferredItem<BlockItem> END_CAKE = EItems.registerItemBlock(EBlocks.END_CAKE);
    public static final DeferredItem<BlockItem> INFESTED_LEAVES = EItems.registerItemBlock(EBlocks.INFESTED_LEAVES);

    public static DeferredItem<Item> registerSimpleItem(String name) {
        return ITEMS.register(name, () -> new Item(EItems.props()));
    }

    public static Item.Properties props() {
        return new Item.Properties();
    }

    public static DeferredItem<BlockItem> registerItemBlock(DeferredBlock<? extends Block> block) {
        return ITEMS.register(block.getId().getPath(), () -> new BlockItem((Block)block.get(), EItems.props()));
    }

    public static void addItemsToMainTab(CreativeModeTab.Output output) {
        for (ItemLike material : Iterables.concat(CompatUtil.getAvailableBarrels(true), CompatUtil.getAvailableSieves(true, false), CompatUtil.getAvailableCompressedSieves(true))) {
            output.accept(material);
        }
        output.accept((ItemLike)MECHANICAL_SIEVE.get());
        output.accept((ItemLike)MECHANICAL_HAMMER.get());
        output.accept((ItemLike)UNFIRED_PORCELAIN_CRUCIBLE.get());
        for (ItemLike material : Iterables.concat(CompatUtil.getAvailableLavaCrucibles(true), CompatUtil.getAvailableWaterCrucibles(true))) {
            output.accept(material);
        }
        output.accept((ItemLike)DUST.get());
        output.accept((ItemLike)CRUSHED_NETHERRACK.get());
        output.accept((ItemLike)CRUSHED_END_STONE.get());
        output.accept((ItemLike)CRUSHED_DEEPSLATE.get());
        output.accept((ItemLike)CRUSHED_BLACKSTONE.get());
        output.accept((ItemLike)ECompressedBlocks.COMPRESSED_DIRT.getItem());
        output.accept((ItemLike)ECompressedBlocks.COMPRESSED_COBBLESTONE.getItem());
        output.accept((ItemLike)ECompressedBlocks.COMPRESSED_DIORITE.getItem());
        output.accept((ItemLike)ECompressedBlocks.COMPRESSED_GRANITE.getItem());
        output.accept((ItemLike)ECompressedBlocks.COMPRESSED_ANDESITE.getItem());
        output.accept((ItemLike)ECompressedBlocks.COMPRESSED_GRAVEL.getItem());
        output.accept((ItemLike)ECompressedBlocks.COMPRESSED_SAND.getItem());
        output.accept((ItemLike)ECompressedBlocks.COMPRESSED_DUST.getItem());
        output.accept((ItemLike)ECompressedBlocks.COMPRESSED_RED_SAND.getItem());
        output.accept((ItemLike)ECompressedBlocks.COMPRESSED_DEEPSLATE.getItem());
        output.accept((ItemLike)ECompressedBlocks.COMPRESSED_COBBLED_DEEPSLATE.getItem());
        output.accept((ItemLike)ECompressedBlocks.COMPRESSED_NETHERRACK.getItem());
        output.accept((ItemLike)ECompressedBlocks.COMPRESSED_BLACKSTONE.getItem());
        output.accept((ItemLike)ECompressedBlocks.COMPRESSED_END_STONE.getItem());
        output.accept((ItemLike)ECompressedBlocks.COMPRESSED_CRUSHED_DEEPSLATE.getItem());
        output.accept((ItemLike)ECompressedBlocks.COMPRESSED_CRUSHED_BLACKSTONE.getItem());
        output.accept((ItemLike)ECompressedBlocks.COMPRESSED_CRUSHED_NETHERRACK.getItem());
        output.accept((ItemLike)ECompressedBlocks.COMPRESSED_SOUL_SAND.getItem());
        output.accept((ItemLike)ECompressedBlocks.COMPRESSED_CRUSHED_END_STONE.getItem());
        output.accept((ItemLike)ECompressedBlocks.COMPRESSED_MOSS_BLOCK.getItem());
        output.accept((ItemLike)END_CAKE.get());
        output.accept((ItemLike)RANDOM_ARMOR_TRIM.get());
        output.accept((ItemLike)RANDOM_POTTERY_SHERD.get());
        output.accept((ItemLike)SILKWORM.get());
        output.accept((ItemLike)COOKED_SILKWORM.get());
        output.accept((ItemLike)CROOK.get());
        output.accept((ItemLike)BONE_CROOK.get());
        List<DeferredItem<Item>> wateringCans = List.of(WOODEN_WATERING_CAN, STONE_WATERING_CAN, IRON_WATERING_CAN, GOLDEN_WATERING_CAN, DIAMOND_WATERING_CAN, NETHERITE_WATERING_CAN);
        for (DeferredItem<Item> wateringCan : wateringCans) {
            ItemStack full = WateringCanItem.getFull(wateringCan);
            output.accept((ItemLike)wateringCan.get());
            output.accept(full);
        }
        output.accept((ItemLike)STRING_MESH.get());
        output.accept((ItemLike)FLINT_MESH.get());
        output.accept((ItemLike)IRON_MESH.get());
        output.accept((ItemLike)GOLDEN_MESH.get());
        output.accept((ItemLike)DIAMOND_MESH.get());
        output.accept((ItemLike)NETHERITE_MESH.get());
        output.accept((ItemLike)WOODEN_HAMMER.get());
        output.accept((ItemLike)STONE_HAMMER.get());
        output.accept((ItemLike)GOLDEN_HAMMER.get());
        output.accept((ItemLike)IRON_HAMMER.get());
        output.accept((ItemLike)DIAMOND_HAMMER.get());
        output.accept((ItemLike)NETHERITE_HAMMER.get());
        output.accept((ItemLike)COMPRESSED_WOODEN_HAMMER.get());
        output.accept((ItemLike)COMPRESSED_STONE_HAMMER.get());
        output.accept((ItemLike)COMPRESSED_GOLDEN_HAMMER.get());
        output.accept((ItemLike)COMPRESSED_IRON_HAMMER.get());
        output.accept((ItemLike)COMPRESSED_DIAMOND_HAMMER.get());
        output.accept((ItemLike)COMPRESSED_NETHERITE_HAMMER.get());
        output.accept((ItemLike)IRON_ORE_CHUNK.get());
        output.accept((ItemLike)COPPER_ORE_CHUNK.get());
        output.accept((ItemLike)GOLD_ORE_CHUNK.get());
        if (!RecipeUtil.isTagEmpty(EItemTags.ORES_ALUMINUM)) {
            output.accept((ItemLike)ALUMINUM_ORE_CHUNK.get());
        }
        if (!RecipeUtil.isTagEmpty(EItemTags.ORES_COBALT)) {
            output.accept((ItemLike)COBALT_ORE_CHUNK.get());
        }
        if (!RecipeUtil.isTagEmpty(EItemTags.ORES_SILVER)) {
            output.accept((ItemLike)SILVER_ORE_CHUNK.get());
        }
        if (!RecipeUtil.isTagEmpty(EItemTags.ORES_LEAD)) {
            output.accept((ItemLike)LEAD_ORE_CHUNK.get());
        }
        if (!RecipeUtil.isTagEmpty(EItemTags.ORES_PLATINUM)) {
            output.accept((ItemLike)PLATINUM_ORE_CHUNK.get());
        }
        if (!RecipeUtil.isTagEmpty(EItemTags.ORES_NICKEL)) {
            output.accept((ItemLike)NICKEL_ORE_CHUNK.get());
        }
        if (!RecipeUtil.isTagEmpty(EItemTags.ORES_URANIUM)) {
            output.accept((ItemLike)URANIUM_ORE_CHUNK.get());
        }
        if (!RecipeUtil.isTagEmpty(EItemTags.ORES_OSMIUM)) {
            output.accept((ItemLike)OSMIUM_ORE_CHUNK.get());
        }
        if (!RecipeUtil.isTagEmpty(EItemTags.ORES_TIN)) {
            output.accept((ItemLike)TIN_ORE_CHUNK.get());
        }
        if (!RecipeUtil.isTagEmpty(EItemTags.ORES_ZINC)) {
            output.accept((ItemLike)ZINC_ORE_CHUNK.get());
        }
        if (!RecipeUtil.isTagEmpty(EItemTags.ORES_IRIDIUM)) {
            output.accept((ItemLike)IRIDIUM_ORE_CHUNK.get());
        }
        if (!RecipeUtil.isTagEmpty(EItemTags.ORES_THORIUM)) {
            output.accept((ItemLike)THORIUM_ORE_CHUNK.get());
        }
        if (!RecipeUtil.isTagEmpty(EItemTags.ORES_MAGNESIUM)) {
            output.accept((ItemLike)MAGNESIUM_ORE_CHUNK.get());
        }
        if (!RecipeUtil.isTagEmpty(EItemTags.ORES_LITHIUM)) {
            output.accept((ItemLike)LITHIUM_ORE_CHUNK.get());
        }
        if (!RecipeUtil.isTagEmpty(EItemTags.ORES_BORON)) {
            output.accept((ItemLike)BORON_ORE_CHUNK.get());
        }
        output.accept((ItemLike)STONE_PEBBLE.get());
        output.accept((ItemLike)DIORITE_PEBBLE.get());
        output.accept((ItemLike)GRANITE_PEBBLE.get());
        output.accept((ItemLike)ANDESITE_PEBBLE.get());
        output.accept((ItemLike)DEEPSLATE_PEBBLE.get());
        output.accept((ItemLike)TUFF_PEBBLE.get());
        output.accept((ItemLike)CALCITE_PEBBLE.get());
        output.accept((ItemLike)BLACKSTONE_PEBBLE.get());
        output.accept((ItemLike)BASALT_PEBBLE.get());
        output.accept((ItemLike)GRASS_SEEDS.get());
        output.accept((ItemLike)MYCELIUM_SPORES.get());
        output.accept((ItemLike)WARPED_NYLIUM_SPORES.get());
        output.accept((ItemLike)CRIMSON_NYLIUM_SPORES.get());
        output.accept((ItemLike)SCULK_CORE.get());
        output.accept((ItemLike)WOOD_CHIPPINGS.get());
        output.accept((ItemLike)PORCELAIN_CLAY_BALL.get());
        output.accept((ItemLike)UNFIRED_PORCELAIN_BUCKET.get());
        output.accept((ItemLike)PORCELAIN_BUCKET.get());
        output.accept((ItemLike)PORCELAIN_WATER_BUCKET.get());
        output.accept((ItemLike)PORCELAIN_LAVA_BUCKET.get());
        output.accept((ItemLike)PORCELAIN_MILK_BUCKET.get());
        output.accept((ItemLike)PORCELAIN_WITCH_WATER_BUCKET.get());
        output.accept((ItemLike)WITCH_WATER_BUCKET.get());
    }
}

