/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.additionallanterns.data;

import com.supermartijn642.additionallanterns.LanternColor;
import com.supermartijn642.additionallanterns.LanternMaterial;
import com.supermartijn642.core.generator.ResourceCache;
import com.supermartijn642.core.generator.TagGenerator;
import net.minecraft.world.item.Items;

public class LanternTagGenerator
extends TagGenerator {
    public LanternTagGenerator(ResourceCache cache) {
        super("additionallanterns", cache);
    }

    public void generate() {
        for (LanternMaterial material : LanternMaterial.values()) {
            this.blockMineableWithPickaxe().add((Object)material.getLanternBlock());
            if (material.canBeColored) {
                for (LanternColor color : LanternColor.values()) {
                    this.blockMineableWithPickaxe().add((Object)material.getLanternBlock(color));
                }
            }
            if (!material.hasChains) continue;
            this.blockMineableWithPickaxe().add((Object)material.getChainBlock());
        }
        for (LanternMaterial material : LanternMaterial.values()) {
            if (!material.canBeColored) continue;
            this.addMaterialTag(material);
        }
        for (LanternMaterial material : LanternMaterial.values()) {
            if (material != LanternMaterial.NORMAL) {
                this.itemTag("dynamiclights", "light_level/15").add((Object)material.getLanternBlock().asItem());
            }
            if (!material.canBeColored) continue;
            for (LanternColor color : LanternColor.values()) {
                this.itemTag("dynamiclights", "light_level/15").add((Object)material.getLanternBlock(color).asItem());
            }
        }
    }

    private void addMaterialTag(LanternMaterial material) {
        TagGenerator.TagBuilder tag = this.itemTag(material.getSuffix() + "_lanterns");
        if (material == LanternMaterial.NORMAL) {
            tag.add((Object)Items.LANTERN);
        } else {
            tag.add((Object)material.getLanternBlock().asItem());
        }
        if (material.canBeColored) {
            for (LanternColor color : LanternColor.values()) {
                tag.add((Object)material.getLanternBlock(color).asItem());
            }
        }
    }
}

