/*
 * Decompiled with CFR 0.152.
 */
package net.yxiao233.ifeu.api.block.entity;

import com.google.common.collect.Sets;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IAsset;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.tile.ActiveTile;
import com.hrznstudio.titanium.client.screen.addon.BasicButtonAddon;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.button.ButtonComponent;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.container.addon.IContainerAddon;
import com.hrznstudio.titanium.util.AssetUtil;
import com.hrznstudio.titanium.util.LangUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.yxiao233.ifeu.common.utils.BlackHoleUtil;
import org.jetbrains.annotations.NotNull;

public class IFEUBlackHoleCapacitorEntity
extends ActiveTile<IFEUBlackHoleCapacitorEntity> {
    @Save
    private final EnergyStorageComponent<IFEUBlackHoleCapacitorEntity> energyStorage;
    private boolean showEnergy = true;
    @Save
    public boolean display = true;
    private Rarity rarity;
    private static int maxCap;

    public IFEUBlackHoleCapacitorEntity(BasicTileBlock<IFEUBlackHoleCapacitorEntity> base, BlockEntityType<?> blockEntityType, Rarity rarity, BlockPos pos, BlockState state) {
        super(base, blockEntityType, pos, state);
        this.addButton(new ButtonComponent(142, 80, 18, 18){

            @OnlyIn(value=Dist.CLIENT)
            public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
                return Collections.singletonList(() -> new BasicButtonAddon(this){

                    public void drawBackgroundLayer(GuiGraphics guiGraphics, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
                        AssetUtil.drawAsset((GuiGraphics)guiGraphics, (Screen)screen, (IAsset)provider.getAsset(AssetTypes.ITEM_BACKGROUND), (int)(guiX + this.getPosX()), (int)(guiY + this.getPosY()));
                        guiGraphics.renderItem(new ItemStack((ItemLike)(IFEUBlackHoleCapacitorEntity.this.display ? Items.ENDER_EYE : Items.ENDER_PEARL)), guiX + this.getPosX() + 1, guiY + this.getPosY() + 1);
                    }

                    public List<Component> getTooltipLines() {
                        ArrayList<Component> lines = new ArrayList<Component>();
                        ChatFormatting var10001 = ChatFormatting.GOLD;
                        lines.add((Component)Component.literal((String)(String.valueOf(var10001) + LangUtil.getString((String)("tooltip.industrialforegoing.bl." + (IFEUBlackHoleCapacitorEntity.this.display ? "show_unit_display" : "hide_unit_display")), (Object[])new Object[0]))));
                        return lines;
                    }
                });
            }
        }.setPredicate((playerEntity, compoundNBT) -> {
            this.display = !this.display;
            this.syncObject(this.display);
        }));
        this.rarity = rarity;
        maxCap = BlackHoleUtil.getMaxEnergyCapacityByRarity(rarity);
        this.energyStorage = new EnergyStorageComponent(maxCap, maxCap / 10, 80, 27);
        this.energyStorage.setComponentHarness((IComponentHarness)this);
    }

    public void serverTick(Level level, BlockPos pos, BlockState state, IFEUBlackHoleCapacitorEntity blockEntity) {
        super.serverTick(level, pos, state, (ActiveTile)blockEntity);
        for (Direction facing : Direction.values()) {
            BlockPos checking = this.worldPosition.relative(facing);
            IEnergyStorage storage = (IEnergyStorage)level.getCapability(Capabilities.EnergyStorage.BLOCK, checking, (Object)facing.getOpposite());
            if (storage == null) continue;
            this.getEnergyStorage().extractEnergy(storage.receiveEnergy(this.getEnergyStorage().extractEnergy(maxCap / 10, true), false), false);
        }
        this.syncObject(this.getEnergyStorage());
    }

    public ItemInteractionResult onActivated(Player playerIn, InteractionHand hand, Direction facing, double hitX, double hitY, double hitZ) {
        if (super.onActivated(playerIn, hand, facing, hitX, hitY, hitZ) == ItemInteractionResult.SUCCESS) {
            return ItemInteractionResult.SUCCESS;
        }
        this.openGui(playerIn);
        return ItemInteractionResult.SUCCESS;
    }

    @NotNull
    public IFEUBlackHoleCapacitorEntity getSelf() {
        return this;
    }

    public Component getRenderText() {
        return Component.literal((String)(this.getEnergyStorage().getEnergyStored() + " / " + this.getMaxStorage() + " FE")).withStyle(ChatFormatting.WHITE);
    }

    public int getMaxStorage() {
        return this.getEnergyStorage().getMaxEnergyStored();
    }

    public boolean shouldDisplay() {
        return this.display;
    }

    @Nonnull
    public EnergyStorageComponent<IFEUBlackHoleCapacitorEntity> getEnergyStorage() {
        return this.energyStorage;
    }

    public Set<Direction> getValidEnergyFaces() {
        return Sets.newHashSet((Object[])Direction.values());
    }

    @Nonnull
    public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
        List screenAddons = super.getScreenAddons();
        if (this.showEnergy) {
            screenAddons.addAll(this.getEnergyStorage().getScreenAddons());
        }
        return screenAddons;
    }

    @Nonnull
    public List<IFactory<? extends IContainerAddon>> getContainerAddons() {
        List containerAddons = super.getContainerAddons();
        if (this.showEnergy) {
            containerAddons.addAll(this.getEnergyStorage().getContainerAddons());
        }
        return containerAddons;
    }

    public void setShowEnergy(boolean showEnergy) {
        this.showEnergy = showEnergy;
    }
}

