/*
 * Decompiled with CFR 0.152.
 */
package net.yxiao233.ifeu.api.block.entity;

import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.fluid.SidedFluidTankComponent;
import com.hrznstudio.titanium.component.progress.ProgressBarComponent;
import com.hrznstudio.titanium.module.BlockWithTile;
import java.lang.reflect.Field;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.yxiao233.ifeu.api.block.entity.BetterIndustrialGeneratorTile;
import net.yxiao233.ifeu.common.utils.FluidTankElementsUtil;

public abstract class IFEUFluidFuelGeneratorEntity<T extends IFEUFluidFuelGeneratorEntity<T>>
extends BetterIndustrialGeneratorTile<T> {
    public int getPowerPerTick;
    public int getExtractionRate;
    public int getMaxProgress;
    public int getMaxStoredPower;
    public int maxInputTankSize;
    @Save
    public SidedFluidTankComponent<T> inputFluid;

    public IFEUFluidFuelGeneratorEntity(BlockWithTile blockWithTile, BlockPos blockPos, BlockState blockState) {
        super(blockWithTile, blockPos, blockState);
        this.init();
    }

    public abstract FluidTankElementsUtil getFluidTankElements();

    public abstract Class<?> getGeneratorConfigClass();

    public abstract FluidStack getConsumeFuel();

    public abstract boolean extraStartCondition();

    public void init() {
        int maxInputTankSize;
        int maxStoredPower;
        int maxProgress;
        int extractionRate;
        int powerPerTick;
        try {
            Class<?> clazz = this.getGeneratorConfigClass();
            Field field1 = clazz.getField("powerPerTick");
            Field field2 = clazz.getField("extractionRate");
            Field field3 = clazz.getField("maxProgress");
            Field field4 = clazz.getField("maxStoredPower");
            Field field5 = clazz.getField("maxInputTankSize");
            powerPerTick = field1.getInt(field1.getName());
            extractionRate = field2.getInt(field2.getName());
            maxProgress = field3.getInt(field3.getName());
            maxStoredPower = field4.getInt(field4.getName());
            maxInputTankSize = field5.getInt(field5.getName());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.getPowerPerTick = powerPerTick;
        this.getExtractionRate = extractionRate;
        this.getMaxProgress = maxProgress;
        this.getMaxStoredPower = maxStoredPower;
        this.maxInputTankSize = maxInputTankSize;
        FluidTankElementsUtil util = this.getFluidTankElements();
        this.inputFluid = (SidedFluidTankComponent)new SidedFluidTankComponent(util.getId(), this.maxInputTankSize, util.getXPos(), util.getYPos(), util.getPosition()).setColor(util.getColor()).setTankType(util.getType()).setComponentHarness((IComponentHarness)((IFEUFluidFuelGeneratorEntity)this.getSelf()));
        this.addTank((FluidTankComponent)this.inputFluid);
    }

    @Override
    public int consumeFuel() {
        FluidStack stack = this.getConsumeFuel();
        if (this.inputFluid.getFluid().is(stack.getFluid()) && this.inputFluid.getFluid().getAmount() >= stack.getAmount() && this.extraStartCondition()) {
            this.inputFluid.drainForced(stack, IFluidHandler.FluidAction.EXECUTE);
            return this.getMaxProgress;
        }
        return 0;
    }

    @Override
    public boolean canStart() {
        FluidStack stack = this.getConsumeFuel();
        return this.inputFluid.getFluid().is(stack.getFluid()) && this.inputFluid.getFluid().getAmount() >= stack.getAmount() && this.extraStartCondition();
    }

    @Override
    public int getEnergyProducedEveryTick() {
        int powerPerTick;
        try {
            Class<?> clazz = this.getGeneratorConfigClass();
            Field field4 = clazz.getField("powerPerTick");
            powerPerTick = field4.getInt(field4.getName());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return powerPerTick;
    }

    @Override
    public ProgressBarComponent<T> getProgressBar() {
        return new ProgressBarComponent(30, 20, 0, 15).setComponentHarness((IComponentHarness)((IFEUFluidFuelGeneratorEntity)this.getSelf())).setBarDirection(ProgressBarComponent.BarDirection.VERTICAL_UP).setColor(DyeColor.CYAN);
    }

    @Override
    public int getEnergyCapacity() {
        int maxStoredPower;
        try {
            Class<?> clazz = this.getGeneratorConfigClass();
            Field field4 = clazz.getField("maxStoredPower");
            maxStoredPower = field4.getInt(field4.getName());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return maxStoredPower;
    }

    @Override
    public int getExtractingEnergy() {
        int extractionRate;
        try {
            Class<?> clazz = this.getGeneratorConfigClass();
            Field field4 = clazz.getField("extractionRate");
            extractionRate = field4.getInt(field4.getName());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return extractionRate;
    }
}

