/*
 * Decompiled with CFR 0.152.
 */
package net.yxiao233.ifeu.api.components;

import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IAsset;
import com.hrznstudio.titanium.client.screen.addon.BasicScreenAddon;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.util.AssetUtil;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.yxiao233.ifeu.common.gui.AllGuiTextures;

public abstract class TextureGuiComponent
extends BasicScreenAddon {
    private boolean tooltip = true;
    private boolean itemBackGround = true;

    protected TextureGuiComponent(int x, int y) {
        super(x, y);
    }

    public int getXSize() {
        return this.getTexture().getWidth();
    }

    public int getYSize() {
        return this.getTexture().getHeight();
    }

    public void drawBackgroundLayer(GuiGraphics guiGraphics, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
        if (this.getTexture() != AllGuiTextures.EMPTY && this.itemBackGround) {
            AssetUtil.drawAsset((GuiGraphics)guiGraphics, (Screen)screen, (IAsset)provider.getAsset(AssetTypes.ITEM_BACKGROUND), (int)(guiX + this.getPosX() - 2), (int)(guiY + this.getPosY() - 2));
        }
        this.getTexture().render(guiGraphics, guiX + this.getPosX(), guiY + this.getPosY());
        this.renderTooltip(guiGraphics, guiX, guiY, mouseX, mouseY);
    }

    public void drawForegroundLayer(GuiGraphics guiGraphics, Screen screen, IAssetProvider iAssetProvider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
    }

    public TextureGuiComponent withoutTooltip() {
        this.tooltip = false;
        return this;
    }

    public TextureGuiComponent withoutItemBackGround() {
        this.itemBackGround = false;
        return this;
    }

    public void renderTooltip(GuiGraphics guiGraphics, int guiX, int guiY, int mouseX, int mouseY) {
        if (this.tooltip && this.isMouseOver(guiX, guiY, mouseX, mouseY) && !Objects.equals(this.getComponent(), Component.empty())) {
            guiGraphics.renderTooltip(Minecraft.getInstance().font, this.getComponent(), mouseX, mouseY);
        }
    }

    public boolean isMouseOver(int guiX, int guiY, double mouseX, double mouseY) {
        return mouseX >= (double)this.getPosX() + (double)guiX && mouseX <= (double)(this.getPosX() + guiX + this.getXSize()) && mouseY >= (double)this.getPosY() + (double)guiY && mouseY <= (double)(this.getPosY() + guiY + this.getYSize());
    }

    public abstract AllGuiTextures getTexture();

    public abstract Component getComponent();
}

