/*
 * Decompiled with CFR 0.152.
 */
package net.yxiao233.ifeu.api.structure;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.yxiao233.ifeu.api.structure.MultiBlockStructureBuilder;
import org.apache.commons.lang3.tuple.Pair;

public class MultiBlockStructure {
    public static final Codec<MultiBlockStructure> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.listOf().fieldOf("pattern").forGetter(struct -> List.of(struct.getStructure()[0])), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)BuiltInRegistries.BLOCK.byNameCodec()).fieldOf("blocks").forGetter(struct -> {
        HashMap map = new HashMap();
        struct.defineMap.forEach((k, v) -> map.put(String.valueOf(k), v));
        return map;
    }), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)TagKey.codec((ResourceKey)BuiltInRegistries.BLOCK.key())).fieldOf("tags").forGetter(struct -> {
        HashMap map = new HashMap();
        struct.defineTagMap.forEach((k, v) -> map.put(String.valueOf(k), v));
        return map;
    }), (App)Codec.INT.fieldOf("machineX").orElse((Object)-1).forGetter(struct -> struct.getMachineLocation(struct.getStructure())[0]), (App)Codec.INT.fieldOf("machineY").orElse((Object)-1).forGetter(struct -> struct.getMachineLocation(struct.getStructure())[1]), (App)Codec.INT.fieldOf("machineZ").orElse((Object)-1).forGetter(struct -> struct.getMachineLocation(struct.getStructure())[2])).apply((Applicative)instance, (pattern, blocks, tags, machineX, machineY, machineZ) -> {
        MultiBlockStructureBuilder builder = new MultiBlockStructureBuilder();
        String[][] structurePattern = new String[pattern.size()][];
        for (int i = 0; i < pattern.size(); ++i) {
            structurePattern[i] = new String[]{(String)pattern.get(i)};
        }
        builder.pattern(structurePattern);
        blocks.forEach((k, v) -> builder.define(k.charAt(0), (Block)v));
        tags.forEach((k, v) -> builder.define(k.charAt(0), (TagKey<Block>)v));
        return new MultiBlockStructure(builder);
    }));
    private final HashMap<Character, Block> defineMap;
    private final HashMap<Character, TagKey<Block>> defineTagMap;
    private final MultiBlockStructureBuilder builder;
    private final HashMap<Character, List<Block>> tagBlocksMap;

    public MultiBlockStructure(MultiBlockStructureBuilder builder) {
        this.defineMap = builder.getDefineMap();
        this.defineTagMap = builder.getDefineTagMap();
        this.tagBlocksMap = builder.getTagBlocksMap();
        this.builder = builder;
    }

    public String[][] getStructure() {
        return this.builder.getStructure();
    }

    private boolean tagMapContainsSymbol(char symbol) {
        return this.defineTagMap.containsKey(Character.valueOf(symbol));
    }

    private boolean tagBlocksMapContainsSymbol(char symbol) {
        return this.tagBlocksMap.containsKey(Character.valueOf(symbol));
    }

    private boolean mapContainsSymbol(char symbol) {
        return this.defineMap.containsKey(Character.valueOf(symbol));
    }

    public boolean check(char symbol) {
        return this.mapContainsSymbol(symbol) || this.tagMapContainsSymbol(symbol);
    }

    private int[] getMachineLocation(String[][] structure) {
        int machineX = -1;
        int machineY = -1;
        int machineZ = -1;
        for (int y = 0; y < structure.length; ++y) {
            for (int z = 0; z < structure[y].length; ++z) {
                int x = structure[y][z].indexOf(77);
                if (x == -1) continue;
                machineX = x;
                machineY = y;
                machineZ = z;
                break;
            }
            if (machineX != -1) break;
        }
        return new int[]{machineX, machineY, machineZ};
    }

    private int[] adjustForDirection(int x, int y, int z, Direction direction) {
        int[] nArray;
        switch (direction) {
            case NORTH: {
                int[] nArray2 = new int[3];
                nArray2[0] = -x;
                nArray2[1] = y;
                nArray = nArray2;
                nArray2[2] = -z;
                break;
            }
            case SOUTH: {
                int[] nArray3 = new int[3];
                nArray3[0] = x;
                nArray3[1] = y;
                nArray = nArray3;
                nArray3[2] = z;
                break;
            }
            case WEST: {
                int[] nArray4 = new int[3];
                nArray4[0] = -z;
                nArray4[1] = y;
                nArray = nArray4;
                nArray4[2] = x;
                break;
            }
            case EAST: {
                int[] nArray5 = new int[3];
                nArray5[0] = z;
                nArray5[1] = y;
                nArray = nArray5;
                nArray5[2] = -x;
                break;
            }
            default: {
                int[] nArray6 = new int[3];
                nArray6[0] = x;
                nArray6[1] = y;
                nArray = nArray6;
                nArray6[2] = z;
            }
        }
        return nArray;
    }

    public Block getBlock(char symbol) {
        if (this.mapContainsSymbol(symbol)) {
            return this.defineMap.get(Character.valueOf(symbol));
        }
        return Blocks.AIR;
    }

    public TagKey<Block> getBlockTag(char symbol) {
        if (this.tagMapContainsSymbol(symbol)) {
            return this.defineTagMap.get(Character.valueOf(symbol));
        }
        return null;
    }

    public List<Block> getTagBlocks(char symbol) {
        if (this.tagBlocksMapContainsSymbol(symbol)) {
            return this.tagBlocksMap.get(Character.valueOf(symbol));
        }
        return null;
    }

    public Pair<List<Pair<BlockPos, Block>>, List<Pair<BlockPos, TagKey<Block>>>> parseStructure(Direction direction, BlockPos machinePos) {
        ArrayList<Pair> blockList = new ArrayList<Pair>();
        ArrayList<Pair> tagBlockList = new ArrayList<Pair>();
        String[][] structure = this.getStructure();
        int[] machineLocation = this.getMachineLocation(structure);
        int machineX = machineLocation[0];
        int machineY = machineLocation[1];
        int machineZ = machineLocation[2];
        for (int y = 0; y < structure.length; ++y) {
            for (int z = 0; z < structure[y].length; ++z) {
                String row = structure[y][z];
                for (int x = 0; x < row.length(); ++x) {
                    char blockChar = row.charAt(x);
                    int relativeX = x - machineX;
                    int relativeY = machineY - y;
                    int relativeZ = z - machineZ;
                    int[] relativePos = this.adjustForDirection(relativeX, relativeY, relativeZ, direction);
                    if (this.getBlock(blockChar) != Blocks.AIR) {
                        blockList.add(Pair.of((Object)machinePos.offset(relativePos[0], relativePos[1], relativePos[2]), (Object)this.getBlock(blockChar)));
                    }
                    if (this.getBlockTag(blockChar) == null) continue;
                    tagBlockList.add(Pair.of((Object)machinePos.offset(relativePos[0], relativePos[1], relativePos[2]), this.getBlockTag(blockChar)));
                }
            }
        }
        return Pair.of(blockList, tagBlockList);
    }

    public Pair<List<Pair<BlockPos, Block>>, List<Pair<BlockPos, Pair<List<Block>, TagKey<Block>>>>> getRenderStructure(Direction direction, BlockPos machinePos) {
        ArrayList<Pair> blockList = new ArrayList<Pair>();
        ArrayList<Pair> tagBlockList = new ArrayList<Pair>();
        String[][] structure = this.getStructure();
        int[] machineLocation = this.getMachineLocation(structure);
        int machineX = machineLocation[0];
        int machineY = machineLocation[1];
        int machineZ = machineLocation[2];
        for (int y = 0; y < structure.length; ++y) {
            for (int z = 0; z < structure[y].length; ++z) {
                String row = structure[y][z];
                for (int x = 0; x < row.length(); ++x) {
                    char blockChar = row.charAt(x);
                    int relativeX = x - machineX;
                    int relativeY = machineY - y;
                    int relativeZ = z - machineZ;
                    int[] relativePos = this.adjustForDirection(relativeX, relativeY, relativeZ, direction);
                    if (this.getBlock(blockChar) != Blocks.AIR) {
                        blockList.add(Pair.of((Object)machinePos.offset(relativePos[0], relativePos[1], relativePos[2]), (Object)this.getBlock(blockChar)));
                    }
                    if (this.getTagBlocks(blockChar) == null) continue;
                    tagBlockList.add(Pair.of((Object)machinePos.offset(relativePos[0], relativePos[1], relativePos[2]), (Object)Pair.of(this.getTagBlocks(blockChar), this.getBlockTag(blockChar))));
                }
            }
        }
        return Pair.of(blockList, tagBlockList);
    }

    public boolean checkStructure(Level level, Direction direction, BlockPos machinePos) {
        if (!level.isClientSide()) {
            Pair pair;
            int m;
            Pair<List<Pair<BlockPos, Block>>, List<Pair<BlockPos, TagKey<Block>>>> poses = this.parseStructure(direction, machinePos);
            AtomicInteger i = new AtomicInteger(0);
            int max = ((List)poses.getRight()).size() + ((List)poses.getLeft()).size();
            for (m = 0; m < ((List)poses.getRight()).size(); ++m) {
                pair = (Pair)((List)poses.getRight()).get(m);
                if (!level.getBlockState((BlockPos)pair.getLeft()).is((TagKey)pair.getRight())) {
                    return false;
                }
                i.getAndIncrement();
            }
            for (m = 0; m < ((List)poses.getLeft()).size(); ++m) {
                pair = (Pair)((List)poses.getLeft()).get(m);
                if (!level.getBlockState((BlockPos)pair.getLeft()).is((Block)pair.getRight())) {
                    return false;
                }
                i.getAndIncrement();
            }
            return i.get() == max;
        }
        return false;
    }

    public int getShouldRenderMinY(Level level, Direction direction, BlockPos machinePos) {
        Pair<List<Pair<BlockPos, Block>>, List<Pair<BlockPos, TagKey<Block>>>> list = this.parseStructure(direction, machinePos);
        AtomicInteger minBlockY = new AtomicInteger(level.getMaxBuildHeight());
        AtomicInteger minTagBlockY = new AtomicInteger(level.getMaxBuildHeight());
        ((List)list.getLeft()).forEach(pair -> {
            if (!level.getBlockState((BlockPos)pair.getLeft()).is((Block)pair.getRight())) {
                minBlockY.set(Math.min(((BlockPos)pair.getLeft()).getY(), minBlockY.get()));
            }
        });
        ((List)list.getRight()).forEach(pair -> {
            if (!level.getBlockState((BlockPos)pair.getLeft()).is((TagKey)pair.getRight())) {
                minTagBlockY.set(Math.min(((BlockPos)pair.getLeft()).getY(), minTagBlockY.get()));
            }
        });
        return Math.min(minBlockY.get(), minTagBlockY.get());
    }

    public List<MutableComponent> getMaterialList() {
        HashMap<Character, Integer> map = new HashMap<Character, Integer>();
        String[][] structure = this.getStructure();
        ArrayList<MutableComponent> components = new ArrayList<MutableComponent>();
        for (int i = 0; i < structure.length; ++i) {
            for (int m = 0; m < structure[i].length; ++m) {
                char[] chars = structure[i][m].toCharArray();
                for (int n = 0; n < chars.length; ++n) {
                    char c = chars[n];
                    if (map.containsKey(Character.valueOf(c))) {
                        int value = (Integer)map.get(Character.valueOf(c));
                        map.merge(Character.valueOf(c), value + 1, (oldValue, newValue) -> newValue);
                        continue;
                    }
                    map.put(Character.valueOf(c), 1);
                }
            }
        }
        map.forEach((character, integer) -> {
            if (this.mapContainsSymbol(character.charValue())) {
                ItemStack stack = new ItemStack((ItemLike)this.getBlock(character.charValue()), integer.intValue());
                components.add(Component.literal((String)(integer + "x ")).append((Component)Component.translatable((String)stack.getDescriptionId())));
            } else if (this.tagMapContainsSymbol(character.charValue())) {
                String tag = this.getBlockTag(character.charValue()).location().toString();
                components.add(Component.literal((String)(integer + "x " + tag)));
            }
        });
        return components;
    }

    public Pair<List<ItemStack>, List<Pair<TagKey<Block>, Integer>>> materialListForJei() {
        HashMap<Character, Integer> map = new HashMap<Character, Integer>();
        String[][] structure = this.getStructure();
        ArrayList stacks = new ArrayList();
        ArrayList tags = new ArrayList();
        for (int i = 0; i < structure.length; ++i) {
            for (int m = 0; m < structure[i].length; ++m) {
                char[] chars = structure[i][m].toCharArray();
                for (int n = 0; n < chars.length; ++n) {
                    char c = chars[n];
                    if (map.containsKey(Character.valueOf(c))) {
                        int value = (Integer)map.get(Character.valueOf(c));
                        map.merge(Character.valueOf(c), value + 1, (oldValue, newValue) -> newValue);
                        continue;
                    }
                    map.put(Character.valueOf(c), 1);
                }
            }
        }
        map.forEach((character, integer) -> {
            if (this.mapContainsSymbol(character.charValue())) {
                ItemStack stack = new ItemStack((ItemLike)this.getBlock(character.charValue()), integer.intValue());
                stacks.add(stack);
            } else if (this.tagMapContainsSymbol(character.charValue())) {
                TagKey<Block> tag = this.getBlockTag(character.charValue());
                tags.add(Pair.of(tag, (Object)integer));
            }
        });
        return Pair.of(stacks, tags);
    }
}

