/*
 * Decompiled with CFR 0.152.
 */
package net.yxiao233.ifeu.api.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.yxiao233.ifeu.api.structure.MultiBlockStructure;

public class MultiBlockStructureBuilder {
    private final ArrayList<ArrayList<String>> structure = new ArrayList();
    private final HashMap<Character, Block> defineMap = new HashMap();
    private final HashMap<Character, TagKey<Block>> defineTagMap = new HashMap();
    private final HashMap<Character, List<Block>> tagBlocksMap = new HashMap();

    public MultiBlockStructureBuilder pattern(ArrayList<String> s) {
        this.structure.add(s);
        return this;
    }

    public MultiBlockStructureBuilder pattern(String[][] s) {
        for (int i = 0; i < s.length; ++i) {
            this.structure.add(new ArrayList<String>(Arrays.asList(s[i])));
        }
        return this;
    }

    public MultiBlockStructureBuilder pattern(String ... strings) {
        this.structure.add(new ArrayList<String>(Arrays.asList(strings)));
        return this;
    }

    public MultiBlockStructureBuilder pattern(List<String> s) {
        this.structure.add(new ArrayList<String>(s));
        return this;
    }

    public String[][] getStructure() {
        int size1 = this.structure.size();
        int size2 = this.structure.get(0).size();
        String[][] temp = new String[size1][size2];
        for (int i = 0; i < temp.length; ++i) {
            for (int m = 0; m < temp[i].length; ++m) {
                temp[i][m] = this.structure.get(i).get(m);
            }
        }
        return temp;
    }

    public MultiBlockStructureBuilder define(char symbol, Block block) {
        this.defineMap.put(Character.valueOf(symbol), block);
        return this;
    }

    public MultiBlockStructureBuilder define(char symbol, TagKey<Block> blockTag) {
        this.defineTagMap.put(Character.valueOf(symbol), blockTag);
        this.tagBlocksMap.put(Character.valueOf(symbol), this.getBlocksFromTagKey(blockTag));
        return this;
    }

    public MultiBlockStructureBuilder define(char symbol, DeferredHolder<Block, Block> block) {
        this.define(symbol, (Block)block.get());
        return this;
    }

    public HashMap<Character, Block> getDefineMap() {
        return this.defineMap;
    }

    public HashMap<Character, TagKey<Block>> getDefineTagMap() {
        return this.defineTagMap;
    }

    public HashMap<Character, List<Block>> getTagBlocksMap() {
        return this.tagBlocksMap;
    }

    public MultiBlockStructure build() {
        return new MultiBlockStructure(this);
    }

    private List<Block> getBlocksFromTagKey(TagKey<Block> blockTag) {
        ArrayList<Block> list = new ArrayList<Block>();
        BuiltInRegistries.BLOCK.forEach(reg -> {
            if (reg.defaultBlockState().is(blockTag)) {
                list.add((Block)reg);
            }
        });
        return list;
    }
}

