/*
 * Decompiled with CFR 0.152.
 */
package net.yxiao233.ifeu.common.block.entity;

import com.buuz135.industrial.config.machine.core.DissolutionChamberConfig;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.recipe.DissolutionChamberRecipe;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.block.tile.BasicTile;
import com.hrznstudio.titanium.component.IComponentBundle;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.bundle.LockableInventoryBundle;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.fluid.SidedFluidTankComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import com.hrznstudio.titanium.util.RecipeUtil;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.yxiao233.ifeu.api.block.entity.IFEUStructureProcessingTile;
import net.yxiao233.ifeu.api.item.IFEUAddonItem;
import net.yxiao233.ifeu.api.item.IFEUAugmentTypes;
import net.yxiao233.ifeu.api.structure.MultiBlockStructure;
import net.yxiao233.ifeu.common.config.machine.BigDissolutionChamberConfig;
import net.yxiao233.ifeu.common.registry.ModBlocks;
import net.yxiao233.ifeu.common.structure.IFEUMultiBlockStructures;
import net.yxiao233.ifeu.common.utils.AugmentInventoryHelper;
import net.yxiao233.ifeu.common.utils.InventoryComponentHelper;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class BigDissolutionChamberEntity
extends IFEUStructureProcessingTile<BigDissolutionChamberEntity> {
    private int maxProgress;
    private int powerPerTick;
    private int defaultMaxThread;
    @Save
    private LockableInventoryBundle<BigDissolutionChamberEntity> input;
    @Save
    private SidedFluidTankComponent<BigDissolutionChamberEntity> inputFluid;
    @Save
    private SidedInventoryComponent<BigDissolutionChamberEntity> output;
    @Save
    private SidedFluidTankComponent<BigDissolutionChamberEntity> outputFluid;
    private DissolutionChamberRecipe currentRecipe;

    public BigDissolutionChamberEntity(BlockPos blockPos, BlockState blockState) {
        super(ModBlocks.BIG_DISSOLUTION_CHAMBER_CORE, 102, 41, blockPos, blockState);
        int slotSpacing = 22;
        this.input = new LockableInventoryBundle((BasicTile)this, new SidedInventoryComponent("input", 34, 19, 8, 0).setColor(DyeColor.LIGHT_BLUE).setSlotPosition(BigDissolutionChamberEntity::getSlotPos).setOutputFilter((stack, integer) -> false).setComponentHarness((IComponentHarness)this).setInputFilter((stack, integer) -> !this.canIncrease()).setOnSlotChanged((stack, integer) -> this.checkForRecipe()), 100, 64, false);
        this.addBundle((IComponentBundle)this.input);
        this.inputFluid = (SidedFluidTankComponent)new SidedFluidTankComponent("input_fluid", BigDissolutionChamberConfig.maxInputTankSize, 33 + slotSpacing, 18 + slotSpacing, 1).setColor(DyeColor.LIME).setTankType(FluidTankComponent.Type.SMALL).setComponentHarness((IComponentHarness)this).setOnContentChange(this::checkForRecipe);
        this.addTank((FluidTankComponent)this.inputFluid);
        this.output = (SidedInventoryComponent)new SidedInventoryComponent("output", 129, 22, 3, 2).setColor(DyeColor.ORANGE).setRange(1, 3).setInputFilter((stack, integer) -> false).setComponentHarness((IComponentHarness)this);
        this.addInventory((InventoryComponent)this.output);
        this.outputFluid = (SidedFluidTankComponent)new SidedFluidTankComponent("output_fluid", BigDissolutionChamberConfig.maxOutputTankSize, 149, 20, 3).setColor(DyeColor.MAGENTA).setComponentHarness((IComponentHarness)this).setTankAction(FluidTankComponent.Action.DRAIN);
        this.addTank((FluidTankComponent)this.outputFluid);
        this.maxProgress = BigDissolutionChamberConfig.maxProgress;
        this.powerPerTick = BigDissolutionChamberConfig.powerPerTick;
        this.defaultMaxThread = BigDissolutionChamberConfig.maxThread;
    }

    private void checkForRecipe() {
        if (this.isServer()) {
            if (!this.hasCurrentStructure) {
                this.currentRecipe = null;
                return;
            }
            if (this.currentRecipe != null && this.currentRecipe.matches((IItemHandler)this.input.getInventory(), this.inputFluid)) {
                return;
            }
            this.currentRecipe = RecipeUtil.getRecipes((Level)this.level, (RecipeType)((RecipeType)ModuleCore.DISSOLUTION_TYPE.get())).stream().filter(recipe -> recipe.matches((IItemHandler)this.input.getInventory(), this.inputFluid)).findFirst().orElse(null);
        }
    }

    public boolean canAcceptAugment(ItemStack augment) {
        if (augment.getItem() instanceof IFEUAddonItem) {
            return AugmentInventoryHelper.canAccept(this.getAugmentInventory(), augment);
        }
        return super.canAcceptAugment(augment);
    }

    public void setChanged() {
        super.setChanged();
        this.checkForRecipe();
    }

    public void setLevel(Level level) {
        super.setLevel(level);
        this.checkForRecipe();
    }

    public boolean canIncrease() {
        return this.hasCurrentStructure && this.currentRecipe != null && ItemHandlerHelper.insertItem(this.output, (ItemStack)this.currentRecipe.output.orElse(ItemStack.EMPTY).copy(), (boolean)true).isEmpty() && (this.currentRecipe.outputFluid.isEmpty() || this.outputFluid.fillForced(this.currentRecipe.outputFluid.orElse(FluidStack.EMPTY).copy(), IFluidHandler.FluidAction.SIMULATE) == this.currentRecipe.outputFluid.orElse(FluidStack.EMPTY).getAmount());
    }

    public Runnable onFinish() {
        return () -> {
            if (this.currentRecipe != null) {
                DissolutionChamberRecipe dissolutionChamberRecipe = this.currentRecipe;
                int thread = Math.min(this.getCurThread(dissolutionChamberRecipe), this.getMaxOutputThread());
                Optional<FluidStack> optionalInputFluid = Arrays.stream(dissolutionChamberRecipe.inputFluid.getFluids()).findFirst();
                if (optionalInputFluid.isPresent()) {
                    this.inputFluid.drainForced(new FluidStack(optionalInputFluid.get().getFluid(), optionalInputFluid.get().getAmount() * thread), IFluidHandler.FluidAction.EXECUTE);
                    for (int i = 0; i < this.input.getInventory().getSlots(); ++i) {
                        this.input.getInventory().getStackInSlot(i).shrink(thread);
                    }
                    if (dissolutionChamberRecipe.outputFluid.isPresent()) {
                        this.outputFluid.fillForced(new FluidStack(((FluidStack)dissolutionChamberRecipe.outputFluid.get()).getFluid(), ((FluidStack)dissolutionChamberRecipe.outputFluid.get()).getAmount() * thread), IFluidHandler.FluidAction.EXECUTE);
                    }
                    if (dissolutionChamberRecipe.output.isPresent()) {
                        ItemStack outputStack = ((ItemStack)dissolutionChamberRecipe.output.get()).copy();
                        outputStack.getItem().onCraftedBy(outputStack, this.level, (Player)null);
                        ItemHandlerHelper.insertItem(this.output, (ItemStack)new ItemStack((ItemLike)outputStack.getItem(), outputStack.getCount() * thread), (boolean)false);
                    }
                    this.checkForRecipe();
                }
            }
        };
    }

    public int getCurThread(DissolutionChamberRecipe recipe) {
        Optional<FluidStack> optionalInputFluid;
        int thread = this.getMaxOutputThread();
        for (int i = 0; i < this.input.getInventory().getSlots(); ++i) {
            if (this.input.getInventory().getStackInSlot(i).isEmpty()) continue;
            thread = Math.min(this.input.getInventory().getStackInSlot(i).getCount(), thread);
        }
        if (recipe.output.isPresent()) {
            int max = InventoryComponentHelper.canInsetMaxCount(this.output, new ItemStack((ItemLike)((ItemStack)recipe.output.get()).getItem(), thread));
            thread = Math.min(thread, max);
        }
        if ((optionalInputFluid = Arrays.stream(recipe.inputFluid.getFluids()).findFirst()).isPresent()) {
            int fluidAmount = this.inputFluid.getFluid().getAmount();
            int recipeNeededFluid = optionalInputFluid.get().getAmount();
            int n = thread = recipeNeededFluid * thread <= fluidAmount ? thread : fluidAmount / recipeNeededFluid;
        }
        if (recipe.outputFluid.isPresent()) {
            int remainingOutputCapacity = this.outputFluid.getCapacity() - this.outputFluid.getFluidAmount();
            int outputFluidAmount = ((FluidStack)recipe.outputFluid.get()).copy().getAmount();
            thread = outputFluidAmount * thread <= remainingOutputCapacity ? thread : remainingOutputCapacity / outputFluidAmount;
        }
        return thread;
    }

    public int getMaxOutputThread() {
        int tier = AugmentInventoryHelper.getAugmentTier(this.getAugmentInventory(), IFEUAugmentTypes.THREAD);
        return tier * 4 + this.defaultMaxThread;
    }

    protected EnergyStorageComponent<BigDissolutionChamberEntity> createEnergyStorage() {
        return new EnergyStorageComponent(DissolutionChamberConfig.maxStoredPower, 10, 20);
    }

    protected int getTickPower() {
        return this.powerPerTick;
    }

    public int getMaxProgress() {
        return this.currentRecipe != null ? this.currentRecipe.processingTime : this.maxProgress;
    }

    public static Pair<Integer, Integer> getSlotPos(int slot) {
        int slotSpacing = 22;
        int offset = 2;
        switch (slot) {
            case 1: {
                return Pair.of((Object)slotSpacing, (Object)(-offset));
            }
            case 2: {
                return Pair.of((Object)(slotSpacing * 2), (Object)0);
            }
            case 3: {
                return Pair.of((Object)(-offset), (Object)slotSpacing);
            }
            case 4: {
                return Pair.of((Object)(slotSpacing * 2 + offset), (Object)slotSpacing);
            }
            case 5: {
                return Pair.of((Object)0, (Object)(slotSpacing * 2));
            }
            case 6: {
                return Pair.of((Object)slotSpacing, (Object)(slotSpacing * 2 + offset));
            }
            case 7: {
                return Pair.of((Object)(slotSpacing * 2), (Object)(slotSpacing * 2));
            }
        }
        return Pair.of((Object)0, (Object)0);
    }

    @NotNull
    public BigDissolutionChamberEntity getSelf() {
        return this;
    }

    @Override
    public void loadSettings(Player player, CompoundTag tag) {
        if (tag.contains("BDC_locked")) {
            this.input.setLocked(tag.getBoolean("BDC_locked"));
        }
        if (tag.contains("BDC_filter")) {
            for (String psFilter : tag.getCompound("BDC_filter").getAllKeys()) {
                this.input.getFilter()[Integer.parseInt((String)psFilter)] = ItemStack.parseOptional((HolderLookup.Provider)this.level.registryAccess(), (CompoundTag)tag.getCompound("BDC_filter").getCompound(psFilter));
            }
        }
        super.loadSettings(player, tag);
    }

    @Override
    public void saveSettings(Player player, CompoundTag tag) {
        tag.putBoolean("BDC_locked", this.input.isLocked());
        CompoundTag filterTag = new CompoundTag();
        for (int i = 0; i < this.input.getFilter().length; ++i) {
            filterTag.put("" + i, this.input.getFilter()[i].saveOptional((HolderLookup.Provider)this.level.registryAccess()));
        }
        tag.put("BDC_filter", (Tag)filterTag);
        super.saveSettings(player, tag);
    }

    @Override
    public MultiBlockStructure multiBlockStructure() {
        return IFEUMultiBlockStructures.BIG_DISSOLUTION_CHAMBER.getStructure();
    }

    @Override
    public int[] setStructureFormingPosition() {
        return new int[]{152, 4};
    }
}

