/*
 * Decompiled with CFR 0.152.
 */
package net.yxiao233.ifeu.common.compact.jei;

import com.buuz135.industrial.plugin.jei.IndustrialRecipeTypes;
import com.hrznstudio.titanium.container.BasicAddonContainer;
import com.hrznstudio.titanium.util.RecipeUtil;
import java.util.ArrayList;
import java.util.Collections;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.yxiao233.ifeu.common.compact.jei.ModRecipeType;
import net.yxiao233.ifeu.common.compact.jei.category.ArcaneDragonEggForgingCategory;
import net.yxiao233.ifeu.common.compact.jei.category.BlockRightClickCategory;
import net.yxiao233.ifeu.common.compact.jei.category.DragonGeneratorCategory;
import net.yxiao233.ifeu.common.compact.jei.category.DragonStarGeneratorCategory;
import net.yxiao233.ifeu.common.compact.jei.category.InfuserCategory;
import net.yxiao233.ifeu.common.compact.jei.category.ShapedCategory;
import net.yxiao233.ifeu.common.compact.jei.category.ShapelessCategory;
import net.yxiao233.ifeu.common.compact.jei.category.StructureInfoCategory;
import net.yxiao233.ifeu.common.config.machine.DragonGeneratorConfig;
import net.yxiao233.ifeu.common.config.machine.DragonStarGeneratorConfig;
import net.yxiao233.ifeu.common.recipe.BlockRightClickRecipe;
import net.yxiao233.ifeu.common.recipe.DragonGeneratorRecipe;
import net.yxiao233.ifeu.common.recipe.DragonStarGeneratorRecipe;
import net.yxiao233.ifeu.common.recipe.InfuserRecipe;
import net.yxiao233.ifeu.common.recipe.StructureInfoRecipe;
import net.yxiao233.ifeu.common.registry.ModBlocks;
import net.yxiao233.ifeu.common.registry.ModContents;
import net.yxiao233.ifeu.common.registry.ModFluids;
import net.yxiao233.ifeu.common.registry.ModRecipes;
import net.yxiao233.ifeu.common.structure.IFEUMultiBlockStructures;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"ifeu", (String)"jei_plugin");
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        jeiRuntime.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, Collections.singletonList(new ItemStack((ItemLike)ModContents.AIR.get())));
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new InfuserCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new ArcaneDragonEggForgingCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new BlockRightClickCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new DragonStarGeneratorCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new ShapedCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new ShapelessCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new DragonGeneratorCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new StructureInfoCategory(guiHelper)});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        this.addInfuserCompactRecipes(registration);
        this.addBlockRightClickRecipes(registration);
        this.addDragonStarGenerator(registration);
        this.addDragonGeneratorRecipe(registration);
        this.addStructureInfoRecipe(registration);
        ClientLevel level = Minecraft.getInstance().level;
        registration.addRecipes(ModRecipeType.INFUSER, RecipeUtil.getRecipes((Level)level, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)ModRecipes.INFUSER_TYPE.get())));
        registration.addRecipes(ModRecipeType.ARCANE_DRAGON_EGG_FORGING, RecipeUtil.getRecipes((Level)level, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)ModRecipes.ARCANE_DRAGON_EGG_FORGING_TYPE.get())));
        registration.addRecipes(ModRecipeType.BLOCK_RIGHT_CLICK, RecipeUtil.getRecipes((Level)level, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)ModRecipes.BLOCK_RIGHT_CLICK_TYPE.get())));
        registration.addRecipes(ModRecipeType.DRAGON_STAR_GENERATOR, RecipeUtil.getRecipes((Level)level, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)ModRecipes.DRAGON_STAR_GENERATOR_TYPE.get())));
        registration.addRecipes(ModRecipeType.SHAPED, RecipeUtil.getRecipes((Level)level, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)ModRecipes.SHAPED_TYPE.get())));
        registration.addRecipes(ModRecipeType.SHAPELESS, RecipeUtil.getRecipes((Level)level, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)ModRecipes.SHAPELESS_TYPE.get())));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((ItemLike)ModBlocks.INFUSER, new RecipeType[]{ModRecipeType.INFUSER});
        registration.addRecipeCatalyst((ItemLike)ModBlocks.ARCANE_DRAGON_EGG_FORGING, new RecipeType[]{ModRecipeType.ARCANE_DRAGON_EGG_FORGING});
        registration.addRecipeCatalyst((ItemLike)Blocks.DRAGON_EGG, new RecipeType[]{ModRecipeType.BLOCK_RIGHT_CLICK});
        registration.addRecipeCatalyst((ItemLike)ModBlocks.DRAGON_STAR_GENERATOR, new RecipeType[]{ModRecipeType.DRAGON_STAR_GENERATOR});
        registration.addRecipeCatalyst((ItemLike)ModBlocks.FLUID_CRAFTING_TABLE, new RecipeType[]{ModRecipeType.SHAPED});
        registration.addRecipeCatalyst((ItemLike)ModBlocks.FLUID_CRAFTING_TABLE, new RecipeType[]{ModRecipeType.SHAPELESS});
        registration.addRecipeCatalyst((ItemLike)ModBlocks.DRAGON_GENERATOR, new RecipeType[]{ModRecipeType.DRAGON_GENERATOR});
        registration.addRecipeCatalyst((ItemLike)ModBlocks.BIG_DISSOLUTION_CHAMBER_CORE, new RecipeType[]{IndustrialRecipeTypes.DISSOLUTION});
        ArrayList items = new ArrayList();
        IFEUMultiBlockStructures.values.forEach((id, structure) -> {
            if (!items.contains(structure.getMachine())) {
                registration.addRecipeCatalyst((ItemLike)structure.getMachine(), new RecipeType[]{ModRecipeType.STRUCTURE});
            }
            items.add(structure.getMachine());
        });
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(BasicAddonContainer.class, null, ModRecipeType.SHAPED, 4, 9, 16, 36);
        registration.addRecipeTransferHandler(BasicAddonContainer.class, null, ModRecipeType.SHAPELESS, 4, 9, 16, 36);
        registration.addRecipeTransferHandler(BasicAddonContainer.class, null, IndustrialRecipeTypes.DISSOLUTION, 4, 8, 17, 36);
    }

    private void addInfuserCompactRecipes(IRecipeRegistration registration) {
        ArrayList infuserRecipes = new ArrayList();
        BuiltInRegistries.ITEM.stream().forEach(reg -> {
            if (reg instanceof MobBucketItem || reg.getDefaultInstance().is(Items.BUCKET)) {
                return;
            }
            if (reg instanceof BucketItem) {
                BucketItem bucketItem = (BucketItem)reg;
                FluidStack fluidStack = new FluidStack(bucketItem.content, 1000);
                if (!fluidStack.isEmpty()) {
                    infuserRecipes.add(new InfuserRecipe(Items.BUCKET.getDefaultInstance(), fluidStack, 200, bucketItem.getDefaultInstance()));
                }
            }
        });
        registration.addRecipes(ModRecipeType.INFUSER, infuserRecipes);
    }

    private void addBlockRightClickRecipes(IRecipeRegistration registration) {
        ArrayList<BlockRightClickRecipe> blockRightClickRecipes = new ArrayList<BlockRightClickRecipe>();
        blockRightClickRecipes.add(new BlockRightClickRecipe(((Item)ModContents.DRAGON_STAR.get()).getDefaultInstance(), (Block)ModContents.DEAD_DRAGON_EGG.get(), Blocks.DRAGON_EGG));
        registration.addRecipes(ModRecipeType.BLOCK_RIGHT_CLICK, blockRightClickRecipes);
    }

    private void addDragonStarGenerator(IRecipeRegistration registration) {
        ArrayList<DragonStarGeneratorRecipe> dragonStarGeneratorCategories = new ArrayList<DragonStarGeneratorRecipe>();
        dragonStarGeneratorCategories.add(new DragonStarGeneratorRecipe(((Item)ModContents.DRAGON_STAR.get()).getDefaultInstance(), DragonStarGeneratorConfig.maxProgress, DragonStarGeneratorConfig.powerPerTick));
        registration.addRecipes(ModRecipeType.DRAGON_STAR_GENERATOR, dragonStarGeneratorCategories);
    }

    private void addDragonGeneratorRecipe(IRecipeRegistration registration) {
        ArrayList<DragonGeneratorRecipe> dragonGeneratorRecipes = new ArrayList<DragonGeneratorRecipe>();
        dragonGeneratorRecipes.add(new DragonGeneratorRecipe(new FluidStack((Fluid)ModFluids.LIQUID_DRAGON_BREATH.getSourceFluid().get(), 1000), DragonGeneratorConfig.maxProgress, DragonGeneratorConfig.powerPerTick));
        registration.addRecipes(ModRecipeType.DRAGON_GENERATOR, dragonGeneratorRecipes);
    }

    private void addStructureInfoRecipe(IRecipeRegistration registration) {
        ArrayList structureRecipes = new ArrayList();
        ArrayList items = new ArrayList();
        IFEUMultiBlockStructures.values.forEach((id, structure) -> {
            if (!items.contains(structure.getMachine())) {
                structureRecipes.add(new StructureInfoRecipe((IFEUMultiBlockStructures)structure));
            }
            items.add(structure.getMachine());
        });
        registration.addRecipes(ModRecipeType.STRUCTURE, structureRecipes);
    }
}

