/*
 * Decompiled with CFR 0.152.
 */
package net.yxiao233.ifeu.common.recipe;

import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ItemExistsCondition;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.yxiao233.ifeu.common.registry.ModBlocks;
import net.yxiao233.ifeu.common.registry.ModRecipes;

public class ArcaneDragonEggForgingRecipe
implements Recipe<CraftingInput> {
    public static final MapCodec<ArcaneDragonEggForgingRecipe> CODEC = RecordCodecBuilder.mapCodec(in -> in.group((App)ItemStack.CODEC.fieldOf("input").forGetter(o -> o.input), (App)FluidStack.CODEC.fieldOf("inputFluid1").forGetter(o -> o.inputFluid1), (App)FluidStack.CODEC.fieldOf("inputFluid2").forGetter(o -> o.inputFluid2), (App)Codec.INT.fieldOf("processingTime").forGetter(o -> o.processingTime), (App)ItemStack.CODEC.optionalFieldOf("output").forGetter(o -> o.output), (App)FluidStack.CODEC.optionalFieldOf("outputFluid").forGetter(o -> o.outputFluid)).apply((Applicative)in, ArcaneDragonEggForgingRecipe::new));
    public ItemStack input;
    public FluidStack inputFluid1;
    public FluidStack inputFluid2;
    public int processingTime;
    public Optional<ItemStack> output;
    public Optional<FluidStack> outputFluid;

    public ArcaneDragonEggForgingRecipe() {
    }

    public ArcaneDragonEggForgingRecipe(ItemStack input, FluidStack inputFluid1, FluidStack inputFluid2, int processingTime, Optional<ItemStack> output, Optional<FluidStack> outputFluid) {
        this.input = input;
        this.inputFluid1 = inputFluid1;
        this.inputFluid2 = inputFluid2;
        this.processingTime = processingTime;
        this.output = output;
        this.outputFluid = outputFluid;
    }

    public static void createRecipe(RecipeOutput recipeOutput, String name, ArcaneDragonEggForgingRecipe recipe) {
        ResourceLocation rl = ArcaneDragonEggForgingRecipe.generateRL(name);
        AdvancementHolder advancementHolder = recipeOutput.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)rl)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)rl)).requirements(AdvancementRequirements.Strategy.OR).build(rl);
        ArrayList<ItemExistsCondition> conditions = new ArrayList<ItemExistsCondition>();
        if (recipe.output.isPresent()) {
            conditions.add(new ItemExistsCondition(BuiltInRegistries.ITEM.getKey((Object)recipe.output.get().getItem())));
        }
        recipeOutput.accept(rl, (Recipe)recipe, advancementHolder, conditions.toArray(new ICondition[conditions.size()]));
    }

    public static ResourceLocation generateRL(String key) {
        return ResourceLocation.fromNamespaceAndPath((String)"ifeu", (String)("arcane_dragon_egg_forging/" + key));
    }

    public boolean matches(IItemHandler handler, FluidTankComponent tank1, FluidTankComponent tank2) {
        if (this.input == null && tank1 == null && tank2 == null && this.inputFluid1 == null && this.inputFluid2 == null) {
            return false;
        }
        if (!ItemStack.isSameItem((ItemStack)handler.getStackInSlot(0), (ItemStack)this.input)) {
            return false;
        }
        boolean if1 = tank1.drainForced(this.inputFluid1, IFluidHandler.FluidAction.SIMULATE).getAmount() == this.inputFluid1.getAmount();
        boolean if2 = tank2.drainForced(this.inputFluid2, IFluidHandler.FluidAction.SIMULATE).getAmount() == this.inputFluid2.getAmount();
        return if1 && if2;
    }

    public boolean matches(CraftingInput craftingInput, Level level) {
        return false;
    }

    public ItemStack assemble(CraftingInput craftingInput, HolderLookup.Provider provider) {
        return null;
    }

    public boolean canCraftInDimensions(int i, int i1) {
        return false;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.output.orElse(ItemStack.EMPTY).copy();
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)ModBlocks.ARCANE_DRAGON_EGG_FORGING);
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipes.ARCANE_DRAGON_EGG_FORGING_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ModRecipes.ARCANE_DRAGON_EGG_FORGING_TYPE.get();
    }
}

