/*
 * Decompiled with CFR 0.152.
 */
package net.yxiao233.ifeu.common.recipe;

import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.yxiao233.ifeu.common.registry.ModBlocks;
import net.yxiao233.ifeu.common.registry.ModRecipes;

public class InfuserRecipe
implements Recipe<CraftingInput> {
    public static final MapCodec<InfuserRecipe> CODEC = RecordCodecBuilder.mapCodec(in -> in.group((App)ItemStack.CODEC.fieldOf("input").forGetter(o -> o.input), (App)FluidStack.CODEC.fieldOf("inputFluid").forGetter(o -> o.inputFluid), (App)Codec.INT.fieldOf("processingTime").forGetter(o -> o.processingTime), (App)ItemStack.CODEC.fieldOf("output").forGetter(o -> o.output)).apply((Applicative)in, InfuserRecipe::new));
    public ItemStack input;
    public FluidStack inputFluid;
    public int processingTime;
    public ItemStack output;

    public InfuserRecipe() {
    }

    public InfuserRecipe(ItemStack input, FluidStack inputFluid, int processingTime, ItemStack output) {
        this.input = input;
        this.inputFluid = inputFluid;
        this.processingTime = processingTime;
        this.output = output;
    }

    public static void createRecipe(RecipeOutput recipeOutput, String name, InfuserRecipe recipe) {
        ResourceLocation rl = InfuserRecipe.generateRL(name);
        AdvancementHolder advancementHolder = recipeOutput.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)rl)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)rl)).requirements(AdvancementRequirements.Strategy.OR).build(rl);
        recipeOutput.accept(rl, (Recipe)recipe, advancementHolder);
    }

    public static ResourceLocation generateRL(String key) {
        return ResourceLocation.fromNamespaceAndPath((String)"ifeu", (String)("infuser/" + key));
    }

    public boolean matches(IItemHandler handler, FluidTankComponent tank) {
        if (this.input == null && tank == null && this.inputFluid == null) {
            return false;
        }
        if (!ItemStack.isSameItem((ItemStack)handler.getStackInSlot(0), (ItemStack)this.input)) {
            return false;
        }
        return tank.drainForced(this.inputFluid, IFluidHandler.FluidAction.SIMULATE).getAmount() == this.inputFluid.getAmount();
    }

    public boolean matches(CraftingInput craftingInput, Level level) {
        return false;
    }

    public ItemStack assemble(CraftingInput craftingInput, HolderLookup.Provider provider) {
        return null;
    }

    public boolean canCraftInDimensions(int i, int i1) {
        return false;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)ModBlocks.INFUSER);
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipes.INFUSER_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ModRecipes.INFUSER_TYPE.get();
    }
}

