/*
 * Decompiled with CFR 0.152.
 */
package net.yxiao233.ifeu.common.recipe;

import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.yxiao233.ifeu.common.block.entity.FluidCraftingTableEntity;
import net.yxiao233.ifeu.common.registry.ModBlocks;
import net.yxiao233.ifeu.common.registry.ModRecipes;

public class ShapelessRecipe
implements Recipe<CraftingInput> {
    public static final MapCodec<ShapelessRecipe> CODEC = RecordCodecBuilder.mapCodec(in -> in.group((App)Ingredient.CODEC.listOf(0, 9).fieldOf("inputs").forGetter(o -> o.inputs), (App)FluidStack.CODEC.fieldOf("inputFluid").forGetter(o -> o.inputFluid), (App)ItemStack.CODEC.fieldOf("output").forGetter(o -> o.output)).apply((Applicative)in, ShapelessRecipe::new));
    public List<Ingredient> inputs;
    public FluidStack inputFluid;
    public ItemStack output;

    public ShapelessRecipe(List<Ingredient> inputs, FluidStack inputFluid, ItemStack output) {
        this.inputs = inputs;
        this.inputFluid = inputFluid;
        this.output = output;
    }

    public static void createRecipe(RecipeOutput recipeOutput, String name, ShapelessRecipe recipe) {
        ResourceLocation rl = ShapelessRecipe.generateRL(name);
        AdvancementHolder advancementHolder = recipeOutput.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)rl)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)rl)).requirements(AdvancementRequirements.Strategy.OR).build(rl);
        recipeOutput.accept(rl, (Recipe)recipe, advancementHolder);
    }

    public static ResourceLocation generateRL(String key) {
        return ResourceLocation.fromNamespaceAndPath((String)"ifeu", (String)("shapeless/" + key));
    }

    public boolean matches(InventoryComponent<FluidCraftingTableEntity> inputs, FluidTankComponent<FluidCraftingTableEntity> tank) {
        if (this.inputs != null && tank != null && this.inputFluid != null) {
            boolean found;
            ArrayList<ItemStack> handlerItems = new ArrayList<ItemStack>();
            for (int i = 0; i < inputs.getSlots(); ++i) {
                if (inputs.getStackInSlot(i).isEmpty()) continue;
                handlerItems.add(inputs.getStackInSlot(i).copy());
            }
            Iterator<Ingredient> var12 = this.inputs.iterator();
            block1: do {
                if (!var12.hasNext()) {
                    return handlerItems.size() == 0 && tank.drainForced(this.inputFluid, IFluidHandler.FluidAction.SIMULATE).getAmount() == this.inputFluid.getAmount();
                }
                Ingredient ingredient = var12.next();
                found = false;
                for (ItemStack stack : ingredient.getItems()) {
                    int i;
                    for (i = 0; i < handlerItems.size(); ++i) {
                        if (!ItemStack.isSameItem((ItemStack)((ItemStack)handlerItems.get(i)), (ItemStack)stack)) continue;
                        found = true;
                        break;
                    }
                    if (!found) continue;
                    handlerItems.remove(i);
                    continue block1;
                }
            } while (found);
            return false;
        }
        return false;
    }

    public boolean matches(CraftingInput craftingInput, Level level) {
        return false;
    }

    public ItemStack assemble(CraftingInput craftingInput, HolderLookup.Provider provider) {
        return null;
    }

    public boolean canCraftInDimensions(int i, int i1) {
        return false;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public ItemStack getToastSymbol() {
        return ModBlocks.FLUID_CRAFTING_TABLE.asItem().getDefaultInstance();
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipes.SHAPELESS_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ModRecipes.SHAPELESS_TYPE.get();
    }
}

