/*
 * Decompiled with CFR 0.152.
 */
package net.yxiao233.ifeu.common.registry;

import com.buuz135.industrial.block.IndustrialBlockItem;
import com.buuz135.industrial.module.IModule;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.module.BlockWithTile;
import com.hrznstudio.titanium.module.DeferredRegistryHelper;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.block.Block;
import net.yxiao233.ifeu.api.block.IFEUBlackHoleCapacitorBlock;
import net.yxiao233.ifeu.common.block.ArcaneDragonEggForgingBlock;
import net.yxiao233.ifeu.common.block.BigDissolutionChamberBlock;
import net.yxiao233.ifeu.common.block.CreativeCapacitorBlock;
import net.yxiao233.ifeu.common.block.DragonGeneratorBlock;
import net.yxiao233.ifeu.common.block.DragonStarGeneratorBlock;
import net.yxiao233.ifeu.common.block.FluidCraftingTableBlock;
import net.yxiao233.ifeu.common.block.FluidTransferBlock;
import net.yxiao233.ifeu.common.block.InfuserBlock;
import net.yxiao233.ifeu.common.block.PlatformBuilderBlock;
import net.yxiao233.ifeu.common.block.RuleControllerBlock;
import net.yxiao233.ifeu.common.block.TimeControllerBlock;
import net.yxiao233.ifeu.common.block.WeatherControllerBlock;
import net.yxiao233.ifeu.common.registry.ModItems;

public class ModBlocks
implements IModule {
    public static BlockWithTile INFUSER;
    public static BlockWithTile DRAGON_STAR_GENERATOR;
    public static BlockWithTile ARCANE_DRAGON_EGG_FORGING;
    public static BlockWithTile CREATIVE_CAPACITOR;
    public static BlockWithTile RULE_CONTROLLER;
    public static BlockWithTile WEATHER_CONTROLLER;
    public static BlockWithTile TIME_CONTROLLER;
    public static BlockWithTile FLUID_CRAFTING_TABLE;
    public static BlockWithTile DRAGON_GENERATOR;
    public static BlockWithTile FLUID_TRANSFER;
    public static BlockWithTile BIG_DISSOLUTION_CHAMBER_CORE;
    public static BlockWithTile PLATFORM_BUILDER;

    public void generateFeatures(DeferredRegistryHelper helper) {
        INFUSER = this.deferredRegistry(helper, "infuser", InfuserBlock::new);
        DRAGON_STAR_GENERATOR = this.deferredRegistry(helper, "dragon_star_generator", DragonStarGeneratorBlock::new);
        ARCANE_DRAGON_EGG_FORGING = this.deferredRegistry(helper, "arcane_dragon_egg_forging", ArcaneDragonEggForgingBlock::new);
        CREATIVE_CAPACITOR = this.deferredRegistry(helper, "creative_capacitor", CreativeCapacitorBlock::new);
        RULE_CONTROLLER = this.deferredRegistry(helper, "rule_controller", RuleControllerBlock::new);
        WEATHER_CONTROLLER = this.deferredRegistry(helper, "weather_controller", WeatherControllerBlock::new);
        TIME_CONTROLLER = this.deferredRegistry(helper, "time_controller", TimeControllerBlock::new);
        FLUID_CRAFTING_TABLE = this.deferredRegistry(helper, "fluid_crafting_table", FluidCraftingTableBlock::new);
        DRAGON_GENERATOR = this.deferredRegistry(helper, "dragon_generator", DragonGeneratorBlock::new);
        FLUID_TRANSFER = this.deferredRegistry(helper, "fluid_transfer", FluidTransferBlock::new);
        BIG_DISSOLUTION_CHAMBER_CORE = this.deferredRegistry(helper, "big_dissolution_chamber_core", BigDissolutionChamberBlock::new);
        PLATFORM_BUILDER = this.deferredRegistry(helper, "platform_builder", PlatformBuilderBlock::new);
    }

    private BlockWithTile deferredRegistry(DeferredRegistryHelper helper, String name, Supplier<BasicTileBlock<?>> blockSupplier) {
        return helper.registerBlockWithTileItem(name, blockSupplier, blockRegistryObject -> () -> new IndustrialBlockItem((Block)blockRegistryObject.get(), ModItems.TAB_ADDONS), null);
    }

    private BlockWithTile blackHoleRegistry(DeferredRegistryHelper helper, String name, Rarity rarity) {
        return helper.registerBlockWithTileItem(name, () -> new IFEUBlackHoleCapacitorBlock(name, rarity), blockRegistryObject -> () -> new IFEUBlackHoleCapacitorBlock.BlackHoleCapacitorItem((Block)blockRegistryObject.get(), new Item.Properties().rarity(rarity), rarity, ModItems.TAB_ADDONS), null);
    }

    public static ArrayList<Block> addBlocksToCreativeModeTab() {
        ArrayList<Block> blocks = new ArrayList<Block>();
        blocks.add(INFUSER.getBlock());
        blocks.add(DRAGON_STAR_GENERATOR.getBlock());
        blocks.add(ARCANE_DRAGON_EGG_FORGING.getBlock());
        blocks.add(CREATIVE_CAPACITOR.getBlock());
        blocks.add(RULE_CONTROLLER.getBlock());
        blocks.add(WEATHER_CONTROLLER.getBlock());
        blocks.add(TIME_CONTROLLER.getBlock());
        blocks.add(FLUID_CRAFTING_TABLE.getBlock());
        blocks.add(DRAGON_GENERATOR.getBlock());
        blocks.add(FLUID_TRANSFER.getBlock());
        blocks.add(BIG_DISSOLUTION_CHAMBER_CORE.getBlock());
        blocks.add(PLATFORM_BUILDER.getBlock());
        return blocks;
    }
}

