/*
 * Decompiled with CFR 0.152.
 */
package net.yxiao233.ifeu.common.structure;

import com.buuz135.industrial.utils.IndustrialTags;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.yxiao233.ifeu.api.structure.MultiBlockStructure;
import net.yxiao233.ifeu.api.structure.MultiBlockStructureBuilder;
import net.yxiao233.ifeu.common.registry.ModBlocks;
import net.yxiao233.ifeu.common.registry.ModContents;
import net.yxiao233.ifeu.common.registry.ModTags;

public class IFEUMultiBlockStructures {
    public static final HashMap<ResourceLocation, IFEUMultiBlockStructures> values = new HashMap();
    public static final IFEUMultiBlockStructures BIG_DISSOLUTION_CHAMBER = new IFEUMultiBlockStructures(IFEUMultiBlockStructures.ifeu("big_dissolution_chamber"), () -> ModBlocks.BIG_DISSOLUTION_CHAMBER_CORE.asItem(), () -> new MultiBlockStructureBuilder().pattern("ABA", "BBB", "A A").pattern("BBB", "BCB", "DMD").pattern("ABA", "BBB", "AEA").define('A', IFEUMultiBlockStructures.FRAME_SIMPLE()).define('B', Blocks.SCULK).define('C', (Block)ModContents.DRAGON_STAR_BLOCK.get()).define('D', IFEUMultiBlockStructures.ITEM()).define('E', IFEUMultiBlockStructures.FLUID()).build());
    private Supplier<MultiBlockStructure> structure;
    private Supplier<Item> machine;
    private ResourceLocation id;
    public static final Codec<IFEUMultiBlockStructures> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(IFEUMultiBlockStructures::getId), (App)ResourceLocation.CODEC.fieldOf("machine").forGetter(struct -> {
        Item item = struct.getMachine();
        return BuiltInRegistries.ITEM.getKey((Object)item);
    }), (App)MultiBlockStructure.CODEC.fieldOf("structure").forGetter(IFEUMultiBlockStructures::getStructure)).apply((Applicative)instance, (id, machineId, structure) -> {
        Supplier<Item> machineSupplier = () -> (Item)BuiltInRegistries.ITEM.get(machineId);
        Supplier<MultiBlockStructure> structureSupplier = () -> structure;
        return new IFEUMultiBlockStructures((ResourceLocation)id, machineSupplier, structureSupplier);
    }));

    public IFEUMultiBlockStructures(ResourceLocation id, Supplier<Item> machine, Supplier<MultiBlockStructure> structure) {
        this.machine = machine;
        this.structure = structure;
        this.id = id;
        if (!values.containsKey(id)) {
            values.put(id, this);
        }
    }

    public static IFEUMultiBlockStructures getById(ResourceLocation id) {
        if (values.containsKey(id)) {
            return values.get(id);
        }
        return null;
    }

    public Item getMachine() {
        return this.machine.get();
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public MultiBlockStructure getStructure() {
        return this.structure.get();
    }

    public void modify(MultiBlockStructure newStructure) {
        this.structure = () -> newStructure;
    }

    private static ResourceLocation ifeu(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"ifeu", (String)path);
    }

    private static TagKey<Block> ENERGY() {
        return ModTags.Blocks.STORAGE_ENERGY;
    }

    private static TagKey<Block> FLUID() {
        return ModTags.Blocks.STORAGE_FLUID;
    }

    private static TagKey<Block> ITEM() {
        return ModTags.Blocks.STORAGE_ITEM;
    }

    private static TagKey<Block> FRAME_PITY() {
        return IndustrialTags.Blocks.MACHINE_FRAME_PITY;
    }

    private static TagKey<Block> FRAME_SIMPLE() {
        return IndustrialTags.Blocks.MACHINE_FRAME_SIMPLE;
    }

    private static TagKey<Block> FRAME_ADVANCED() {
        return IndustrialTags.Blocks.MACHINE_FRAME_ADVANCED;
    }

    private static TagKey<Block> FRAME_SUPREME() {
        return IndustrialTags.Blocks.MACHINE_FRAME_SUPREME;
    }

    private static TagKey<Block> FRAME_ULTIMATE() {
        return ModTags.Blocks.MACHINE_FRAME_ULTIMATE;
    }
}

