/*
 * Decompiled with CFR 0.152.
 */
package net.yxiao233.ifeu.common.utils;

import com.hrznstudio.titanium.block.tile.MachineTile;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class InventoryComponentHelper {
    public static boolean canInsertAugment(MachineTile<?> tile, ItemStack stack) {
        if (tile == null || stack == null) {
            return false;
        }
        if (tile.canAcceptAugment(stack)) {
            SidedInventoryComponent augments = tile.getAugmentInventory();
            for (int i = 0; i < augments.getSlots(); ++i) {
                ItemStack itemStack = augments.getStackInSlot(i);
                if (!itemStack.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean canInsertAugment(MachineTile<?> tile, Item item) {
        return InventoryComponentHelper.canInsertAugment(tile, item.getDefaultInstance());
    }

    public static int getCanInsertIndex(MachineTile<?> tile, ItemStack stack) {
        if (InventoryComponentHelper.canInsertAugment(tile, stack)) {
            SidedInventoryComponent augments = tile.getAugmentInventory();
            int index = 0;
            for (int i = 0; i < augments.getSlots(); ++i) {
                ItemStack itemStack = augments.getStackInSlot(i);
                if (!itemStack.isEmpty()) continue;
                index = i;
            }
            return index;
        }
        return -1;
    }

    public static int getCanInsertIndex(MachineTile<?> tile, Item item) {
        return InventoryComponentHelper.getCanInsertIndex(tile, item.getDefaultInstance());
    }

    public static void insertAugment(MachineTile<?> tile, ItemStack stack) {
        int index = InventoryComponentHelper.getCanInsertIndex(tile, stack);
        if (index != -1) {
            SidedInventoryComponent augments = tile.getAugmentInventory();
            augments.setStackInSlot(index, stack);
        }
    }

    public static void insertAugment(MachineTile<?> tile, Item item) {
        InventoryComponentHelper.insertAugment(tile, item.getDefaultInstance());
    }

    public static int canInsetMaxCount(InventoryComponent<?> inventory, ItemStack stack) {
        int stackSize = stack.getMaxStackSize();
        int slots = inventory.getSlots();
        int count = 0;
        for (int i = 0; i < slots; ++i) {
            if (!inventory.getStackInSlot(i).isEmpty() && !inventory.getStackInSlot(i).is(stack.getItem())) continue;
            int temp = Math.min(stackSize, inventory.getSlotLimit(i)) - inventory.getStackInSlot(i).getCount();
            count += temp;
        }
        return count;
    }

    public static int canInsetMaxCount(InventoryComponent<?> inventory, Item item) {
        int stackSize = item.getDefaultMaxStackSize();
        int slots = inventory.getSlots();
        int count = 0;
        for (int i = 0; i < slots; ++i) {
            if (!inventory.getStackInSlot(i).isEmpty() && !inventory.getStackInSlot(i).is(item)) continue;
            int temp = Math.min(stackSize, inventory.getSlotLimit(i)) - inventory.getStackInSlot(i).getCount();
            count += temp;
        }
        return count;
    }
}

