/*
 * Decompiled with CFR 0.152.
 */
package net.yxiao233.ifeu.common.utils;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.yxiao233.ifeu.api.block.entity.IFEUAreaWorkingTile;

public class PlatformBuilderUtil {
    public static List<BlockPos> getFrameBlockPosList(IFEUAreaWorkingTile<?> entity) {
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        int bounds = entity.getFrameBounds();
        int range = entity.getLandRange();
        BlockPos entityPos = entity.getBlockPos();
        int d0 = PlatformBuilderUtil.adjustForDirection(entity.getFrameDirection().northSouth().get());
        int d1 = PlatformBuilderUtil.adjustForDirection(entity.getFrameDirection().westEast().get());
        int[] xs = PlatformBuilderUtil.posPrefix(entity, d1, entityPos.getX());
        int[] zs = PlatformBuilderUtil.posPrefix(entity, d0, entityPos.getZ());
        for (int x = xs[0]; x < xs[1]; ++x) {
            int z;
            if (d0 <= 0) {
                for (z = entityPos.getZ() + range * d0 + bounds * d0; z <= entityPos.getZ() - range * d0; ++z) {
                    posList.add(new BlockPos(x, entityPos.getY() + entity.getYOffset(), z));
                }
                continue;
            }
            for (z = entityPos.getZ() - range * d0; z <= entityPos.getZ() + range * d0 + bounds * d0; ++z) {
                posList.add(new BlockPos(x, entityPos.getY() + entity.getYOffset(), z));
            }
        }
        for (int z = zs[0]; z < zs[1]; ++z) {
            for (int x = entityPos.getX() - range; x <= entityPos.getX() + range; ++x) {
                posList.add(new BlockPos(x, entityPos.getY() + entity.getYOffset(), z));
            }
        }
        return posList;
    }

    public static List<BlockPos> getLandPosList(IFEUAreaWorkingTile<?> entity) {
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        BlockPos entityPos = entity.getBlockPos();
        int range = entity.getLandRange();
        for (int x = entityPos.getX() - range; x <= entityPos.getX() + range; ++x) {
            for (int z = entityPos.getZ() - range; z <= entityPos.getZ() + range; ++z) {
                posList.add(new BlockPos(x, entityPos.getY() + entity.getYOffset(), z));
            }
        }
        return posList;
    }

    private static int adjustForDirection(Direction direction) {
        return switch (direction) {
            case Direction.NORTH, Direction.WEST -> -1;
            default -> 1;
        };
    }

    private static int[] posPrefix(IFEUAreaWorkingTile<?> entity, int d, int XZ) {
        int maxXZ;
        int minXZ;
        int range = entity.getLandRange();
        int bounds = entity.getFrameBounds();
        if (d <= 0) {
            minXZ = XZ - range - bounds;
            maxXZ = XZ - range;
        } else {
            minXZ = XZ + range + 1;
            maxXZ = XZ + range + bounds + 1;
        }
        return new int[]{minXZ, maxXZ};
    }
}

