/*
 * Decompiled with CFR 0.152.
 */
package net.yxiao233.ifeu.common.utils;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.fluids.FluidStack;
import net.yxiao233.ifeu.common.config.machine.FluidCraftingTableConfig;
import net.yxiao233.ifeu.common.registry.ModRenderTypes;
import org.apache.commons.lang3.tuple.Triple;
import org.joml.Matrix4f;

public class RendererHelper {
    public static final Function<ResourceLocation, TextureAtlasSprite> TEXTURE_GETTER = location -> (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(location);

    public static Triple<Float, Float, Float> intToRGB(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        return Triple.of((Object)Float.valueOf(red), (Object)Float.valueOf(green), (Object)Float.valueOf(blue));
    }

    public static void renderFluidContext(FluidStack fluid, PoseStack matrixStack, IFluidContextRender render) {
        if (fluid != null && fluid.getAmount() > 0) {
            matrixStack.pushPose();
            RenderSystem.enableBlend();
            RenderSystem.disableCull();
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)771);
            Minecraft.getInstance().getTextureManager().bindForSetup(TextureAtlas.LOCATION_BLOCKS);
            render.render();
            RenderSystem.disableBlend();
            matrixStack.popPose();
        }
    }

    public static TextureAtlasSprite getFluidIcon(Fluid fluid, Direction side) {
        return RendererHelper.getFluidIcon(new FluidStack(fluid, 1000), side);
    }

    public static TextureAtlasSprite getFluidIcon(FluidStack fluid, Direction side) {
        IClientFluidTypeExtensions renderProperties;
        TextureAtlasSprite icon;
        if (side == null) {
            side = Direction.UP;
        }
        if ((icon = TEXTURE_GETTER.apply((renderProperties = IClientFluidTypeExtensions.of((Fluid)fluid.getFluid())).getFlowingTexture(fluid))) == null || side == Direction.UP || side == Direction.DOWN) {
            icon = TEXTURE_GETTER.apply(renderProperties.getStillTexture(fluid));
        }
        return icon;
    }

    public static void renderFullFluid(PoseStack poseStack, MultiBufferSource multiBufferSource, BlockEntity entity, FluidStack fluidStack, int combinedLight) {
        RendererHelper.renderFluidContext(fluidStack, poseStack, () -> {
            float height = (float)fluidStack.getAmount() * 1.0f / (float)FluidCraftingTableConfig.maxInputTankSize;
            height = Math.min(height, 0.995f);
            int brightness = Math.max(combinedLight, fluidStack.getFluid().getFluidType().getLightLevel(fluidStack));
            int l2 = brightness >> 16 & 0xFFFF;
            int i3 = brightness & 0xFFFF;
            TextureAtlasSprite icon = RendererHelper.getFluidIcon(fluidStack, Direction.UP);
            IClientFluidTypeExtensions renderProperties = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid());
            Triple<Float, Float, Float> color = RendererHelper.intToRGB(renderProperties.getTintColor(fluidStack.getFluid().defaultFluidState(), (BlockAndTintGetter)entity.getLevel(), entity.getBlockPos()));
            VertexConsumer vb = multiBufferSource.getBuffer(RenderType.text((ResourceLocation)icon.atlasLocation()));
            Matrix4f matrix = poseStack.last().pose();
            vb.addVertex(matrix, 0.005f, height, 0.005f).setColor(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).setUv(icon.getU0(), icon.getV1()).setUv2(l2, i3);
            vb.addVertex(matrix, 0.005f, height, 0.995f).setColor(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).setUv(icon.getU0(), icon.getV0()).setUv2(l2, i3);
            vb.addVertex(matrix, 0.995f, height, 0.995f).setColor(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).setUv(icon.getU1(), icon.getV0()).setUv2(l2, i3);
            vb.addVertex(matrix, 0.995f, height, 0.005f).setColor(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).setUv(icon.getU1(), icon.getV1()).setUv2(l2, i3);
            vb.addVertex(matrix, 0.005f, 0.005f, 0.005f).setColor(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).setUv(icon.getU0(), icon.getV1()).setUv2(l2, i3);
            vb.addVertex(matrix, 0.995f, 0.005f, 0.005f).setColor(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).setUv(icon.getU0(), icon.getV0()).setUv2(l2, i3);
            vb.addVertex(matrix, 0.995f, 0.005f, 0.995f).setColor(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).setUv(icon.getU1(), icon.getV0()).setUv2(l2, i3);
            vb.addVertex(matrix, 0.005f, 0.005f, 0.995f).setColor(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).setUv(icon.getU1(), icon.getV1()).setUv2(l2, i3);
            vb.addVertex(matrix, 0.005f, 0.005f, 0.995f).setColor(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).setUv(icon.getU0(), icon.getV1()).setUv2(l2, i3);
            vb.addVertex(matrix, 0.995f, 0.005f, 0.995f).setColor(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).setUv(icon.getU1(), icon.getV1()).setUv2(l2, i3);
            vb.addVertex(matrix, 0.995f, height, 0.995f).setColor(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).setUv(icon.getU1(), icon.getV0()).setUv2(l2, i3);
            vb.addVertex(matrix, 0.005f, height, 0.995f).setColor(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).setUv(icon.getU0(), icon.getV0()).setUv2(l2, i3);
            vb.addVertex(matrix, 0.005f, 0.005f, 0.005f).setColor(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).setUv(icon.getU0(), icon.getV0()).setUv2(l2, i3);
            vb.addVertex(matrix, 0.005f, height, 0.005f).setColor(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).setUv(icon.getU0(), icon.getV1()).setUv2(l2, i3);
            vb.addVertex(matrix, 0.995f, height, 0.005f).setColor(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).setUv(icon.getU1(), icon.getV1()).setUv2(l2, i3);
            vb.addVertex(matrix, 0.995f, 0.005f, 0.005f).setColor(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).setUv(icon.getU1(), icon.getV0()).setUv2(l2, i3);
            vb.addVertex(matrix, 0.995f, 0.005f, 0.005f).setColor(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).setUv(icon.getU0(), icon.getV0()).setUv2(l2, i3);
            vb.addVertex(matrix, 0.995f, height, 0.005f).setColor(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).setUv(icon.getU0(), icon.getV1()).setUv2(l2, i3);
            vb.addVertex(matrix, 0.995f, height, 0.995f).setColor(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).setUv(icon.getU1(), icon.getV1()).setUv2(l2, i3);
            vb.addVertex(matrix, 0.995f, 0.005f, 0.995f).setColor(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).setUv(icon.getU1(), icon.getV0()).setUv2(l2, i3);
            vb.addVertex(matrix, 0.005f, 0.005f, 0.995f).setColor(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).setUv(icon.getU0(), icon.getV0()).setUv2(l2, i3);
            vb.addVertex(matrix, 0.005f, height, 0.995f).setColor(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).setUv(icon.getU0(), icon.getV1()).setUv2(l2, i3);
            vb.addVertex(matrix, 0.005f, height, 0.005f).setColor(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).setUv(icon.getU1(), icon.getV1()).setUv2(l2, i3);
            vb.addVertex(matrix, 0.005f, 0.005f, 0.005f).setColor(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).setUv(icon.getU1(), icon.getV0()).setUv2(l2, i3);
        });
    }

    public static void renderGhostBlockContext(BlockPos entityBlockPos, PoseStack poseStack, IBlockContextRender render) {
        poseStack.pushPose();
        poseStack.translate((float)(-entityBlockPos.getX()), (float)(-entityBlockPos.getY()), (float)(-entityBlockPos.getZ()));
        render.render();
        poseStack.popPose();
    }

    public static void renderSingleBatchedGhostBlock(PoseStack poseStack, MultiBufferSource multiBufferSource, BlockPos entityBlockPos, BlockPos renderBlockPos, BlockState blockState) {
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        VertexConsumer consumer = multiBufferSource.getBuffer(ModRenderTypes.GHOST);
        if (level == null) {
            return;
        }
        RendererHelper.renderGhostBlockContext(entityBlockPos, poseStack, () -> RendererHelper.lambda$renderSingleBatchedGhostBlock$2(poseStack, renderBlockPos, minecraft, blockState, (Level)level, consumer));
    }

    public static void renderSingleGhostBlock(PoseStack poseStack, MultiBufferSource multiBufferSource, BlockPos entityBlockPos, BlockPos renderBlockPos, BlockState blockState, int i1, int i2) {
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        if (level == null) {
            return;
        }
        RendererHelper.renderGhostBlockContext(entityBlockPos, poseStack, () -> {
            poseStack.pushPose();
            poseStack.translate((float)renderBlockPos.getX(), (float)renderBlockPos.getY(), (float)renderBlockPos.getZ());
            minecraft.getBlockRenderer().renderSingleBlock(blockState, poseStack, multiBufferSource, i1, i2, ModelData.EMPTY, ModRenderTypes.GHOST);
            poseStack.popPose();
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderAllBatchedGhostBlock(PoseStack poseStack, MultiBufferSource multiBufferSource, BlockPos entityBlockPos, List<BlockPos> posList, BlockState blockState) {
        posList.forEach(pos -> RendererHelper.renderSingleBatchedGhostBlock(poseStack, multiBufferSource, entityBlockPos, pos, blockState));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderAllBatchedGhostBlockWhileIsNotCurrent(PoseStack poseStack, MultiBufferSource multiBufferSource, BlockPos entityBlockPos, Level level, List<BlockPos> posList, BlockState blockState) {
        posList.forEach(pos -> {
            if (!level.getBlockState(pos).is(blockState.getBlock())) {
                RendererHelper.renderSingleBatchedGhostBlock(poseStack, multiBufferSource, entityBlockPos, pos, blockState);
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderLineBox(PoseStack poseStack, VertexConsumer consumer, AABB aabb, BlockPos entityPos, Color color) {
        RenderSystem.lineWidth((float)Math.max(2.5f, (float)Minecraft.getInstance().getWindow().getWidth() / 1920.0f * 2.5f));
        LevelRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)consumer, (AABB)aabb.move((double)(-entityPos.getX()), (double)(-entityPos.getY()), (double)(-entityPos.getZ())), (float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)0.5f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderBlockLineBox(PoseStack poseStack, MultiBufferSource multiBufferSource, BlockPos curPos, BlockPos entityPos, Color color) {
        RenderSystem.lineWidth((float)Math.max(2.5f, (float)Minecraft.getInstance().getWindow().getWidth() / 1920.0f * 2.5f));
        LevelRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)multiBufferSource.getBuffer(RenderType.lines()), (AABB)new AABB((double)curPos.getX(), (double)curPos.getY(), (double)curPos.getZ(), (double)(curPos.getX() + 1), (double)(curPos.getY() + 1), (double)(curPos.getZ() + 1)).move((double)(-entityPos.getX()), (double)(-entityPos.getY()), (double)(-entityPos.getZ())), (float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)0.5f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderBlockLineBox(PoseStack poseStack, MultiBufferSource multiBufferSource, RenderType renderType, BlockPos curPos, BlockPos entityPos, Color color) {
        RenderSystem.lineWidth((float)Math.max(2.5f, (float)Minecraft.getInstance().getWindow().getWidth() / 1920.0f * 2.5f));
        LevelRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)multiBufferSource.getBuffer(renderType), (AABB)new AABB((double)curPos.getX(), (double)curPos.getY(), (double)curPos.getZ(), (double)(curPos.getX() + 1), (double)(curPos.getY() + 1), (double)(curPos.getZ() + 1)).move((double)(-entityPos.getX()), (double)(-entityPos.getY()), (double)(-entityPos.getZ())), (float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)0.5f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderBlockLineBoxWithFaces(PoseStack poseStack, MultiBufferSource multiBufferSource, BlockPos curPos, BlockPos entityPos, Color color) {
        RenderSystem.lineWidth((float)Math.max(2.5f, (float)Minecraft.getInstance().getWindow().getWidth() / 1920.0f * 2.5f));
        LevelRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)multiBufferSource.getBuffer(RenderType.lines()), (AABB)new AABB((double)curPos.getX(), (double)curPos.getY(), (double)curPos.getZ(), (double)(curPos.getX() + 1), (double)(curPos.getY() + 1), (double)(curPos.getZ() + 1)).move((double)(-entityPos.getX()), (double)(-entityPos.getY()), (double)(-entityPos.getZ())), (float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)0.5f);
        RendererHelper.renderFaces(poseStack, multiBufferSource, new AABB((double)curPos.getX(), (double)curPos.getY(), (double)curPos.getZ(), (double)(curPos.getX() + 1), (double)(curPos.getY() + 1), (double)(curPos.getZ() + 1)), entityPos, color);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderFaces(PoseStack stack, MultiBufferSource multiBufferSource, BlockPos curPos, BlockPos entityPos, Color color) {
        RendererHelper.renderFaces(stack, multiBufferSource, new AABB((double)curPos.getX(), (double)curPos.getY(), (double)curPos.getZ(), (double)(curPos.getX() + 1), (double)(curPos.getY() + 1), (double)(curPos.getZ() + 1)), entityPos, color);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderFaces(PoseStack stack, MultiBufferSource multiBufferSource, RenderType renderType, BlockPos curPos, BlockPos entityPos, Color color) {
        RendererHelper.renderFaces(stack, multiBufferSource, renderType, new AABB((double)curPos.getX(), (double)curPos.getY(), (double)curPos.getZ(), (double)(curPos.getX() + 1), (double)(curPos.getY() + 1), (double)(curPos.getZ() + 1)), entityPos, color);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderFaces(PoseStack stack, MultiBufferSource multiBufferSource, AABB aabb, BlockPos entityPos, Color color) {
        RendererHelper.renderFaces(stack, multiBufferSource, ModRenderTypes.WORK_AREA, aabb, entityPos, color);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderFaces(PoseStack stack, MultiBufferSource renderTypeBuffer, RenderType renderType, AABB pos, BlockPos entityPos, Color color) {
        double x = -entityPos.getX();
        double y = -entityPos.getY();
        double z = -entityPos.getZ();
        float red = (float)color.getRed() / 255.0f;
        float green = (float)color.getGreen() / 255.0f;
        float blue = (float)color.getBlue() / 255.0f;
        float alpha = 0.3f;
        float x1 = (float)(pos.minX + x);
        float x2 = (float)(pos.maxX + x);
        float y1 = (float)(pos.minY + y);
        float y2 = (float)(pos.maxY + y);
        float z1 = (float)(pos.minZ + z);
        float z2 = (float)(pos.maxZ + z);
        Matrix4f matrix = stack.last().pose();
        VertexConsumer buffer = renderTypeBuffer.getBuffer(renderType);
        buffer.addVertex(matrix, x1, y1, z1).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x1, y2, z1).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x2, y2, z1).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x2, y1, z1).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x1, y1, z2).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x2, y1, z2).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x2, y2, z2).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x1, y2, z2).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x1, y1, z1).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x2, y1, z1).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x2, y1, z2).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x1, y1, z2).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x1, y2, z1).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x1, y2, z2).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x2, y2, z2).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x2, y2, z1).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x1, y1, z1).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x1, y1, z2).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x1, y2, z2).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x1, y2, z1).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x2, y1, z1).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x2, y2, z1).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x2, y2, z2).setColor(red, green, blue, alpha);
        buffer.addVertex(matrix, x2, y1, z2).setColor(red, green, blue, alpha);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderCenterVerticalLine(PoseStack poseStack, VertexConsumer consumer, BlockPos verticalPos, int high, BlockPos entityPos, Color color) {
        LevelRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)consumer, (AABB)new AABB((double)verticalPos.getX(), (double)verticalPos.getY(), (double)verticalPos.getZ(), (double)verticalPos.getX(), (double)(verticalPos.getY() + high), (double)verticalPos.getZ()).move((double)((float)(-entityPos.getX()) + 0.5f), (double)((float)(-entityPos.getY()) + 0.5f), (double)((float)(-entityPos.getZ()) + 0.5f)), (float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)0.5f);
    }

    private static /* synthetic */ void lambda$renderSingleBatchedGhostBlock$2(PoseStack poseStack, BlockPos renderBlockPos, Minecraft minecraft, BlockState blockState, Level level, VertexConsumer consumer) {
        poseStack.pushPose();
        poseStack.translate((float)renderBlockPos.getX(), (float)renderBlockPos.getY(), (float)renderBlockPos.getZ());
        minecraft.getBlockRenderer().renderBatched(blockState, renderBlockPos, (BlockAndTintGetter)level, poseStack, consumer, false, level.getRandom(), ModelData.EMPTY, null);
        poseStack.popPose();
    }

    public static interface IFluidContextRender {
        public void render();
    }

    public static interface IBlockContextRender {
        public void render();
    }
}

