/*
 * Decompiled with CFR 0.152.
 */
package net.yxiao233.ifeu.common.utils;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.fluids.FluidStack;
import net.yxiao233.ifeu.common.registry.ModRenderTypes;
import net.yxiao233.ifeu.common.utils.RendererHelper;

@OnlyIn(value=Dist.CLIENT)
public class RendererProvider {
    private final PoseStack poseStack;
    private final MultiBufferSource multiBufferSource;
    private final BlockPos entityPos;

    public RendererProvider(PoseStack poseStack, MultiBufferSource multiBufferSource, BlockPos entityPos) {
        this.poseStack = poseStack;
        this.multiBufferSource = multiBufferSource;
        this.entityPos = entityPos;
    }

    public void renderSingleBatchedGhostBlock(BlockPos renderBlockPos, BlockState blockState) {
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        VertexConsumer consumer = this.multiBufferSource.getBuffer(ModRenderTypes.GHOST);
        if (level == null) {
            return;
        }
        RendererHelper.renderGhostBlockContext(this.entityPos, this.poseStack, () -> this.lambda$renderSingleBatchedGhostBlock$0(renderBlockPos, minecraft, blockState, (Level)level, consumer));
    }

    public void renderFullFluid(BlockEntity entity, FluidStack stack, int combinedLight) {
        RendererHelper.renderFullFluid(this.poseStack, this.multiBufferSource, entity, stack, combinedLight);
    }

    public void renderLineBox(AABB aabb, BlockPos entityPos, Color color) {
        RendererHelper.renderLineBox(this.poseStack, this.multiBufferSource.getBuffer(RenderType.lines()), aabb, entityPos, color);
    }

    public void renderCenterVerticalLine(BlockPos verticalPos, int high, Color color) {
        RendererHelper.renderCenterVerticalLine(this.poseStack, this.multiBufferSource.getBuffer(RenderType.lines()), verticalPos, high, this.entityPos, color);
    }

    public void renderAllBatchedGhostBlock(List<BlockPos> posList, BlockState blockState) {
        RendererHelper.renderAllBatchedGhostBlock(this.poseStack, this.multiBufferSource, this.entityPos, posList, blockState);
    }

    public void renderAllBatchedGhostBlockWhileIsNotCurrent(Level level, List<BlockPos> posList, BlockState blockState) {
        RendererHelper.renderAllBatchedGhostBlockWhileIsNotCurrent(this.poseStack, this.multiBufferSource, this.entityPos, level, posList, blockState);
    }

    public void renderBlockLineBox(BlockPos curPos, Color color) {
        RendererHelper.renderBlockLineBox(this.poseStack, this.multiBufferSource, curPos, this.entityPos, color);
    }

    public void renderBlockLineBoxWithFaces(BlockPos curPos, Color color) {
        RendererHelper.renderBlockLineBoxWithFaces(this.poseStack, this.multiBufferSource, curPos, this.entityPos, color);
    }

    private /* synthetic */ void lambda$renderSingleBatchedGhostBlock$0(BlockPos renderBlockPos, Minecraft minecraft, BlockState blockState, Level level, VertexConsumer consumer) {
        this.poseStack.pushPose();
        this.poseStack.translate((float)renderBlockPos.getX(), (float)renderBlockPos.getY(), (float)renderBlockPos.getZ());
        minecraft.getBlockRenderer().renderBatched(blockState, renderBlockPos, (BlockAndTintGetter)level, this.poseStack, consumer, false, level.getRandom(), ModelData.EMPTY, null);
        this.poseStack.popPose();
    }
}

