/*
 * Decompiled with CFR 0.152.
 */
package net.yxiao233.ifeu.common.utils;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class TooltipHelper {
    public static boolean getKeyType(KeyType keyType) {
        return switch (keyType.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> Screen.hasShiftDown();
            case 1 -> Screen.hasAltDown();
            case 2 -> Screen.hasControlDown();
        };
    }

    public static void addTooltip(List<Component> tooltips, ItemStack itemStack, int index) {
        tooltips.add((Component)Component.translatable((String)TooltipHelper.itemIdToKey(itemStack, index)));
    }

    public static void addTooltip(List<Component> tooltips, ItemStack itemStack, String prefix) {
        tooltips.add((Component)Component.translatable((String)TooltipHelper.itemIdToKey(itemStack, prefix)));
    }

    public static void addTooltip(List<Component> tooltips, ItemStack itemStack, int index, Object ... obj) {
        tooltips.add((Component)Component.translatable((String)TooltipHelper.itemIdToKey(itemStack, index), (Object[])obj));
    }

    public static void addTooltip(List<Component> tooltips, ItemStack itemStack, String prefix, Object ... obj) {
        tooltips.add((Component)Component.translatable((String)TooltipHelper.itemIdToKey(itemStack, prefix), (Object[])obj));
    }

    public static void addTooltip(List<Component> tooltips, ItemStack itemStack, ChatFormatting style, int index, Object ... obj) {
        tooltips.add((Component)Component.translatable((String)TooltipHelper.itemIdToKey(itemStack, index), (Object[])obj).withStyle(style));
    }

    public static void addTooltip(List<Component> tooltips, ItemStack itemStack, ChatFormatting style, String prefix, Object ... obj) {
        tooltips.add((Component)Component.translatable((String)TooltipHelper.itemIdToKey(itemStack, prefix), (Object[])obj).withStyle(style));
    }

    public static void addTooltip(List<Component> tooltips, ItemStack itemStack, ChatFormatting style, int index) {
        tooltips.add((Component)Component.translatable((String)TooltipHelper.itemIdToKey(itemStack, index)).withStyle(style));
    }

    public static void addTooltip(List<Component> tooltips, ItemStack itemStack, ChatFormatting style, String prefix) {
        tooltips.add((Component)Component.translatable((String)TooltipHelper.itemIdToKey(itemStack, prefix)).withStyle(style));
    }

    public static String itemIdToKey(ItemStack itemStack, int index) {
        String rawKey = itemStack.getDescriptionId();
        return "tooltip" + rawKey.substring(rawKey.indexOf(".")) + index;
    }

    public static String itemIdToKey(ItemStack itemStack, String prefix) {
        String rawKey = itemStack.getDescriptionId();
        return "tooltip" + rawKey.substring(rawKey.indexOf(".")) + prefix;
    }

    public static void addTooltipWhileKeyDown(KeyType keyType, List<Component> tooltips, ItemStack itemStack, int index) {
        if (TooltipHelper.getKeyType(keyType)) {
            TooltipHelper.addTooltip(tooltips, itemStack, index);
        } else {
            tooltips.add((Component)Component.translatable((String)("tooltip.ifeu.held." + keyType.getValue())).withStyle(ChatFormatting.GRAY));
        }
    }

    public static void addTooltipWhileKeyDown(KeyType keyType, List<Component> tooltips, ItemStack itemStack, String prefix) {
        if (TooltipHelper.getKeyType(keyType)) {
            TooltipHelper.addTooltip(tooltips, itemStack, prefix);
        } else {
            tooltips.add((Component)Component.translatable((String)("tooltip.ifeu.held." + keyType.getValue())).withStyle(ChatFormatting.GRAY));
        }
    }

    public static void addTooltipWhileKeyDown(KeyType keyType, List<Component> tooltips, ItemStack itemStack, ChatFormatting style, int index, Object ... obj) {
        if (TooltipHelper.getKeyType(keyType)) {
            TooltipHelper.addTooltip(tooltips, itemStack, style, index, obj);
        } else {
            tooltips.add((Component)Component.translatable((String)("tooltip.ifeu.held." + keyType.getValue())).withStyle(ChatFormatting.GRAY));
        }
    }

    public static void addTooltipWhileKeyDown(KeyType keyType, List<Component> tooltips, ItemStack itemStack, ChatFormatting style, String prefix, Object ... obj) {
        if (TooltipHelper.getKeyType(keyType)) {
            TooltipHelper.addTooltip(tooltips, itemStack, style, prefix, obj);
        } else {
            tooltips.add((Component)Component.translatable((String)("tooltip.ifeu.held." + keyType.getValue())).withStyle(ChatFormatting.GRAY));
        }
    }

    public static void addTooltipWhileKeyDown(KeyType keyType, List<Component> tooltips, ItemStack itemStack, ChatFormatting style, int index) {
        if (TooltipHelper.getKeyType(keyType)) {
            TooltipHelper.addTooltip(tooltips, itemStack, style, index);
        } else {
            tooltips.add((Component)Component.translatable((String)("tooltip.ifeu.held." + keyType.getValue())).withStyle(ChatFormatting.GRAY));
        }
    }

    public static void addTooltipWhileKeyDown(KeyType keyType, List<Component> tooltips, ItemStack itemStack, ChatFormatting style, String prefix) {
        if (TooltipHelper.getKeyType(keyType)) {
            TooltipHelper.addTooltip(tooltips, itemStack, style, prefix);
        } else {
            tooltips.add((Component)Component.translatable((String)("tooltip.ifeu.held." + keyType.getValue())).withStyle(ChatFormatting.GRAY));
        }
    }

    public static void addTooltipWhileKeyDown(KeyType keyType, List<Component> tooltips, Component component) {
        if (TooltipHelper.getKeyType(keyType)) {
            TooltipHelper.addTooltip(tooltips, component);
        } else {
            tooltips.add((Component)Component.translatable((String)("tooltip.ifeu.held." + keyType.getValue())).withStyle(ChatFormatting.GRAY));
        }
    }

    public static void addTooltip(List<Component> tooltips, ItemStack itemStack) {
        tooltips.add((Component)Component.translatable((String)TooltipHelper.itemIdToKey(itemStack)));
    }

    public static void addTooltip(List<Component> tooltips, Component component) {
        tooltips.add(component);
    }

    public static void addTooltip(List<Component> tooltips, ItemStack itemStack, ChatFormatting style, Object ... obj) {
        tooltips.add((Component)Component.translatable((String)TooltipHelper.itemIdToKey(itemStack), (Object[])obj).withStyle(style));
    }

    public static void addTooltip(List<Component> tooltips, ItemStack itemStack, ChatFormatting style) {
        tooltips.add((Component)Component.translatable((String)TooltipHelper.itemIdToKey(itemStack)).withStyle(style));
    }

    public static void addTooltip(List<Component> tooltips, String id) {
        tooltips.add((Component)Component.translatable((String)("tooltip.ifeu." + id)));
    }

    public static void addTooltip(List<Component> tooltips, String id, ChatFormatting style) {
        tooltips.add((Component)Component.translatable((String)("tooltip.ifeu." + id)).withStyle(style));
    }

    public static void addTooltip(List<Component> tooltips, String id, ChatFormatting style, Object ... obj) {
        tooltips.add((Component)Component.translatable((String)("tooltip.ifeu." + id), (Object[])obj).withStyle(style));
    }

    public static void addTooltip(List<Component> tooltips, String id, Object ... obj) {
        tooltips.add((Component)Component.translatable((String)("tooltip.ifeu." + id), (Object[])obj));
    }

    public static String itemIdToKey(ItemStack itemStack) {
        String rawKey = itemStack.getDescriptionId();
        return "tooltip" + rawKey.substring(rawKey.indexOf("."));
    }

    public static void addTooltipWhileKeyDown(KeyType keyType, List<Component> tooltips, ItemStack itemStack) {
        if (TooltipHelper.getKeyType(keyType)) {
            TooltipHelper.addTooltip(tooltips, itemStack);
        } else {
            tooltips.add((Component)Component.translatable((String)("tooltip.ifeu.held." + keyType.getValue())).withStyle(ChatFormatting.GRAY));
        }
    }

    public static void addTooltipWhileKeyDown(KeyType keyType, List<Component> tooltips, ItemStack itemStack, ChatFormatting style, Object ... obj) {
        if (TooltipHelper.getKeyType(keyType)) {
            TooltipHelper.addTooltip(tooltips, itemStack, style, obj);
        } else {
            tooltips.add((Component)Component.translatable((String)("tooltip.ifeu.held." + keyType.getValue())).withStyle(ChatFormatting.GRAY));
        }
    }

    public static void addTooltipWhileKeyDown(KeyType keyType, List<Component> tooltips, ItemStack itemStack, ChatFormatting style) {
        if (TooltipHelper.getKeyType(keyType)) {
            TooltipHelper.addTooltip(tooltips, itemStack, style);
        } else {
            tooltips.add((Component)Component.translatable((String)("tooltip.ifeu.held." + keyType.getValue())).withStyle(ChatFormatting.GRAY));
        }
    }

    public static void addTooltipWhileKeyDown(KeyType keyType, List<Component> tooltips, ITooltipContext context) {
        if (TooltipHelper.getKeyType(keyType)) {
            context.addTooltips();
        } else {
            tooltips.add((Component)Component.translatable((String)("tooltip.ifeu.held." + keyType.getValue())).withStyle(ChatFormatting.GRAY));
        }
    }

    public static enum KeyType {
        SHIFT("shift"),
        ALT("alt"),
        CONTROL("control");

        private final String value;

        private KeyType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static interface ITooltipContext {
        public void addTooltips();
    }
}

