/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.chunkloaders;

import com.supermartijn642.chunkloaders.ChunkLoaderType;
import com.supermartijn642.chunkloaders.ChunkLoadersClient;
import com.supermartijn642.chunkloaders.capability.ChunkLoadingCapability;
import com.supermartijn642.chunkloaders.generators.ChunkLoadersBlockStateGenerator;
import com.supermartijn642.chunkloaders.generators.ChunkLoadersLanguageGenerator;
import com.supermartijn642.chunkloaders.generators.ChunkLoadersLootTableGenerator;
import com.supermartijn642.chunkloaders.generators.ChunkLoadersModelGenerator;
import com.supermartijn642.chunkloaders.generators.ChunkLoadersRecipeGenerator;
import com.supermartijn642.chunkloaders.generators.ChunkLoadersTagGenerator;
import com.supermartijn642.chunkloaders.packet.PackedChunkLoaderAdded;
import com.supermartijn642.chunkloaders.packet.PackedChunkLoaderRemoved;
import com.supermartijn642.chunkloaders.packet.PackedStartLoadingChunk;
import com.supermartijn642.chunkloaders.packet.PackedStopLoadingChunk;
import com.supermartijn642.chunkloaders.packet.PackedTogglePlayerActivity;
import com.supermartijn642.chunkloaders.packet.PacketFullCapabilityData;
import com.supermartijn642.chunkloaders.packet.PacketToggleChunk;
import com.supermartijn642.core.CommonUtils;
import com.supermartijn642.core.item.CreativeItemGroup;
import com.supermartijn642.core.network.PacketChannel;
import com.supermartijn642.core.registry.GeneratorRegistrationHandler;
import com.supermartijn642.core.registry.RegistrationHandler;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.world.chunk.RegisterTicketControllersEvent;
import net.neoforged.neoforge.common.world.chunk.TicketController;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="chunkloaders")
public class ChunkLoaders {
    public static final Logger LOGGER = LogManager.getLogger((String)"chunkloaders");
    public static final PacketChannel CHANNEL = PacketChannel.create((String)"chunkloaders");
    public static final CreativeItemGroup GROUP = CreativeItemGroup.create((String)"chunkloaders", ChunkLoaderType.ADVANCED::getItem);
    public static final TicketController TICKET_CONTROLLER = new TicketController(ResourceLocation.fromNamespaceAndPath((String)"chunkloaders", (String)"chunks"), (level, ticketHelper) -> ChunkLoadingCapability.get((Level)level).castServer().onLoadLevel(ticketHelper));

    public ChunkLoaders(IEventBus eventBus) {
        eventBus.addListener(this::registerTicketController);
        CHANNEL.registerMessage(PackedChunkLoaderAdded.class, PackedChunkLoaderAdded::new, true);
        CHANNEL.registerMessage(PackedChunkLoaderRemoved.class, PackedChunkLoaderRemoved::new, true);
        CHANNEL.registerMessage(PackedStartLoadingChunk.class, PackedStartLoadingChunk::new, true);
        CHANNEL.registerMessage(PackedStopLoadingChunk.class, PackedStopLoadingChunk::new, true);
        CHANNEL.registerMessage(PackedTogglePlayerActivity.class, PackedTogglePlayerActivity::new, true);
        CHANNEL.registerMessage(PacketFullCapabilityData.class, PacketFullCapabilityData::new, true);
        CHANNEL.registerMessage(PacketToggleChunk.class, PacketToggleChunk::new, true);
        ChunkLoaders.register();
        if (CommonUtils.getEnvironmentSide().isClient()) {
            ChunkLoadersClient.register();
        }
        ChunkLoaders.registerGenerators();
    }

    public void registerTicketController(RegisterTicketControllersEvent e) {
        e.register(TICKET_CONTROLLER);
    }

    private static void register() {
        RegistrationHandler handler = RegistrationHandler.get((String)"chunkloaders");
        for (ChunkLoaderType type : ChunkLoaderType.values()) {
            handler.registerBlockCallback(type::registerBlock);
            handler.registerBlockEntityTypeCallback(type::registerBlockEntity);
            handler.registerItemCallback(type::registerItem);
        }
    }

    private static void registerGenerators() {
        GeneratorRegistrationHandler handler = GeneratorRegistrationHandler.get((String)"chunkloaders");
        handler.addGenerator(ChunkLoadersModelGenerator::new);
        handler.addGenerator(ChunkLoadersBlockStateGenerator::new);
        handler.addGenerator(ChunkLoadersLanguageGenerator::new);
        handler.addGenerator(ChunkLoadersLootTableGenerator::new);
        handler.addGenerator(ChunkLoadersRecipeGenerator::new);
        handler.addGenerator(ChunkLoadersTagGenerator::new);
    }
}

