/*
 * Decompiled with CFR 0.152.
 */
package artifacts.network;

import artifacts.Artifacts;
import artifacts.component.ToggleIdentifier;
import artifacts.equipment.EquipmentHelper;
import artifacts.network.NetworkHandler;
import artifacts.registry.ModDataComponents;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public record ToggleKeyPressedPacket(ToggleIdentifier identifier) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ToggleKeyPressedPacket> TYPE = new CustomPacketPayload.Type(Artifacts.id("toggle_key_pressed"));
    public static final StreamCodec<ByteBuf, ToggleKeyPressedPacket> CODEC = ToggleIdentifier.STREAM_CODEC.map(ToggleKeyPressedPacket::new, ToggleKeyPressedPacket::identifier);

    void apply(NetworkHandler.PayloadContext context) {
        Player player = context.player();
        context.queue(() -> EquipmentHelper.iterateEquipment((LivingEntity)player, stack -> {
            ToggleIdentifier id;
            Object patt0$temp = stack.get(ModDataComponents.TOGGLE_KEY.get());
            if (patt0$temp instanceof ToggleIdentifier && (id = (ToggleIdentifier)((Object)((Object)((Object)patt0$temp)))) == this.identifier) {
                if (stack.has(ModDataComponents.DISABLED_BY_TOGGLE.get())) {
                    stack.remove(ModDataComponents.DISABLED_BY_TOGGLE.get());
                } else {
                    stack.set(ModDataComponents.DISABLED_BY_TOGGLE.get(), (Object)Unit.INSTANCE);
                }
            }
        }));
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

