/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.base.client.screen.control.redstone.sensor;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectSets;
import it.zerono.mods.zerocore.base.client.screen.control.redstone.sensor.ISensorBuilder;
import it.zerono.mods.zerocore.base.client.screen.control.redstone.sensor.ISensorValidator;
import it.zerono.mods.zerocore.base.client.screen.control.redstone.sensor.SensorGroupPanelBuilder;
import it.zerono.mods.zerocore.base.redstone.sensor.ISensorType;
import it.zerono.mods.zerocore.base.redstone.sensor.SensorBehavior;
import it.zerono.mods.zerocore.lib.IMachineReader;
import it.zerono.mods.zerocore.lib.client.gui.ModContainerScreen;
import it.zerono.mods.zerocore.lib.client.gui.control.Label;
import it.zerono.mods.zerocore.lib.client.gui.control.TextConstraints;
import it.zerono.mods.zerocore.lib.client.gui.control.TextInput;
import it.zerono.mods.zerocore.lib.client.gui.sprite.ISprite;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import it.zerono.mods.zerocore.lib.text.TextHelper;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SensorGroupPanelBuilder<Reader extends IMachineReader, SensorType extends Enum<SensorType>>
implements ISensorBuilder<Reader, SensorType> {
    private final ModContainerScreen<? extends ModContainer> _gui;
    private final int _width;
    private final int _height;
    private final Set<SensorType> _validSensors;
    private final Map<SensorType, BehaviorGroupBuilder> _behaviorGroupsBuilders;
    private final List<BehaviorGroupBuilder> _behaviorGroupsOrder;

    @SafeVarargs
    public SensorGroupPanelBuilder(ModContainerScreen<? extends ModContainer> gui, int width, int height, SensorType ... validSensors) {
        this._gui = gui;
        this._width = width;
        this._height = height;
        this._validSensors = ObjectSets.unmodifiable((ObjectSet)new ObjectArraySet((Object[])validSensors));
        this._behaviorGroupsOrder = new ObjectArrayList(32);
        this._behaviorGroupsBuilders = new Object2ObjectArrayMap(32);
    }

    public List<SensorType> getSensors() {
        return this._behaviorGroupsOrder.stream().filter(Objects::nonNull).map(BehaviorGroupBuilder::getSensor).collect(Collectors.toList());
    }

    public List<BehaviorGroupBuilder> getGroupsBuilders() {
        return this._behaviorGroupsOrder;
    }

    public ModContainerScreen<? extends ModContainer> getGui() {
        return this._gui;
    }

    public int getWidth() {
        return this._width;
    }

    public int getHeight() {
        return this._height;
    }

    @Override
    public ISensorBuilder.IBehaviorGroupBuilder<Reader, SensorType> addSensor(SensorType sensor, Supplier<@NotNull ISprite> buttonOffSprite, Supplier<@NotNull ISprite> buttonOnSprite) {
        Preconditions.checkArgument((boolean)this._validSensors.contains(sensor), (Object)"The specified sensor is not valid.");
        if (this._behaviorGroupsBuilders.containsKey(sensor)) {
            return this._behaviorGroupsBuilders.get(sensor);
        }
        BehaviorGroupBuilder builder = new BehaviorGroupBuilder(this, sensor, buttonOffSprite, buttonOnSprite);
        this._behaviorGroupsBuilders.put(sensor, builder);
        this._behaviorGroupsOrder.add(builder);
        return builder;
    }

    @Override
    public ISensorBuilder<Reader, SensorType> addSeparator() {
        this._behaviorGroupsOrder.add(null);
        return this;
    }

    @Override
    public void build() {
    }

    public static class BehaviorGroupBuilder
    implements ISensorBuilder.IBehaviorGroupBuilder<Reader, SensorType> {
        private final SensorType _sensor;
        private final List<SensorBehavior> _validBehaviors;
        private final Supplier<@NotNull ISprite> _buttonOffSprite;
        private final Supplier<@NotNull ISprite> _buttonOnSprite;
        private final Map<SensorBehavior, it.zerono.mods.zerocore.base.client.screen.control.redstone.sensor.SensorGroupPanelBuilder$BehaviorGroupBuilder.BehaviorBuilder> _behaviorsBuilders;
        private final List<SensorBehavior> _addedBehaviors;
        final /* synthetic */ SensorGroupPanelBuilder this$0;

        public BehaviorGroupBuilder(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @NotNull SensorType sensor, Supplier<@NotNull ISprite> buttonOffSprite, Supplier<ISprite> buttonOnSprite) {
            this.this$0 = this$0;
            this._sensor = sensor;
            this._validBehaviors = ((ISensorType)sensor).getBehaviors();
            this._buttonOffSprite = buttonOffSprite;
            this._buttonOnSprite = buttonOnSprite;
            this._behaviorsBuilders = new Object2ObjectArrayMap(SensorBehavior.values().length);
            this._addedBehaviors = new ObjectArrayList(SensorBehavior.values().length);
        }

        public SensorType getSensor() {
            return this._sensor;
        }

        public Supplier<@NotNull ISprite> getButtonOnSprite() {
            return this._buttonOnSprite;
        }

        public Supplier<@NotNull ISprite> getButtonOffSprite() {
            return this._buttonOffSprite;
        }

        public List<SensorBehavior> getBehaviors() {
            return this._addedBehaviors;
        }

        public it.zerono.mods.zerocore.base.client.screen.control.redstone.sensor.SensorGroupPanelBuilder$BehaviorGroupBuilder.BehaviorBuilder getBehaviorBuilder(SensorBehavior behavior) {
            return (BehaviorBuilder)this._behaviorsBuilders.get((Object)behavior);
        }

        public ModContainerScreen<? extends ModContainer> getGui() {
            return this.this$0._gui;
        }

        public int getWidth() {
            return this.this$0._width;
        }

        public int getHeight() {
            return this.this$0._height;
        }

        @Override
        public ISensorBuilder.IBehaviorBuilder<Reader, SensorType> addBehavior(SensorBehavior behavior) {
            Preconditions.checkArgument((boolean)this._validBehaviors.contains((Object)behavior), (Object)"The specified behavior is not valid for the sensor being built.");
            if (this._behaviorsBuilders.containsKey((Object)behavior)) {
                return (ISensorBuilder.IBehaviorBuilder)this._behaviorsBuilders.get((Object)behavior);
            }
            BehaviorBuilder builder = new BehaviorBuilder(behavior);
            this._addedBehaviors.add(behavior);
            this._behaviorsBuilders.put(behavior, (it.zerono.mods.zerocore.base.client.screen.control.redstone.sensor.SensorGroupPanelBuilder$BehaviorGroupBuilder.BehaviorBuilder)builder);
            return builder;
        }

        @Override
        public ISensorBuilder<Reader, SensorType> addStandardOutputBehaviorsNumbers(String suffix, String amountAboveLabelTranslationKey, String amountBelowLabelTranslationKey, String amountBetweenMinLabelTranslationKey, String amountBetweenMaxLabelTranslationKey, BiConsumer<@NotNull SensorBehavior, @NotNull TextInput> configurator) {
            this.addBehavior(SensorBehavior.ActiveWhileAbove).addNumberField(amountAboveLabelTranslationKey, "above", suffix, configurator);
            this.addBehavior(SensorBehavior.ActiveWhileBelow).addNumberField(amountBelowLabelTranslationKey, "below", suffix, configurator);
            this.addBehavior(SensorBehavior.ActiveWhileBetween).addNumberField(amountBetweenMinLabelTranslationKey, "betweenMin", suffix, configurator).addNumberField(amountBetweenMaxLabelTranslationKey, "betweenMax", suffix, configurator).setValidator(this::minMaxValidator);
            return this.build();
        }

        @Override
        public ISensorBuilder<Reader, SensorType> addStandardOutputBehaviorsPercentages(String amountAboveLabelTranslationKey, String amountBelowLabelTranslationKey, String amountBetweenMinLabelTranslationKey, String amountBetweenMaxLabelTranslationKey, BiConsumer<@NotNull SensorBehavior, @NotNull TextInput> configurator) {
            this.addBehavior(SensorBehavior.ActiveWhileAbove).addPercentageField(amountAboveLabelTranslationKey, "above", configurator);
            this.addBehavior(SensorBehavior.ActiveWhileBelow).addPercentageField(amountBelowLabelTranslationKey, "below", configurator);
            this.addBehavior(SensorBehavior.ActiveWhileBetween).addPercentageField(amountBetweenMinLabelTranslationKey, "betweenMin", configurator).addPercentageField(amountBetweenMaxLabelTranslationKey, "betweenMax", configurator).setValidator(this::minMaxValidator);
            return this.build();
        }

        @Override
        public ISensorBuilder<Reader, SensorType> build() {
            return this.this$0;
        }

        private void minMaxValidator(Consumer<@NotNull Component> errors, int ... values) {
            if (values[0] >= values[1]) {
                errors.accept((Component)TextHelper.translatable("gui.zerocore.base.redstone.validation.invalidminmax.text"));
            }
        }

        public class BehaviorBuilder
        implements ISensorBuilder.IBehaviorBuilder<Reader, SensorType> {
            private final SensorBehavior _behavior;
            private final TextInput[] _inputs;
            private final Label[] _inputLabels;
            private int _nextInputIdx;
            @Nullable
            private ISensorValidator _validator;

            public BehaviorBuilder(SensorBehavior behavior) {
                this._behavior = behavior;
                this._inputs = new TextInput[2];
                this._inputLabels = new Label[2];
                this._nextInputIdx = 0;
            }

            public SensorBehavior getBehavior() {
                return this._behavior;
            }

            public ModContainerScreen<? extends ModContainer> getGui() {
                return BehaviorGroupBuilder.this.this$0._gui;
            }

            public int getWidth() {
                return BehaviorGroupBuilder.this.this$0._width;
            }

            public int getHeight() {
                return BehaviorGroupBuilder.this.this$0._height;
            }

            public TextInput[] getInputs() {
                return Arrays.copyOf(this._inputs, this._nextInputIdx);
            }

            public Label getInputLabel(int idx) {
                return this._inputLabels[idx];
            }

            @Nullable
            public ISensorValidator getValidator() {
                return this._validator;
            }

            @Override
            public ISensorBuilder.IBehaviorBuilder<Reader, SensorType> addInputField(String controlLabelTranslationKey, TextInput control) {
                Preconditions.checkState((this._nextInputIdx < 2 ? 1 : 0) != 0, (Object)"Only up to two input fields can be added.");
                this._inputLabels[this._nextInputIdx] = this.createInputFieldLabel(control.getName() + "Label", controlLabelTranslationKey);
                this._inputs[this._nextInputIdx] = control;
                ++this._nextInputIdx;
                return this;
            }

            @Override
            public ISensorBuilder.IBehaviorBuilder<Reader, SensorType> addNumberField(String controlLabelTranslationKey, String name, String suffix, BiConsumer<@NotNull SensorBehavior, @NotNull TextInput> configurator) {
                TextInput input = this.createInputField(name, suffix);
                input.setMaxLength(10);
                input.addConstraint(TextConstraints.CONSTRAINT_POSITIVE_INTEGER_NUMBER);
                configurator.accept(this._behavior, input);
                return this.addInputField(controlLabelTranslationKey, input);
            }

            @Override
            public ISensorBuilder.IBehaviorBuilder<Reader, SensorType> addPercentageField(String controlLabelTranslationKey, String name, BiConsumer<@NotNull SensorBehavior, @NotNull TextInput> configurator) {
                TextInput input = this.createInputField(name, "%");
                input.setMaxLength(3);
                input.addConstraint(TextConstraints.CONSTRAINT_PERCENTAGE);
                input.setDesiredDimension(40, 14);
                configurator.accept(this._behavior, input);
                return this.addInputField(controlLabelTranslationKey, input);
            }

            @Override
            public ISensorBuilder.IBehaviorBuilder<Reader, SensorType> setValidator(ISensorValidator validator) {
                this._validator = validator;
                return this;
            }

            @Override
            public ISensorBuilder.IBehaviorGroupBuilder<Reader, SensorType> build() {
                return BehaviorGroupBuilder.this;
            }

            private TextInput createInputField(String name, String suffix) {
                TextInput input = new TextInput(BehaviorGroupBuilder.this.this$0._gui, name, "0");
                input.setDesiredDimension(70, 14);
                input.setFilter(TextConstraints.FILTER_NUMBERS);
                input.setDisplaySuffix(suffix);
                return input;
            }

            private Label createInputFieldLabel(String name, String translationKey) {
                Label label = new Label(this.getGui(), name, (Component)TextHelper.translatable(translationKey));
                label.setPadding(0);
                label.setDesiredDimension(this.getWidth(), 10);
                return label;
            }
        }
    }
}

