/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.base.multiblock.part.io.power;

import it.zerono.mods.zerocore.base.multiblock.part.AbstractMultiblockEntity;
import it.zerono.mods.zerocore.base.multiblock.part.io.IOPortBlockCapabilitySource;
import it.zerono.mods.zerocore.base.multiblock.part.io.power.AbstractPowerPortHandler;
import it.zerono.mods.zerocore.lib.data.IoMode;
import it.zerono.mods.zerocore.lib.data.WideAmount;
import it.zerono.mods.zerocore.lib.data.stack.OperationMode;
import it.zerono.mods.zerocore.lib.energy.EnergySystem;
import it.zerono.mods.zerocore.lib.multiblock.cuboid.AbstractCuboidMultiblockController;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class PowerPortHandlerForgeEnergy<Controller extends AbstractCuboidMultiblockController<Controller>, Port extends AbstractMultiblockEntity<Controller>>
extends AbstractPowerPortHandler<Controller, Port>
implements IEnergyStorage {
    private final IOPortBlockCapabilitySource<Controller, Port, IEnergyStorage> _remoteCapabilitySource;

    public PowerPortHandlerForgeEnergy(Port port, IoMode mode) {
        super(EnergySystem.ForgeEnergy, port, mode);
        this._remoteCapabilitySource = new IOPortBlockCapabilitySource(port, Capabilities.EnergyStorage.BLOCK);
    }

    @Override
    public boolean isConnected() {
        return null != this._remoteCapabilitySource.getCapability();
    }

    @Override
    public void onPortChanged() {
        this._remoteCapabilitySource.onPortChanged();
    }

    @Override
    public WideAmount outputEnergy(WideAmount amount) {
        IEnergyStorage consumer = (IEnergyStorage)this._remoteCapabilitySource.getCapability();
        if (null == consumer || !this.isOutput() || this.isPassive()) {
            return WideAmount.ZERO;
        }
        int maxUnits = Math.min(amount.intValue(), Integer.MAX_VALUE);
        return WideAmount.asImmutable(consumer.receiveEnergy(maxUnits, false));
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return this.canReceive() ? this.getEnergyStorage().insertEnergy(this.getEnergySystem(), this.maxTransferRate(maxReceive), OperationMode.from(simulate)).intValue() : 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return this.canExtract() ? this.getEnergyStorage().extractEnergy(this.getEnergySystem(), this.maxTransferRate(maxExtract), OperationMode.from(simulate)).intValue() : 0;
    }

    public int getEnergyStored() {
        return this.getEnergyStorage().getEnergyStored(this.getEnergySystem()).intValue();
    }

    public int getMaxEnergyStored() {
        return this.getEnergyStorage().getCapacity(this.getEnergySystem()).intValue();
    }

    public boolean canExtract() {
        return this.isOutput() && this.isPassive();
    }

    public boolean canReceive() {
        return this.isInput() && this.isPassive();
    }
}

