/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.gui.control;

import it.zerono.mods.zerocore.lib.client.gui.IControl;
import it.zerono.mods.zerocore.lib.client.gui.ModContainerScreen;
import it.zerono.mods.zerocore.lib.client.gui.Padding;
import it.zerono.mods.zerocore.lib.client.gui.control.AbstractCompositeControl;
import it.zerono.mods.zerocore.lib.client.gui.control.UpDown;
import it.zerono.mods.zerocore.lib.data.EnumIndexedArray;
import it.zerono.mods.zerocore.lib.data.EnumIndexerSelection;
import it.zerono.mods.zerocore.lib.data.geometry.Rectangle;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.IBindableData;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Direction;

public abstract class AbstractChoiceControl<Index extends Enum<Index>, Value, Control extends IControl>
extends AbstractCompositeControl {
    private final EnumIndexedArray<Index, Value> _values;
    private final EnumIndexerSelection<Index> _selected;
    private final UpDown _updown;
    private final Control _valueControl;

    protected AbstractChoiceControl(ModContainerScreen<? extends ModContainer> gui, String name, Control valueControl, EnumIndexedArray<Index, Value> indexedArray) {
        super(gui, name);
        this._values = indexedArray;
        this._selected = new EnumIndexerSelection(indexedArray);
        this._updown = new UpDown(gui, "ud");
        this._updown.Clicked.subscribe(this::changeSelection);
        this._valueControl = valueControl;
        this.addChildControl(new IControl[]{this._valueControl, this._updown});
    }

    public Index getSelectedIndex() {
        return this._selected.getSelection();
    }

    public void setSelectedIndex(Index index) {
        this._selected.setSelection(index);
        this.onSelectionChanged(index, this._valueControl);
    }

    public void bindSelectedIndex(IBindableData<Index> bindableIndex) {
        bindableIndex.bind(this::setSelectedIndex);
    }

    public Optional<Value> getSelectedValue() {
        return this._values.getElement(this.getSelectedIndex());
    }

    public List<Index> getValidIndices() {
        return this._values.getValidIndices();
    }

    protected abstract void onSelectionChanged(Index var1, Control var2);

    protected Control getValueControl() {
        return this._valueControl;
    }

    protected void setValue(Index index, Value value) {
        this._values.setElement(index, value);
    }

    @Override
    public void setBounds(Rectangle bounds) {
        super.setBounds(bounds);
        Padding padding = this.getPadding();
        int h = bounds.Height - padding.getBottom() - padding.getTop();
        int valueWidth = bounds.Width - h - padding.getRight() - padding.getLeft();
        this._valueControl.setBounds(new Rectangle(padding.getLeft(), padding.getTop(), valueWidth, h));
        this._updown.setBounds(new Rectangle(valueWidth + padding.getLeft(), padding.getTop(), h, h));
    }

    @Override
    protected StringBuilder toStringBuilder() {
        return super.toStringBuilder().append(" indices:[").append(this._values.getValidIndices()).append("]; sel:").append(this._selected.getSelection());
    }

    private void changeSelection(Direction.AxisDirection changeDirection, Integer buttonClicked) {
        switch (changeDirection) {
            case POSITIVE: {
                this.onSelectionChanged(this._selected.selectNext(), this._valueControl);
                break;
            }
            case NEGATIVE: {
                this.onSelectionChanged(this._selected.selectPrevious(), this._valueControl);
            }
        }
    }
}

