/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.datagen.provider.client.state;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.data.models.blockstates.Condition;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class ConditionBuilder {
    private final Consumer<@NotNull Condition> _sink;
    private Condition _condition;

    static Condition root(Consumer<@NotNull ConditionBuilder> rootConditionBuilder) {
        ObjectArrayList conditions = new ObjectArrayList(16);
        ConditionBuilder builder = new ConditionBuilder(arg_0 -> ConditionBuilder.lambda$root$0((List)conditions, arg_0));
        rootConditionBuilder.accept(builder);
        if (conditions.isEmpty()) {
            throw new IllegalStateException("No Condition were added by this builder");
        }
        return (Condition)conditions.get(0);
    }

    static List<Condition> nested(Consumer<@NotNull ConditionBuilder> nestedConditionBuilder) {
        ObjectArrayList conditions = new ObjectArrayList(16);
        ConditionBuilder builder = new ConditionBuilder(((List)conditions)::add);
        nestedConditionBuilder.accept(builder);
        if (conditions.isEmpty()) {
            throw new IllegalStateException("No Condition were added by this builder");
        }
        return conditions;
    }

    public void build() {
        Preconditions.checkState((null != this._condition ? 1 : 0) != 0, (Object)"No Condition to build");
        this._sink.accept(this._condition);
        this._condition = null;
    }

    public ConditionBuilder and(Consumer<@NotNull ConditionBuilder> nestedConditionBuilder) {
        return this.composite(Condition::and, nestedConditionBuilder);
    }

    public ConditionBuilder or(Consumer<@NotNull ConditionBuilder> nestedConditionBuilder) {
        return this.composite(Condition::or, nestedConditionBuilder);
    }

    public <T extends Comparable<T>> ConditionBuilder match(Property<T> property, T value) {
        Preconditions.checkNotNull(property, (Object)"Property must not be null");
        Preconditions.checkNotNull(value, (Object)"Value must not be null");
        this.getCurrentTerminalConditionOrThrow().term(property, value);
        return this;
    }

    @SafeVarargs
    public final <T extends Comparable<T>> ConditionBuilder match(Property<T> property, T value, T ... otherValues) {
        Preconditions.checkNotNull(property, (Object)"Property must not be null");
        Preconditions.checkNotNull(value, (Object)"Value must not be null");
        this.getCurrentTerminalConditionOrThrow().term(property, value, otherValues);
        return this;
    }

    public <T extends Comparable<T>> ConditionBuilder dontMatch(Property<T> property, T value) {
        Preconditions.checkNotNull(property, (Object)"Property must not be null");
        Preconditions.checkNotNull(value, (Object)"Value must not be null");
        this.getCurrentTerminalConditionOrThrow().negatedTerm(property, value);
        return this;
    }

    @SafeVarargs
    public final <T extends Comparable<T>> ConditionBuilder dontMatch(Property<T> property, T value, T ... otherValues) {
        Preconditions.checkNotNull(property, (Object)"Property must not be null");
        Preconditions.checkNotNull(value, (Object)"Value must not be null");
        this.getCurrentTerminalConditionOrThrow().negatedTerm(property, value, otherValues);
        return this;
    }

    private ConditionBuilder(Consumer<@NotNull Condition> conditionSink) {
        this._sink = conditionSink;
    }

    private ConditionBuilder composite(Function<@NotNull Condition[], @NotNull Condition> factory, Consumer<@NotNull ConditionBuilder> nestedConditionBuilder) {
        Preconditions.checkNotNull(nestedConditionBuilder);
        this._condition = factory.apply((Condition[])ConditionBuilder.nested(nestedConditionBuilder).toArray(Condition[]::new));
        return this;
    }

    private Condition.TerminalCondition getCurrentTerminalConditionOrThrow() {
        if (null == this._condition) {
            Condition.TerminalCondition condition = Condition.condition();
            this._condition = condition;
            return condition;
        }
        if (!(this._condition instanceof Condition.TerminalCondition)) {
            throw new IllegalStateException("A non-terminal Condition is already being build");
        }
        return (Condition.TerminalCondition)this._condition;
    }

    private static /* synthetic */ void lambda$root$0(List conditions, Condition condition) {
        if (!conditions.isEmpty()) {
            throw new IllegalStateException("A Condition was already added by this builder");
        }
        conditions.add(condition);
    }
}

