/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.datagen.provider.loot;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.loot.EntityLootSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.storage.loot.LootTable;

public abstract class ModEntityLootSubProvider
extends EntityLootSubProvider {
    private final Set<EntityType<?>> _registeredTypes = new ObjectOpenHashSet(128);

    protected ModEntityLootSubProvider(FeatureFlagSet enabledFeatures, HolderLookup.Provider provider) {
        super(enabledFeatures, provider);
    }

    protected void add(EntityType<?> entityType, ResourceKey<LootTable> defaultTable, LootTable.Builder builder) {
        Preconditions.checkState((boolean)this._registeredTypes.add(entityType), (String)"Entity type %s was already added to this sub provider", entityType);
        super.add(entityType, defaultTable, builder);
    }

    protected void add(Supplier<EntityType<?>> entityType, LootTable.Builder builder) {
        this.add(entityType.get(), builder);
    }

    protected void add(Supplier<EntityType<?>> entityType, ResourceKey<LootTable> defaultTable, LootTable.Builder builder) {
        this.add(entityType.get(), defaultTable, builder);
    }

    protected Stream<EntityType<?>> getKnownEntityTypes() {
        return this._registeredTypes.stream();
    }
}

