/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.item.inventory;

import it.zerono.mods.zerocore.lib.DebuggableHelper;
import it.zerono.mods.zerocore.lib.IDebugMessages;
import it.zerono.mods.zerocore.lib.IDebuggable;
import it.zerono.mods.zerocore.lib.data.component.IComponentProvider;
import it.zerono.mods.zerocore.lib.data.component.ItemStackListComponent;
import it.zerono.mods.zerocore.lib.data.nbt.ISyncableEntity;
import it.zerono.mods.zerocore.lib.data.stack.AbstractStackHolder;
import it.zerono.mods.zerocore.lib.data.stack.IStackHolder;
import it.zerono.mods.zerocore.lib.data.stack.IStackHolderAccess;
import it.zerono.mods.zerocore.lib.data.stack.StackAdapters;
import java.util.function.BiPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.neoforged.fml.LogicalSide;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class ItemStackHolder
extends AbstractStackHolder<ItemStackHolder, ItemStack>
implements IStackHolderAccess<ItemStackHolder, ItemStack>,
IItemHandler,
IItemHandlerModifiable,
INBTSerializable<CompoundTag>,
ISyncableEntity,
IDebuggable,
IComponentProvider<ItemStackListComponent> {
    protected NonNullList<ItemStack> _stacks;

    public ItemStackHolder(int size) {
        this((NonNullList<ItemStack>)NonNullList.withSize((int)size, (Object)ItemStack.EMPTY), (Integer x$0, ItemStack x$1) -> AbstractStackHolder.defaultValidator(x$0, x$1));
    }

    public ItemStackHolder(int size, BiPredicate<Integer, ItemStack> stackValidator) {
        this((NonNullList<ItemStack>)NonNullList.withSize((int)size, (Object)ItemStack.EMPTY), stackValidator);
    }

    public void setSize(int size) {
        this._stacks = NonNullList.withSize((int)size, (Object)ItemStack.EMPTY);
    }

    @Override
    public boolean isEmpty(int index) {
        return this.getStackInSlot(index).isEmpty();
    }

    @Override
    public int getAmount(int index) {
        return this.getStackInSlot(index).getCount();
    }

    @Override
    public ItemStack getStackAt(int index) {
        return this.getStackInSlot(index);
    }

    @Override
    public void setStackAt(int index, ItemStack stack) {
        this.setStackInSlot(index, stack);
    }

    public int getSlots() {
        return this._stacks.size();
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        this.validateSlotIndex(slot);
        return (ItemStack)this._stacks.get(slot);
    }

    @NotNull
    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = (ItemStack)this._stacks.get(slot);
        int limit = this.getStackLimit(slot, stack);
        if (!existing.isEmpty()) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= existing.getCount();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.getCount() > limit;
        if (!simulate) {
            if (existing.isEmpty()) {
                this._stacks.set(slot, (Object)(reachedLimit ? stack.copyWithCount(limit) : stack));
                this.onChange(IStackHolder.ChangeType.Added, slot);
            } else {
                existing.grow(reachedLimit ? limit : stack.getCount());
                this.onChange(IStackHolder.ChangeType.Grown, slot);
            }
        }
        return reachedLimit ? stack.copyWithCount(stack.getCount() - limit) : ItemStack.EMPTY;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (0 == amount) {
            return ItemStack.EMPTY;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = (ItemStack)this._stacks.get(slot);
        if (existing.isEmpty()) {
            return ItemStack.EMPTY;
        }
        int toExtract = Math.min(amount, existing.getMaxStackSize());
        if (existing.getCount() <= toExtract) {
            if (!simulate) {
                this._stacks.set(slot, (Object)ItemStack.EMPTY);
                this.onChange(IStackHolder.ChangeType.Removed, slot);
                return existing;
            }
            return existing.copy();
        }
        if (!simulate) {
            this._stacks.set(slot, (Object)existing.copyWithCount(existing.getCount() - toExtract));
            this.onChange(IStackHolder.ChangeType.Shrunk, slot);
        }
        return existing.copyWithCount(toExtract);
    }

    public int getSlotLimit(int slot) {
        return this.getMaxCapacity(slot);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return this.isStackValid(slot, stack);
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.validateSlotIndex(slot);
        boolean wasEmpty = this.isEmpty(slot);
        boolean isNowEmpty = stack.isEmpty();
        if (wasEmpty && isNowEmpty) {
            return;
        }
        this._stacks.set(slot, (Object)stack);
        this.onChange(wasEmpty ? IStackHolder.ChangeType.Added : (isNowEmpty ? IStackHolder.ChangeType.Removed : IStackHolder.ChangeType.Replaced), slot);
    }

    public CompoundTag serializeNBT(HolderLookup.Provider registries) {
        return this.syncDataTo(new CompoundTag(), registries, ISyncableEntity.SyncReason.FullSync);
    }

    public void deserializeNBT(HolderLookup.Provider registries, CompoundTag nbt) {
        this.syncDataFrom(nbt, registries, ISyncableEntity.SyncReason.FullSync);
    }

    @Override
    public void syncDataFrom(CompoundTag data, HolderLookup.Provider registries, ISyncableEntity.SyncReason syncReason) {
        this.syncFrom(data, registries, StackAdapters.ITEMSTACK, size -> {
            if (size > 0) {
                this.setSize(size);
            }
            return this._stacks;
        });
    }

    @Override
    public CompoundTag syncDataTo(CompoundTag data, HolderLookup.Provider registries, ISyncableEntity.SyncReason syncReason) {
        return this.syncTo(data, registries, this._stacks, StackAdapters.ITEMSTACK);
    }

    @Override
    public ItemStackListComponent createDataComponent() {
        return new ItemStackListComponent(this._stacks);
    }

    @Override
    public void mergeComponent(ItemStackListComponent component) {
        component.copyInto(this._stacks);
    }

    @Override
    public void getDebugMessages(LogicalSide side, IDebugMessages messages) {
        DebuggableHelper.getDebugMessagesFor(messages, this);
    }

    private ItemStackHolder(NonNullList<ItemStack> stacks, BiPredicate<Integer, ItemStack> stackValidator) {
        super(stackValidator);
        this._stacks = stacks;
        this.setMaxCapacity(this::getSlotMaxCapacityFromStack);
    }

    protected void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this._stacks.size()) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this._stacks.size() + ")");
        }
    }

    protected int getStackLimit(int slot, ItemStack stack) {
        return Math.min(this.getSlotLimit(slot), stack.getMaxStackSize());
    }

    private int getSlotMaxCapacityFromStack(int slot) {
        return this.getStackAt(slot).getMaxStackSize();
    }
}

