/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.item.inventory.container.data;

import com.google.common.base.Preconditions;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.data.stack.IStackHolderAccess;
import it.zerono.mods.zerocore.lib.fluid.FluidStackHolder;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.AbstractData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.IBindableData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.IContainerData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.Sampler;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.sync.AmountChangedEntry;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.sync.ISyncedSetEntry;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidStackData
extends AbstractData<FluidStack>
implements IContainerData {
    private FluidStack _lastValue;
    private IBindableData<Integer> _amountData;

    public static FluidStackData immutable(ModContainer container, FluidStack value) {
        return FluidStackData.of(container, () -> value, CodeHelper.emptyConsumer());
    }

    public static FluidStackData empty(ModContainer container) {
        return FluidStackData.immutable(container, FluidStack.EMPTY);
    }

    public static FluidStackData sampled(int frequency, ModContainer container, Supplier<@NotNull FluidStack> getter, Consumer<@NotNull FluidStack> clientSideSetter) {
        return FluidStackData.of(container, new Sampler<FluidStack>(frequency, getter), clientSideSetter);
    }

    public static FluidStackData sampled(int frequency, ModContainer container, Supplier<@NotNull FluidStack> getter) {
        return FluidStackData.of(container, new Sampler<FluidStack>(frequency, getter), CodeHelper.emptyConsumer());
    }

    public static FluidStackData of(ModContainer container, Supplier<@NotNull FluidStack> getter, Consumer<@NotNull FluidStack> clientSideSetter) {
        Preconditions.checkNotNull((Object)((Object)container), (Object)"Container must not be null.");
        FluidStackData data = container.isClientSide() ? new FluidStackData(getter, clientSideSetter) : new FluidStackData(getter);
        container.addBindableData(data);
        return data;
    }

    public static FluidStackData of(ModContainer container, NonNullList<FluidStack> list, int index) {
        Preconditions.checkNotNull(list, (Object)"List must not be null.");
        Preconditions.checkArgument((index >= 0 && index < list.size() ? 1 : 0) != 0, (Object)"Index must be a valid index for the list.");
        return FluidStackData.of(container, () -> (FluidStack)list.get(index), v -> list.set(index, v));
    }

    public static FluidStackData of(ModContainer container, IStackHolderAccess<FluidStackHolder, FluidStack> holder, int index) {
        Preconditions.checkNotNull(holder, (Object)"Holder must not be null.");
        return FluidStackData.of(container, () -> (FluidStack)holder.getStackAt(index), v -> holder.setStackAt(index, (FluidStack)v));
    }

    public static FluidStackData of(ModContainer container, Supplier<@NotNull FluidStack> getter) {
        return FluidStackData.of(container, getter, CodeHelper.emptyConsumer());
    }

    public IBindableData<Integer> amount() {
        if (null == this._amountData) {
            this._amountData = AbstractData.as(0, intConsumer -> this.bind(stack -> intConsumer.accept(stack.getAmount())));
        }
        return this._amountData;
    }

    @Override
    @Nullable
    public ISyncedSetEntry getChangedValue() {
        FluidStack current = (FluidStack)this.getValue();
        if (this._lastValue.isEmpty() && current.isEmpty()) {
            return null;
        }
        boolean equalFluid = FluidStack.isSameFluidSameComponents((FluidStack)current, (FluidStack)this._lastValue);
        if (!equalFluid || current.getAmount() != this._lastValue.getAmount()) {
            this._lastValue = current.copy();
            if (equalFluid) {
                return new AmountChangedEntry(this._lastValue.getAmount());
            }
            return new FluidStackEntry(this._lastValue);
        }
        return null;
    }

    @Override
    public ISyncedSetEntry getValueFrom(RegistryFriendlyByteBuf buffer) {
        return AmountChangedEntry.from(buffer, FluidStackEntry::from);
    }

    @Override
    public void updateFrom(ISyncedSetEntry entry) {
        if (entry instanceof FluidStackEntry) {
            FluidStackEntry record = (FluidStackEntry)entry;
            this.setClientSideValue(record.value);
            this.notify(record.value);
        } else if (entry instanceof AmountChangedEntry) {
            AmountChangedEntry record = (AmountChangedEntry)entry;
            this.setClientSideValue(((FluidStack)this.getValue()).copyWithAmount(record.amount()));
        }
    }

    @Override
    public FluidStack defaultValue() {
        return FluidStack.EMPTY;
    }

    private FluidStackData(Supplier<FluidStack> getter, Consumer<FluidStack> clientSideSetter) {
        super(getter, clientSideSetter);
    }

    private FluidStackData(Supplier<FluidStack> getter) {
        super(getter);
        this._lastValue = FluidStack.EMPTY;
    }

    private record FluidStackEntry(FluidStack value) implements ISyncedSetEntry
    {
        private static FluidStackEntry from(RegistryFriendlyByteBuf buffer) {
            return new FluidStackEntry((FluidStack)FluidStack.OPTIONAL_STREAM_CODEC.decode((Object)buffer));
        }

        @Override
        public void accept(@NotNull RegistryFriendlyByteBuf buffer) {
            buffer.writeByte(1);
            FluidStack.OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)this.value);
        }
    }
}

