/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.world;

import it.zerono.mods.zerocore.lib.CodeHelper;
import java.util.stream.LongStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;

public class NeighboringPositions {
    private final Direction[] _directions;
    private final BlockPos.MutableBlockPos[] _neighbors;
    private final long[] _neighborHashes;

    public NeighboringPositions() {
        this(0, 0, 0, CodeHelper.DIRECTIONS);
    }

    public NeighboringPositions(Direction[] directions) {
        this(0, 0, 0, directions);
    }

    public NeighboringPositions(BlockPos position) {
        this(position.getX(), position.getY(), position.getZ(), CodeHelper.DIRECTIONS);
    }

    public NeighboringPositions(BlockPos position, Direction[] directions) {
        this(position.getX(), position.getY(), position.getZ(), directions);
    }

    public NeighboringPositions(int x, int y, int z) {
        this(x, y, z, CodeHelper.DIRECTIONS);
    }

    public NeighboringPositions(int x, int y, int z, Direction[] directions) {
        int length = directions.length;
        this._directions = directions;
        this._neighbors = new BlockPos.MutableBlockPos[length];
        this._neighborHashes = new long[length];
        for (int i = 0; i < length; ++i) {
            BlockPos.MutableBlockPos position;
            this._neighbors[i] = position = new BlockPos.MutableBlockPos(x, y, z).move(this._directions[i]);
            this._neighborHashes[i] = position.asLong();
        }
    }

    public void setTo(BlockPos position) {
        this.setTo(position.getX(), position.getY(), position.getZ());
    }

    public void setTo(int x, int y, int z) {
        for (int i = 0; i < this._neighbors.length; ++i) {
            BlockPos.MutableBlockPos position = this._neighbors[i].set(x, y, z).move(this._directions[i], 1);
            this._neighborHashes[i] = position.asLong();
        }
    }

    public int size() {
        return this._neighbors.length;
    }

    public BlockPos get(int index) {
        return this._neighbors[index];
    }

    public long getHash(int index) {
        return this._neighborHashes[index];
    }

    public LongStream getHashStream() {
        return LongStream.of(this._neighborHashes);
    }
}

