/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.block.EndPortalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import thedarkcolour.exdeorum.tag.EItemTags;

public class EndCakeBlock
extends CakeBlock {
    public EndCakeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)BITES, (Comparable)Integer.valueOf(6)));
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.is(EItemTags.END_CAKE_MATERIAL)) {
            int bites = (Integer)state.getValue((Property)BITES);
            if (bites == 0) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            if (!level.isClientSide) {
                if (!player.getAbilities().instabuild) {
                    stack.shrink(1);
                }
                level.setBlock(pos, (BlockState)state.setValue((Property)BITES, (Comparable)Integer.valueOf(bites - 1)), 3);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (!player.isShiftKeyDown()) {
            int bites = (Integer)state.getValue((Property)BITES);
            if (!level.isClientSide && EndCakeBlock.tryTeleport((ServerLevel)level, player)) {
                player.awardStat(Stats.EAT_CAKE_SLICE);
                player.getFoodData().eat(2, 0.1f);
                level.gameEvent((Entity)player, (Holder)GameEvent.EAT, pos);
                if (bites < 6) {
                    level.setBlock(pos, (BlockState)state.setValue((Property)BITES, (Comparable)Integer.valueOf(bites + 1)), 3);
                } else {
                    level.removeBlock(pos, false);
                    level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_DESTROY, pos);
                }
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }

    private static boolean tryTeleport(ServerLevel level, Player player) {
        ServerLevel endLevel;
        if (level.dimension() != Level.END && (endLevel = level.getServer().getLevel(Level.END)) != null && player.canChangeDimensions((Level)level, (Level)endLevel)) {
            player.changeDimension(((EndPortalBlock)Blocks.END_PORTAL).getPortalDestination(level, (Entity)player, player.getOnPos()));
            return true;
        }
        return false;
    }
}

