/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.compat;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.fml.ModList;
import thedarkcolour.exdeorum.material.AbstractMaterial;
import thedarkcolour.exdeorum.material.DefaultMaterials;
import thedarkcolour.exdeorum.material.MaterialRegistry;
import thedarkcolour.exdeorum.recipe.RecipeUtil;
import thedarkcolour.exdeorum.registry.EItems;

public class CompatUtil {
    public static List<ItemLike> getAvailableBarrels(boolean registered) {
        return CompatUtil.getAvailableMaterials(DefaultMaterials.BARRELS, registered);
    }

    public static List<ItemLike> getAvailableSieves(boolean registered, boolean includeMechanical) {
        List<ItemLike> sieves = CompatUtil.getAvailableMaterials(DefaultMaterials.SIEVES, registered);
        if (includeMechanical) {
            sieves.add((ItemLike)EItems.MECHANICAL_SIEVE.get());
        }
        return sieves;
    }

    public static List<ItemLike> getAvailableLavaCrucibles(boolean registered) {
        return CompatUtil.getAvailableMaterials(DefaultMaterials.LAVA_CRUCIBLES, registered);
    }

    public static List<ItemLike> getAvailableWaterCrucibles(boolean registered) {
        return CompatUtil.getAvailableMaterials(DefaultMaterials.WATER_CRUCIBLES, registered);
    }

    public static List<ItemLike> getAvailableCompressedSieves(boolean registered) {
        return CompatUtil.getAvailableMaterials(DefaultMaterials.COMPRESSED_SIEVES, registered);
    }

    private static List<ItemLike> getAvailableMaterials(MaterialRegistry<?> registry, boolean registered) {
        ArrayList<ItemLike> materials = new ArrayList<ItemLike>();
        for (AbstractMaterial material : registry) {
            if (registered != ModList.get().isLoaded(material.requiredModId)) continue;
            materials.add(material);
        }
        return materials;
    }

    public static <C extends RecipeInput, R extends Recipe<C>, T> List<T> collectAllRecipes(RecipeType<R> recipeType, Function<R, T> mapper) {
        Collection byType = RecipeUtil.getRecipeManager().byType(recipeType);
        ObjectArrayList recipes = new ObjectArrayList(byType.size());
        for (RecipeHolder value : byType) {
            recipes.add(mapper.apply(value.value()));
        }
        return recipes;
    }

    public static void addEnchantmentsTooltip(ItemStack mesh, Level level, Consumer<Component> aggregator) {
        ItemEnchantments enchantments = (ItemEnchantments)mesh.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        if (!enchantments.isEmpty()) {
            enchantments.addToTooltip(Item.TooltipContext.of((Level)level), aggregator, (TooltipFlag)TooltipFlag.NORMAL);
        }
    }
}

