/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.compat.jei;

import com.google.common.collect.ImmutableList;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.exdeorum.compat.XeiUtil;
import thedarkcolour.exdeorum.recipe.BlockPredicate;
import thedarkcolour.exdeorum.recipe.crook.CrookRecipe;

public abstract sealed class CrookJeiRecipe {
    public final List<BlockState> states;
    public ItemStack result;
    public float chance;

    public CrookJeiRecipe(List<BlockState> states, ItemStack result, float chance) {
        this.states = states;
        this.result = result;
        this.chance = chance;
    }

    public abstract void addIngredients(IRecipeLayoutBuilder var1);

    static CrookJeiRecipe create(CrookRecipe recipe) {
        BlockPredicate blockPredicate = recipe.blockPredicate();
        Objects.requireNonNull(blockPredicate);
        BlockPredicate blockPredicate2 = blockPredicate;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BlockPredicate.BlockStatePredicate.class, BlockPredicate.SingleBlockPredicate.class, BlockPredicate.TagPredicate.class}, (Object)blockPredicate2, n)) {
            case 0: {
                BlockPredicate.BlockStatePredicate state = (BlockPredicate.BlockStatePredicate)blockPredicate2;
                return new StatesRecipe(state, state.possibleStates().filter(blockState -> !blockState.hasProperty((Property)BlockStateProperties.WATERLOGGED) || (Boolean)blockState.getValue((Property)BlockStateProperties.WATERLOGGED) == false).toList(), recipe.result(), recipe.chance());
            }
            case 1: {
                BlockPredicate.SingleBlockPredicate block = (BlockPredicate.SingleBlockPredicate)blockPredicate2;
                return new BlockRecipe(block.block(), recipe.result(), recipe.chance());
            }
            case 2: {
                BlockPredicate.TagPredicate tag = (BlockPredicate.TagPredicate)blockPredicate2;
                ArrayList<BlockState> list = new ArrayList<BlockState>();
                for (Holder holder : BuiltInRegistries.BLOCK.getTagOrEmpty(tag.tag())) {
                    if (!holder.isBound()) continue;
                    list.add(((Block)holder.value()).defaultBlockState());
                }
                return new TagRecipe(tag.tag(), List.copyOf(list), recipe.result(), recipe.chance());
            }
        }
        throw new IllegalArgumentException("Invalid crook recipe??  ->  " + String.valueOf(recipe));
    }

    static sealed class StatesRecipe
    extends CrookJeiRecipe
    permits TagRecipe {
        private final List<ItemStack> itemIngredients;
        public final List<Component> requirements;

        StatesRecipe(@Nullable BlockPredicate.BlockStatePredicate predicate, List<BlockState> states, ItemStack result, float chance) {
            super(states, result, chance);
            ImmutableList.Builder itemIngredients = ImmutableList.builder();
            HashSet<Block> blocks = new HashSet<Block>();
            for (BlockState state : this.states) {
                Item item;
                Block block = state.getBlock();
                if (!blocks.add(block) || (item = block.asItem()) == Items.AIR) continue;
                itemIngredients.add((Object)new ItemStack((ItemLike)item));
            }
            this.itemIngredients = itemIngredients.build();
            this.requirements = XeiUtil.getStateRequirements(predicate);
        }

        @Override
        public void addIngredients(IRecipeLayoutBuilder builder) {
            if (!this.itemIngredients.isEmpty()) {
                builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).addItemStacks(this.itemIngredients);
            }
        }
    }

    static final class BlockRecipe
    extends CrookJeiRecipe {
        private final ItemStack itemIngredient;

        BlockRecipe(Block block, ItemStack result, float chance) {
            super((List<BlockState>)ImmutableList.of((Object)block.defaultBlockState()), result, chance);
            Item item = block.asItem();
            this.itemIngredient = item == Items.AIR ? ItemStack.EMPTY : new ItemStack((ItemLike)item);
        }

        @Override
        public void addIngredients(IRecipeLayoutBuilder builder) {
            if (!this.itemIngredient.isEmpty()) {
                builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).addItemStack(this.itemIngredient);
            }
        }
    }

    static final class TagRecipe
    extends StatesRecipe {
        public final TagKey<Block> tag;

        public TagRecipe(TagKey<Block> tag, List<BlockState> states, ItemStack result, float chance) {
            super(null, states, result, chance);
            this.tag = tag;
        }
    }
}

