/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.compat.jei;

import java.util.function.Supplier;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import thedarkcolour.exdeorum.compat.jei.OneToOneCategory;
import thedarkcolour.exdeorum.compat.jei.SieveCategory;
import thedarkcolour.exdeorum.recipe.hammer.HammerRecipe;

class HammerCategory
extends OneToOneCategory<HammerRecipe> {
    private final RecipeType<HammerRecipe> recipeType;

    public HammerCategory(IGuiHelper helper, IDrawable arrow, Supplier<? extends Item> icon, Component title, RecipeType<HammerRecipe> recipeType) {
        super(helper, arrow, helper.createDrawableItemStack(new ItemStack((ItemLike)icon.get())), title);
        this.recipeType = recipeType;
    }

    public RecipeType<HammerRecipe> getRecipeType() {
        return this.recipeType;
    }

    @Override
    protected void addInput(IRecipeSlotBuilder slot, HammerRecipe recipe) {
        slot.addIngredients(recipe.ingredient());
    }

    @Override
    protected void addOutput(IRecipeSlotBuilder slot, HammerRecipe recipe) {
        NumberProvider numberProvider = recipe.resultAmount;
        if (numberProvider instanceof ConstantValue) {
            ConstantValue constant = (ConstantValue)numberProvider;
            slot.addItemStack(recipe.result.getCount() == 1 ? recipe.result : recipe.result.copyWithCount((int)constant.value()));
        } else {
            slot.addItemStack(recipe.result);
            SieveCategory.addTooltips(slot, false, recipe.resultAmount);
        }
    }
}

