/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.item;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import thedarkcolour.exdeorum.registry.EItems;

public class RandomResultItem
extends Item {
    private final TagKey<Item> possibilities;

    public RandomResultItem(Item.Properties properties, TagKey<Item> possibilities) {
        super(properties);
        this.possibilities = possibilities;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide) {
            ArrayList<Item> possibleResults = new ArrayList<Item>();
            for (Holder holder : BuiltInRegistries.ITEM.getTagOrEmpty(this.possibilities)) {
                possibleResults.add((Item)holder.value());
            }
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
            }
            ItemStack newItem = new ItemStack((ItemLike)Util.getRandom(possibleResults, (RandomSource)level.random));
            player.getInventory().placeItemBackInInventory(newItem);
            return InteractionResultHolder.consume((Object)(stack.isEmpty() ? player.getItemInHand(hand) : stack));
        }
        return InteractionResultHolder.success((Object)stack);
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pLevel, List<Component> tooltip, TooltipFlag pIsAdvanced) {
        if (this == EItems.RANDOM_ARMOR_TRIM.value()) {
            tooltip.add((Component)Component.translatable((String)"item.exdeorum.random_armor_trim.no_upgrade").withStyle(ChatFormatting.DARK_GRAY));
        }
    }
}

