/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.item;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.fluids.capability.templates.FluidHandlerItemStack;
import thedarkcolour.exdeorum.blockentity.BarrelBlockEntity;
import thedarkcolour.exdeorum.item.WideWateringCanItem;
import thedarkcolour.exdeorum.registry.EDataComponents;
import thedarkcolour.exdeorum.registry.ESounds;
import thedarkcolour.exdeorum.tag.EBlockTags;

public class WateringCanItem
extends Item {
    private static final int WATERING_INTERVAL = 4;
    private static final int STARTUP_TIME = 10;
    private static boolean isWatering = false;
    private final int capacity;
    private final boolean renewing;
    private final boolean usableInMachines;

    public WateringCanItem(int capacity, Item.Properties properties) {
        super(properties);
        this.capacity = capacity;
        this.renewing = capacity >= 4000;
        this.usableInMachines = false;
    }

    protected WateringCanItem(boolean usableInMachines, Item.Properties properties) {
        super(properties);
        this.capacity = 4000;
        this.renewing = true;
        this.usableInMachines = usableInMachines;
    }

    public static ItemStack getFull(Supplier<? extends Item> wateringCan) {
        ItemStack stack = new ItemStack((ItemLike)wateringCan.get());
        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM);
        if (fluidHandler != null) {
            fluidHandler.fill(new FluidStack((Fluid)Fluids.WATER, Integer.MAX_VALUE), IFluidHandler.FluidAction.EXECUTE);
        }
        return stack;
    }

    public boolean isBarVisible(ItemStack stack) {
        if (this.renewing) {
            IFluidHandlerItem fluidHandler = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM);
            return fluidHandler == null || fluidHandler.getFluidInTank(0).getAmount() < this.capacity;
        }
        return true;
    }

    public int getBarColor(ItemStack pStack) {
        return 4159204;
    }

    public int getBarWidth(ItemStack stack) {
        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM);
        if (fluidHandler != null) {
            return Math.round((float)fluidHandler.getFluidInTank(0).getAmount() * 13.0f / (float)this.capacity);
        }
        return 0;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.NONE;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag pIsAdvanced) {
        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM);
        if (fluidHandler != null) {
            tooltip.add((Component)Component.translatable((String)"block.minecraft.water").append((Component)Component.translatable((String)"item.exdeorum.watering_can_fluid_display", (Object[])new Object[]{fluidHandler.getFluidInTank(0).getAmount(), this.capacity})).withStyle(ChatFormatting.GRAY));
        }
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemInHand = player.getItemInHand(hand);
        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)itemInHand.getCapability(Capabilities.FluidHandler.ITEM);
        if (fluidHandler != null) {
            Block block;
            BlockPos pos;
            BlockState state;
            BlockHitResult hitResult;
            if (fluidHandler.getFluidInTank(0).getAmount() < this.capacity && (hitResult = WateringCanItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY)).getType() == HitResult.Type.BLOCK && (state = level.getBlockState(pos = hitResult.getBlockPos())).getFluidState().getType() == Fluids.WATER && (block = state.getBlock()) instanceof BucketPickup) {
                BucketPickup pickup = (BucketPickup)block;
                if (!level.isClientSide) {
                    fluidHandler.fill(new FluidStack((Fluid)Fluids.WATER, 1000), IFluidHandler.FluidAction.EXECUTE);
                    pickup.pickupBlock(player, (LevelAccessor)level, pos, state);
                    pickup.getPickupSound(state).ifPresent(sound -> player.playSound(sound, 1.0f, 1.0f));
                }
                return InteractionResultHolder.sidedSuccess((Object)itemInHand, (boolean)level.isClientSide);
            }
            if (!fluidHandler.getFluidInTank(0).isEmpty()) {
                boolean realPlayer;
                boolean bl = realPlayer = !(player instanceof FakePlayer);
                if (realPlayer) {
                    player.startUsingItem(hand);
                } else if (this.usableInMachines) {
                    this.onUseTick(level, (LivingEntity)player, itemInHand, 72000);
                }
                return InteractionResultHolder.consume((Object)itemInHand);
            }
        }
        return InteractionResultHolder.pass((Object)itemInHand);
    }

    public void onUseTick(Level level, LivingEntity living, ItemStack stack, int remainingTicks) {
        block6: {
            block7: {
                block8: {
                    block9: {
                        BlockState state;
                        BlockPos pos;
                        int useTicks;
                        block10: {
                            IFluidHandlerItem fluidHandler;
                            block11: {
                                BlockHitResult blockHit;
                                useTicks = 72000 - remainingTicks;
                                if (useTicks < 10 && !(living instanceof FakePlayer) || (fluidHandler = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM)) == null) break block6;
                                if (fluidHandler.getFluidInTank(0).isEmpty()) break block7;
                                double reachDist = living.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE);
                                HitResult hit = living.pick(reachDist, 0.0f, true);
                                if (!(hit instanceof BlockHitResult) || (blockHit = (BlockHitResult)hit).getType() != HitResult.Type.BLOCK) break block8;
                                pos = blockHit.getBlockPos();
                                state = level.getBlockState(pos);
                                if (level.isClientSide) break block9;
                                if (useTicks % 4 != 0) break block10;
                                this.tryWatering((ServerLevel)level, pos, state);
                                if (this.renewing && fluidHandler.getFluidInTank(0).getAmount() == this.capacity) break block10;
                                if (!(living instanceof Player)) break block11;
                                Player player = (Player)living;
                                if (player.getAbilities().instabuild) break block10;
                            }
                            ((FluidHandler)fluidHandler).drain();
                        }
                        if (useTicks % 2 == 0) {
                            this.waterParticles(level, pos, state);
                        }
                        if ((useTicks - 10) % 20 == 0) {
                            level.playSound(null, pos, (SoundEvent)ESounds.WATERING_CAN_USE.get(), living.getSoundSource(), ((Object)((Object)this)).getClass() == WideWateringCanItem.class ? 0.6f : 0.3f, 1.5f);
                        }
                        break block6;
                    }
                    isWatering = true;
                    break block6;
                }
                isWatering = false;
                break block6;
            }
            living.stopUsingItem();
            isWatering = false;
        }
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity living, int timeCharged) {
        if (timeCharged > 10) {
            level.playLocalSound(living.getX(), living.getY(), living.getZ(), (SoundEvent)ESounds.WATERING_CAN_STOP.get(), living.getSoundSource(), 0.6f, 0.7f, false);
        }
    }

    protected void tryWatering(ServerLevel level, BlockPos pos, BlockState state) {
        BlockPos below;
        BlockState belowState;
        if (state.is(EBlockTags.WATERING_CAN_TICKABLE)) {
            if (state.is(BlockTags.SAPLINGS)) {
                if (level.random.nextInt(3) == 0) {
                    state.randomTick(level, pos, level.random);
                    level.levelEvent(1505, pos, 0);
                }
            } else {
                Block block = state.getBlock();
                if (block instanceof SugarCaneBlock) {
                    SugarCaneBlock block2 = (SugarCaneBlock)block;
                    BlockPos.MutableBlockPos cursor = pos.mutable();
                    while (level.isInWorldBounds((BlockPos)cursor.move(0, 1, 0)) && level.getBlockState((BlockPos)cursor).getBlock() == block2) {
                    }
                    BlockState topState = level.getBlockState((BlockPos)cursor.move(0, -1, 0));
                    topState.randomTick(level, (BlockPos)cursor, level.random);
                } else {
                    state.randomTick(level, pos, level.random);
                }
            }
        } else if (BarrelBlockEntity.isHotFluid(state.getFluidState().getFluidType())) {
            level.levelEvent(1501, pos, 0);
        } else if (state.getBlock() == Blocks.FARMLAND) {
            WateringCanItem.hydrateFarmland(level, pos, state);
        }
        if ((belowState = level.getBlockState(below = pos.below())).getBlock() == Blocks.FARMLAND) {
            WateringCanItem.hydrateFarmland(level, below, belowState);
        }
    }

    private static void hydrateFarmland(ServerLevel level, BlockPos pos, BlockState state) {
        BlockPos randomPos = pos.offset(level.random.nextIntBetweenInclusive(-1, 1), 0, level.random.nextIntBetweenInclusive(-1, 1));
        if (randomPos != pos && (state = level.getBlockState(pos = randomPos)).getBlock() != Blocks.FARMLAND) {
            return;
        }
        if ((Integer)state.getValue((Property)FarmBlock.MOISTURE) < 7) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)FarmBlock.MOISTURE, (Comparable)Integer.valueOf(7)));
        }
    }

    protected void waterParticles(Level level, BlockPos pos, BlockState state) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            double x = (double)pos.getX() + 0.5 + level.random.nextGaussian() / 8.0;
            double y = pos.getY();
            double z = (double)pos.getZ() + 0.5 + level.random.nextGaussian() / 8.0;
            VoxelShape collisionShape = state.getCollisionShape((BlockGetter)level, pos);
            if (!collisionShape.isEmpty()) {
                y += collisionShape.max(Direction.Axis.Y);
            }
            for (int i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    if (!level.random.nextBoolean()) continue;
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.RAIN, x + (double)i * 0.33, y, z + (double)j * 0.33, 2, 0.0, 0.0, 0.0, 0.2);
                }
            }
        }
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(ClientExtensions.INSTANCE);
    }

    public static class FluidHandler
    extends FluidHandlerItemStack {
        public FluidHandler(ItemStack container) {
            super(EDataComponents.WATERING_CAN, container, FluidHandler.determineCapacityFromItem(container.getItem()));
        }

        private static int determineCapacityFromItem(Item item) {
            if (item instanceof WateringCanItem) {
                WateringCanItem wateringCan = (WateringCanItem)item;
                return wateringCan.capacity;
            }
            throw new IllegalArgumentException("Invalid watering can");
        }

        public boolean canFillFluidType(FluidStack fluid) {
            return fluid.getFluid() == Fluids.WATER;
        }

        public boolean canDrainFluidType(FluidStack fluid) {
            return false;
        }

        public void drain() {
            FluidStack contained = this.getFluid();
            int drainAmount = Math.min(contained.getAmount(), 1);
            FluidStack drained = contained.copy();
            drained.setAmount(drainAmount);
            contained.shrink(drainAmount);
            if (contained.isEmpty()) {
                this.setContainerToEmpty();
            } else {
                this.setFluid(contained);
            }
        }
    }

    private static enum ClientExtensions implements IClientItemExtensions
    {
        INSTANCE;


        public boolean applyForgeHandTransform(PoseStack poseStack, LocalPlayer player, HumanoidArm arm, ItemStack itemInHand, float partialTick, float equipProcess, float swingProcess) {
            if (player.isUsingItem()) {
                int useTicks = 71999 - player.getUseItemRemainingTicks();
                float step = (float)useTicks + partialTick;
                float startProgress = ClientExtensions.easeOutCubic(Math.min(step, 10.0f) / 10.0f);
                poseStack.translate(-0.2 * (double)startProgress, -0.2 * (double)startProgress, 0.0);
                if (startProgress == 1.0f && isWatering) {
                    float sin = Mth.sin((float)(0.35f * (step - 10.0f)));
                    poseStack.rotateAround(Axis.XP.rotationDegrees(10.0f * sin), 0.0f, 0.0f, -0.2f);
                }
                float rotate = Mth.lerp((float)startProgress, (float)0.0f, (float)((float)Math.PI / 180));
                poseStack.rotateAround(Axis.ZP.rotation(rotate * 15.0f), -0.75f, 0.0f, 0.0f);
                int i = arm == HumanoidArm.RIGHT ? 1 : -1;
                poseStack.translate((float)i * 0.56f, -0.52f + (player.isUsingItem() ? 0.0f : equipProcess) * -0.6f, -0.72f);
                return true;
            }
            return false;
        }

        private static float easeOutCubic(float progress) {
            float opposite = 1.0f - progress;
            return 1.0f - opposite * opposite * opposite;
        }
    }
}

