/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.loot;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.exdeorum.recipe.RecipeUtil;
import thedarkcolour.exdeorum.recipe.hammer.HammerRecipe;
import thedarkcolour.exdeorum.tag.EItemTags;

public class HammerLootModifier
extends LootModifier {
    public static final MapCodec<HammerLootModifier> CODEC = RecordCodecBuilder.mapCodec(inst -> LootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, HammerLootModifier::new));
    private final TagKey<Item> fortuneBlacklistTag;

    public HammerLootModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
        this.fortuneBlacklistTag = EItemTags.HAMMER_FORTUNE_BLACKLIST;
    }

    protected HammerLootModifier(LootItemCondition[] conditionsIn, TagKey<Item> fortuneBlacklistTag) {
        super(conditionsIn);
        this.fortuneBlacklistTag = fortuneBlacklistTag;
    }

    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        BlockState state = (BlockState)context.getParamOrNull(LootContextParams.BLOCK_STATE);
        if (state == null) {
            return generatedLoot;
        }
        Item itemForm = state.getBlock().asItem();
        if (itemForm == Items.AIR) {
            return generatedLoot;
        }
        HammerRecipe recipe = this.getRecipe(itemForm);
        if (recipe == null) {
            return generatedLoot;
        }
        ObjectArrayList newLoot = new ObjectArrayList();
        int resultAmount = recipe.resultAmount.getInt(context);
        if (!itemForm.builtInRegistryHolder().is(this.fortuneBlacklistTag) && context.hasParam(LootContextParams.TOOL)) {
            ItemStack hammer = (ItemStack)context.getParam(LootContextParams.TOOL);
            resultAmount += HammerLootModifier.calculateFortuneBonus(context.getLevel().registryAccess(), hammer, context.getRandom(), resultAmount == 0);
        }
        if (resultAmount > 0) {
            newLoot.add((Object)recipe.result.copyWithCount(resultAmount));
        }
        return newLoot;
    }

    @Nullable
    protected HammerRecipe getRecipe(Item itemForm) {
        return RecipeUtil.getHammerRecipe(itemForm);
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }

    public static int calculateFortuneBonus(RegistryAccess registryAccess, ItemStack hammer, RandomSource rand, boolean zeroBaseDrops) {
        int fortune = hammer.getEnchantmentLevel((Holder)registryAccess.lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.FORTUNE));
        if (fortune != 0) {
            float chance = rand.nextFloat();
            if (zeroBaseDrops ? chance < 0.06f * (float)fortune : chance < 0.03f * (float)fortune) {
                return 1;
            }
        }
        return 0;
    }
}

