/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.material;

import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;

public abstract class AbstractMaterial
implements ItemLike {
    public final SoundType soundType;
    public final float strength;
    public final boolean needsCorrectTool;
    public final int mapColor;
    public final String requiredModId;
    DeferredBlock<Block> block;
    DeferredItem<BlockItem> item;

    protected AbstractMaterial(SoundType soundType, float strength, boolean needsCorrectTool, int mapColor, String requiredModId) {
        this.soundType = soundType;
        this.strength = strength;
        this.needsCorrectTool = needsCorrectTool;
        this.mapColor = mapColor;
        this.requiredModId = requiredModId;
    }

    protected abstract Block createBlock();

    protected BlockBehaviour.Properties props() {
        BlockBehaviour.Properties properties = BlockBehaviour.Properties.of().strength(this.strength).sound(this.soundType);
        if (this.needsCorrectTool) {
            properties.requiresCorrectToolForDrops();
        }
        return properties;
    }

    public Item getItem() {
        return (Item)this.item.get();
    }

    public Block getBlock() {
        return (Block)this.block.get();
    }

    public Item asItem() {
        return (Item)this.item.get();
    }
}

