/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.material;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.exdeorum.block.BarrelBlock;
import thedarkcolour.exdeorum.material.AbstractMaterial;
import thedarkcolour.exdeorum.material.DefaultMaterials;
import thedarkcolour.exdeorum.material.MaterialParser;

public class BarrelMaterial
extends AbstractMaterial {
    public static final Set<Block> TRANSPARENT_BARRELS = new HashSet<Block>();
    public final boolean fireproof;
    public final boolean transparent;

    protected BarrelMaterial(SoundType soundType, float strength, boolean needsCorrectTool, boolean fireproof, int mapColor, String requiredModId, boolean transparent) {
        super(soundType, strength, needsCorrectTool, mapColor, requiredModId);
        this.fireproof = fireproof;
        this.transparent = transparent;
    }

    @Override
    protected Block createBlock() {
        BlockBehaviour.Properties props = this.props().noOcclusion();
        if (!this.fireproof) {
            props.ignitedByLava();
        }
        return new BarrelBlock(props);
    }

    @Nullable
    public static BarrelMaterial readFromJson(MaterialParser parser) {
        SoundType soundType = parser.getSoundType();
        float strength = parser.getStrength();
        int mapColor = parser.getMapColor();
        boolean needsCorrectTool = parser.getOptionalBoolean("needs_correct_tool");
        boolean fireproof = parser.getOptionalBoolean("fireproof");
        String requiredModId = parser.getRequiredModId();
        boolean transparent = parser.getOptionalBoolean("transparent");
        if (parser.error) {
            return null;
        }
        return new BarrelMaterial(soundType, strength, needsCorrectTool, fireproof, mapColor, requiredModId, transparent);
    }

    public static void loadTransparentBlocks() {
        for (BarrelMaterial material : DefaultMaterials.BARRELS) {
            if (!material.transparent) continue;
            TRANSPARENT_BARRELS.add(material.getBlock());
        }
    }
}

