/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.material;

import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.exdeorum.block.CompressedSieveBlock;
import thedarkcolour.exdeorum.material.MaterialParser;
import thedarkcolour.exdeorum.material.SieveMaterial;

public class CompressedSieveMaterial
extends SieveMaterial {
    protected CompressedSieveMaterial(SoundType soundType, float strength, boolean needsCorrectTool, String requiredModId) {
        super(soundType, strength, needsCorrectTool, requiredModId);
    }

    @Override
    protected Block createBlock() {
        return new CompressedSieveBlock(this.props().noOcclusion());
    }

    @Nullable
    public static CompressedSieveMaterial readFromJson(MaterialParser parser) {
        SoundType soundType = parser.getSoundType();
        float strength = parser.getStrength();
        boolean needsCorrectTool = parser.getOptionalBoolean("needs_correct_tool");
        String requiredModId = parser.getRequiredModId();
        if (parser.error) {
            return null;
        }
        return new CompressedSieveMaterial(soundType, strength, needsCorrectTool, requiredModId);
    }
}

