/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.exdeorum.material;

import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.material.MapColor;
import thedarkcolour.exdeorum.material.AbstractCrucibleMaterial;
import thedarkcolour.exdeorum.material.BarrelMaterial;
import thedarkcolour.exdeorum.material.CompressedSieveMaterial;
import thedarkcolour.exdeorum.material.LavaCrucibleMaterial;
import thedarkcolour.exdeorum.material.MaterialRegistry;
import thedarkcolour.exdeorum.material.SieveMaterial;
import thedarkcolour.exdeorum.material.WaterCrucibleMaterial;

public class DefaultMaterials {
    public static final MaterialRegistry<BarrelMaterial> BARRELS = new MaterialRegistry("barrel");
    public static final MaterialRegistry<SieveMaterial> SIEVES = new MaterialRegistry("sieve");
    public static final MaterialRegistry<CompressedSieveMaterial> COMPRESSED_SIEVES = new MaterialRegistry("compressed_sieve");
    public static final MaterialRegistry<AbstractCrucibleMaterial> LAVA_CRUCIBLES = new MaterialRegistry("lava_crucible", "crucible");
    public static final MaterialRegistry<AbstractCrucibleMaterial> WATER_CRUCIBLES = new MaterialRegistry("water_crucible", "crucible");
    public static final BarrelMaterial OAK_BARREL = DefaultMaterials.addDefaultWoodBarrel("oak", SoundType.WOOD, false, MapColor.WOOD, "exdeorum");
    public static final BarrelMaterial SPRUCE_BARREL = DefaultMaterials.addDefaultWoodBarrel("spruce", SoundType.WOOD, false, MapColor.PODZOL, "exdeorum");
    public static final BarrelMaterial BIRCH_BARREL = DefaultMaterials.addDefaultWoodBarrel("birch", SoundType.WOOD, false, MapColor.SAND, "exdeorum");
    public static final BarrelMaterial JUNGLE_BARREL = DefaultMaterials.addDefaultWoodBarrel("jungle", SoundType.WOOD, false, MapColor.DIRT, "exdeorum");
    public static final BarrelMaterial ACACIA_BARREL = DefaultMaterials.addDefaultWoodBarrel("acacia", SoundType.WOOD, false, MapColor.COLOR_ORANGE, "exdeorum");
    public static final BarrelMaterial DARK_OAK_BARREL = DefaultMaterials.addDefaultWoodBarrel("dark_oak", SoundType.WOOD, false, MapColor.COLOR_BROWN, "exdeorum");
    public static final BarrelMaterial MANGROVE_BARREL = DefaultMaterials.addDefaultWoodBarrel("mangrove", SoundType.WOOD, false, MapColor.COLOR_RED, "exdeorum");
    public static final BarrelMaterial CHERRY_BARREL = DefaultMaterials.addDefaultWoodBarrel("cherry", SoundType.CHERRY_WOOD, false, MapColor.TERRACOTTA_WHITE, "exdeorum");
    public static final BarrelMaterial BAMBOO_BARREL = DefaultMaterials.addDefaultWoodBarrel("bamboo", SoundType.BAMBOO_WOOD, false, MapColor.COLOR_YELLOW, "exdeorum");
    public static final BarrelMaterial CRIMSON_BARREL = DefaultMaterials.addDefaultWoodBarrel("crimson", SoundType.NETHER_WOOD, true, MapColor.CRIMSON_STEM, "exdeorum");
    public static final BarrelMaterial WARPED_BARREL = DefaultMaterials.addDefaultWoodBarrel("warped", SoundType.NETHER_WOOD, true, MapColor.WARPED_STEM, "exdeorum");
    public static final BarrelMaterial STONE_BARREL = DefaultMaterials.addDefaultBarrel("stone", SoundType.STONE, 4.0f, true, true, MapColor.STONE, "exdeorum", false);
    public static final BarrelMaterial FIR_BARREL = DefaultMaterials.addDefaultWoodBarrel("fir", SoundType.WOOD, false, MapColor.TERRACOTTA_WHITE, "biomesoplenty");
    public static final BarrelMaterial REDWOOD_BARREL = DefaultMaterials.addDefaultWoodBarrel("redwood", SoundType.WOOD, false, MapColor.TERRACOTTA_ORANGE, "biomesoplenty");
    public static final BarrelMaterial MAHOGANY_BARREL = DefaultMaterials.addDefaultWoodBarrel("mahogany", SoundType.WOOD, false, MapColor.TERRACOTTA_PINK, "biomesoplenty");
    public static final BarrelMaterial JACARANDA_BARREL = DefaultMaterials.addDefaultWoodBarrel("jacaranda", SoundType.WOOD, false, MapColor.QUARTZ, "biomesoplenty");
    public static final BarrelMaterial PALM_BARREL = DefaultMaterials.addDefaultWoodBarrel("palm", SoundType.WOOD, false, MapColor.TERRACOTTA_YELLOW, "biomesoplenty");
    public static final BarrelMaterial WILLOW_BARREL = DefaultMaterials.addDefaultWoodBarrel("willow", SoundType.WOOD, false, MapColor.TERRACOTTA_LIGHT_GREEN, "biomesoplenty");
    public static final BarrelMaterial DEAD_BARREL = DefaultMaterials.addDefaultWoodBarrel("dead", SoundType.WOOD, false, MapColor.STONE, "biomesoplenty");
    public static final BarrelMaterial MAGIC_BARREL = DefaultMaterials.addDefaultWoodBarrel("magic", SoundType.WOOD, false, MapColor.COLOR_BLUE, "biomesoplenty");
    public static final BarrelMaterial UMBRAN_BARREL = DefaultMaterials.addDefaultWoodBarrel("umbran", SoundType.WOOD, false, MapColor.TERRACOTTA_BLUE, "biomesoplenty");
    public static final BarrelMaterial HELLBARK_BARREL = DefaultMaterials.addDefaultWoodBarrel("hellbark", SoundType.WOOD, true, MapColor.TERRACOTTA_GRAY, "biomesoplenty");
    public static final BarrelMaterial ARCHWOOD_BARREL = DefaultMaterials.addDefaultWoodBarrel("archwood", SoundType.WOOD, false, MapColor.COLOR_GRAY, "ars_nouveau");
    public static final BarrelMaterial SKYROOT_BARREL = DefaultMaterials.addDefaultWoodBarrel("skyroot", SoundType.WOOD, false, MapColor.WOOD, "aether");
    public static final BarrelMaterial BLUEBRIGHT_BARREL = DefaultMaterials.addDefaultWoodBarrel("bluebright", SoundType.WOOD, false, MapColor.WOOD, "blue_skies");
    public static final BarrelMaterial STARLIT_BARREL = DefaultMaterials.addDefaultWoodBarrel("starlit", SoundType.WOOD, false, MapColor.WOOD, "blue_skies");
    public static final BarrelMaterial FROSTBRIGHT_BARREL = DefaultMaterials.addDefaultWoodBarrel("frostbright", SoundType.WOOD, false, MapColor.WOOD, "blue_skies");
    public static final BarrelMaterial COMET_BARREL = DefaultMaterials.addDefaultWoodBarrel("comet", SoundType.WOOD, false, MapColor.WOOD, "blue_skies");
    public static final BarrelMaterial LUNAR_BARREL = DefaultMaterials.addDefaultWoodBarrel("lunar", SoundType.WOOD, false, MapColor.WOOD, "blue_skies");
    public static final BarrelMaterial DUSK_BARREL = DefaultMaterials.addDefaultWoodBarrel("dusk", SoundType.WOOD, false, MapColor.WOOD, "blue_skies");
    public static final BarrelMaterial MAPLE_BARREL = DefaultMaterials.addDefaultWoodBarrel("maple", SoundType.WOOD, false, MapColor.WOOD, "blue_skies");
    public static final BarrelMaterial CRYSTALLIZED_BARREL = DefaultMaterials.addDefaultBarrel("crystallized", SoundType.GLASS, 4.0f, true, true, MapColor.TERRACOTTA_WHITE, "blue_skies", true);
    public static final SieveMaterial OAK_SIEVE = DefaultMaterials.addDefaultSieve("oak", SoundType.WOOD, "exdeorum");
    public static final SieveMaterial SPRUCE_SIEVE = DefaultMaterials.addDefaultSieve("spruce", SoundType.WOOD, "exdeorum");
    public static final SieveMaterial BIRCH_SIEVE = DefaultMaterials.addDefaultSieve("birch", SoundType.WOOD, "exdeorum");
    public static final SieveMaterial JUNGLE_SIEVE = DefaultMaterials.addDefaultSieve("jungle", SoundType.WOOD, "exdeorum");
    public static final SieveMaterial ACACIA_SIEVE = DefaultMaterials.addDefaultSieve("acacia", SoundType.WOOD, "exdeorum");
    public static final SieveMaterial DARK_OAK_SIEVE = DefaultMaterials.addDefaultSieve("dark_oak", SoundType.WOOD, "exdeorum");
    public static final SieveMaterial MANGROVE_SIEVE = DefaultMaterials.addDefaultSieve("mangrove", SoundType.WOOD, "exdeorum");
    public static final SieveMaterial CHERRY_SIEVE = DefaultMaterials.addDefaultSieve("cherry", SoundType.CHERRY_WOOD, "exdeorum");
    public static final SieveMaterial BAMBOO_SIEVE = DefaultMaterials.addDefaultSieve("bamboo", SoundType.BAMBOO_WOOD, "exdeorum");
    public static final SieveMaterial CRIMSON_SIEVE = DefaultMaterials.addDefaultSieve("crimson", SoundType.NETHER_WOOD, "exdeorum");
    public static final SieveMaterial WARPED_SIEVE = DefaultMaterials.addDefaultSieve("warped", SoundType.NETHER_WOOD, "exdeorum");
    public static final SieveMaterial FIR_SIEVE = DefaultMaterials.addDefaultSieve("fir", SoundType.WOOD, "biomesoplenty");
    public static final SieveMaterial REDWOOD_SIEVE = DefaultMaterials.addDefaultSieve("redwood", SoundType.WOOD, "biomesoplenty");
    public static final SieveMaterial MAHOGANY_SIEVE = DefaultMaterials.addDefaultSieve("mahogany", SoundType.WOOD, "biomesoplenty");
    public static final SieveMaterial JACARANDA_SIEVE = DefaultMaterials.addDefaultSieve("jacaranda", SoundType.WOOD, "biomesoplenty");
    public static final SieveMaterial PALM_SIEVE = DefaultMaterials.addDefaultSieve("palm", SoundType.WOOD, "biomesoplenty");
    public static final SieveMaterial WILLOW_SIEVE = DefaultMaterials.addDefaultSieve("willow", SoundType.WOOD, "biomesoplenty");
    public static final SieveMaterial DEAD_SIEVE = DefaultMaterials.addDefaultSieve("dead", SoundType.WOOD, "biomesoplenty");
    public static final SieveMaterial MAGIC_SIEVE = DefaultMaterials.addDefaultSieve("magic", SoundType.WOOD, "biomesoplenty");
    public static final SieveMaterial UMBRAN_SIEVE = DefaultMaterials.addDefaultSieve("umbran", SoundType.WOOD, "biomesoplenty");
    public static final SieveMaterial HELLBARK_SIEVE = DefaultMaterials.addDefaultSieve("hellbark", SoundType.WOOD, "biomesoplenty");
    public static final SieveMaterial ARCHWOOD_SIEVE = DefaultMaterials.addDefaultSieve("archwood", SoundType.WOOD, "ars_nouveau");
    public static final SieveMaterial SKYROOT_SIEVE = DefaultMaterials.addDefaultSieve("skyroot", SoundType.WOOD, "aether");
    public static final SieveMaterial BLUEBRIGHT_SIEVE = DefaultMaterials.addDefaultSieve("bluebright", SoundType.WOOD, "blue_skies");
    public static final SieveMaterial STARLIT_SIEVE = DefaultMaterials.addDefaultSieve("starlit", SoundType.WOOD, "blue_skies");
    public static final SieveMaterial FROSTBRIGHT_SIEVE = DefaultMaterials.addDefaultSieve("frostbright", SoundType.WOOD, "blue_skies");
    public static final SieveMaterial COMET_SIEVE = DefaultMaterials.addDefaultSieve("comet", SoundType.WOOD, "blue_skies");
    public static final SieveMaterial LUNAR_SIEVE = DefaultMaterials.addDefaultSieve("lunar", SoundType.WOOD, "blue_skies");
    public static final SieveMaterial DUSK_SIEVE = DefaultMaterials.addDefaultSieve("dusk", SoundType.WOOD, "blue_skies");
    public static final SieveMaterial MAPLE_SIEVE = DefaultMaterials.addDefaultSieve("maple", SoundType.WOOD, "blue_skies");
    public static final SieveMaterial CRYSTALLIZED_SIEVE = DefaultMaterials.addDefaultSieve("crystallized", SoundType.GLASS, true, "blue_skies");
    public static final CompressedSieveMaterial OAK_COMPRESSED_SIEVE = DefaultMaterials.addDefaultCompressedSieve("oak", SoundType.WOOD, "exdeorum");
    public static final CompressedSieveMaterial SPRUCE_COMPRESSED_SIEVE = DefaultMaterials.addDefaultCompressedSieve("spruce", SoundType.WOOD, "exdeorum");
    public static final CompressedSieveMaterial BIRCH_COMPRESSED_SIEVE = DefaultMaterials.addDefaultCompressedSieve("birch", SoundType.WOOD, "exdeorum");
    public static final CompressedSieveMaterial JUNGLE_COMPRESSED_SIEVE = DefaultMaterials.addDefaultCompressedSieve("jungle", SoundType.WOOD, "exdeorum");
    public static final CompressedSieveMaterial ACACIA_COMPRESSED_SIEVE = DefaultMaterials.addDefaultCompressedSieve("acacia", SoundType.WOOD, "exdeorum");
    public static final CompressedSieveMaterial DARK_OAK_COMPRESSED_SIEVE = DefaultMaterials.addDefaultCompressedSieve("dark_oak", SoundType.WOOD, "exdeorum");
    public static final CompressedSieveMaterial MANGROVE_COMPRESSED_SIEVE = DefaultMaterials.addDefaultCompressedSieve("mangrove", SoundType.WOOD, "exdeorum");
    public static final CompressedSieveMaterial CHERRY_COMPRESSED_SIEVE = DefaultMaterials.addDefaultCompressedSieve("cherry", SoundType.CHERRY_WOOD, "exdeorum");
    public static final CompressedSieveMaterial BAMBOO_COMPRESSED_SIEVE = DefaultMaterials.addDefaultCompressedSieve("bamboo", SoundType.BAMBOO_WOOD, "exdeorum");
    public static final CompressedSieveMaterial WARPED_COMPRESSED_SIEVE = DefaultMaterials.addDefaultCompressedSieve("warped", SoundType.NETHER_WOOD, "exdeorum");
    public static final CompressedSieveMaterial CRIMSON_COMPRESSED_SIEVE = DefaultMaterials.addDefaultCompressedSieve("crimson", SoundType.NETHER_WOOD, "exdeorum");
    public static final CompressedSieveMaterial FIR_COMPRESSED_SIEVE = DefaultMaterials.addDefaultCompressedSieve("fir", SoundType.WOOD, "biomesoplenty");
    public static final CompressedSieveMaterial REDWOOD_COMPRESSED_SIEVE = DefaultMaterials.addDefaultCompressedSieve("redwood", SoundType.WOOD, "biomesoplenty");
    public static final CompressedSieveMaterial MAHOGANY_COMPRESSED_SIEVE = DefaultMaterials.addDefaultCompressedSieve("mahogany", SoundType.WOOD, "biomesoplenty");
    public static final CompressedSieveMaterial JACARANDA_COMPRESSED_SIEVE = DefaultMaterials.addDefaultCompressedSieve("jacaranda", SoundType.WOOD, "biomesoplenty");
    public static final CompressedSieveMaterial PALM_COMPRESSED_SIEVE = DefaultMaterials.addDefaultCompressedSieve("palm", SoundType.WOOD, "biomesoplenty");
    public static final CompressedSieveMaterial WILLOW_COMPRESSED_SIEVE = DefaultMaterials.addDefaultCompressedSieve("willow", SoundType.WOOD, "biomesoplenty");
    public static final CompressedSieveMaterial DEAD_COMPRESSED_SIEVE = DefaultMaterials.addDefaultCompressedSieve("dead", SoundType.WOOD, "biomesoplenty");
    public static final CompressedSieveMaterial MAGIC_COMPRESSED_SIEVE = DefaultMaterials.addDefaultCompressedSieve("magic", SoundType.WOOD, "biomesoplenty");
    public static final CompressedSieveMaterial UMBRAN_COMPRESSED_SIEVE = DefaultMaterials.addDefaultCompressedSieve("umbran", SoundType.WOOD, "biomesoplenty");
    public static final CompressedSieveMaterial HELLBARK_COMPRESSED_SIEVE = DefaultMaterials.addDefaultCompressedSieve("hellbark", SoundType.WOOD, "biomesoplenty");
    public static final CompressedSieveMaterial CASCADING_ARCHWOOD_COMPRESSED_SIEVE = DefaultMaterials.addDefaultCompressedSieve("blue_archwood", SoundType.WOOD, "ars_nouveau");
    public static final CompressedSieveMaterial BLAZING_ARCHWOOD_COMPRESSED_SIEVE = DefaultMaterials.addDefaultCompressedSieve("red_archwood", SoundType.WOOD, "ars_nouveau");
    public static final CompressedSieveMaterial VEXING_ARCHWOOD_COMPRESSED_SIEVE = DefaultMaterials.addDefaultCompressedSieve("purple_archwood", SoundType.WOOD, "ars_nouveau");
    public static final CompressedSieveMaterial FLOURISHING_ARCHWOOD_COMPRESSED_SIEVE = DefaultMaterials.addDefaultCompressedSieve("green_archwood", SoundType.WOOD, "ars_nouveau");
    public static final CompressedSieveMaterial SKYROOT_COMPRESSED_SIEVE = DefaultMaterials.addDefaultCompressedSieve("skyroot", SoundType.WOOD, "aether");
    public static final CompressedSieveMaterial GOLDEN_OAK_COMPRESSED_SIEVE = DefaultMaterials.addDefaultCompressedSieve("golden_oak", SoundType.WOOD, "aether");
    public static final CompressedSieveMaterial BLUEBRIGHT_COMPRESSED_SIEVE = DefaultMaterials.addDefaultCompressedSieve("bluebright", SoundType.WOOD, "blue_skies");
    public static final CompressedSieveMaterial STARLIT_COMPRESSED_SIEVE = DefaultMaterials.addDefaultCompressedSieve("starlit", SoundType.WOOD, "blue_skies");
    public static final CompressedSieveMaterial FROSTBRIGHT_COMPRESSED_SIEVE = DefaultMaterials.addDefaultCompressedSieve("frostbright", SoundType.WOOD, "blue_skies");
    public static final CompressedSieveMaterial COMET_COMPRESSED_SIEVE = DefaultMaterials.addDefaultCompressedSieve("comet", SoundType.WOOD, "blue_skies");
    public static final CompressedSieveMaterial LUNAR_COMPRESSED_SIEVE = DefaultMaterials.addDefaultCompressedSieve("lunar", SoundType.WOOD, "blue_skies");
    public static final CompressedSieveMaterial DUSK_COMPRESSED_SIEVE = DefaultMaterials.addDefaultCompressedSieve("dusk", SoundType.WOOD, "blue_skies");
    public static final CompressedSieveMaterial MAPLE_COMPRESSED_SIEVE = DefaultMaterials.addDefaultCompressedSieve("maple", SoundType.WOOD, "blue_skies");
    public static final CompressedSieveMaterial CRYSTALLIZED_COMPRESSED_SIEVE = DefaultMaterials.addDefaultCompressedSieve("crystallized", SoundType.WOOD, true, "blue_skies");
    public static final LavaCrucibleMaterial PORCELAIN_CRUCIBLE = DefaultMaterials.addDefaultLavaCrucible("porcelain", SoundType.STONE, 2.0f, false, MapColor.TERRACOTTA_WHITE, "exdeorum");
    public static final LavaCrucibleMaterial WARPED_CRUCIBLE = DefaultMaterials.addDefaultLavaCrucible("warped", SoundType.STEM, 1.5f, false, MapColor.CRIMSON_STEM, "exdeorum");
    public static final LavaCrucibleMaterial CRIMSON_CRUCIBLE = DefaultMaterials.addDefaultLavaCrucible("crimson", SoundType.STEM, 1.5f, false, MapColor.WARPED_STEM, "exdeorum");
    public static final LavaCrucibleMaterial HELLBARK_CRUCIBLE = DefaultMaterials.addDefaultLavaCrucible("hellbark", SoundType.WOOD, 1.5f, false, MapColor.COLOR_LIGHT_GRAY, "biomesoplenty");
    public static final LavaCrucibleMaterial CRYSTALLIZED_CRUCIBLE = DefaultMaterials.addDefaultLavaCrucible("crystallized", SoundType.GLASS, 2.0f, true, MapColor.TERRACOTTA_WHITE, "blue_skies");
    public static final WaterCrucibleMaterial OAK_CRUCIBLE = DefaultMaterials.addDefaultWaterCrucible("oak", SoundType.WOOD, MapColor.WOOD, "exdeorum");
    public static final WaterCrucibleMaterial SPRUCE_CRUCIBLE = DefaultMaterials.addDefaultWaterCrucible("spruce", SoundType.WOOD, MapColor.PODZOL, "exdeorum");
    public static final WaterCrucibleMaterial BIRCH_CRUCIBLE = DefaultMaterials.addDefaultWaterCrucible("birch", SoundType.WOOD, MapColor.SAND, "exdeorum");
    public static final WaterCrucibleMaterial JUNGLE_CRUCIBLE = DefaultMaterials.addDefaultWaterCrucible("jungle", SoundType.WOOD, MapColor.DIRT, "exdeorum");
    public static final WaterCrucibleMaterial ACACIA_CRUCIBLE = DefaultMaterials.addDefaultWaterCrucible("acacia", SoundType.WOOD, MapColor.COLOR_ORANGE, "exdeorum");
    public static final WaterCrucibleMaterial DARK_OAK_CRUCIBLE = DefaultMaterials.addDefaultWaterCrucible("dark_oak", SoundType.WOOD, MapColor.COLOR_BROWN, "exdeorum");
    public static final WaterCrucibleMaterial MANGROVE_CRUCIBLE = DefaultMaterials.addDefaultWaterCrucible("mangrove", SoundType.WOOD, MapColor.COLOR_RED, "exdeorum");
    public static final WaterCrucibleMaterial CHERRY_CRUCIBLE = DefaultMaterials.addDefaultWaterCrucible("cherry", SoundType.CHERRY_WOOD, MapColor.TERRACOTTA_WHITE, "exdeorum");
    public static final WaterCrucibleMaterial BAMBOO_CRUCIBLE = DefaultMaterials.addDefaultWaterCrucible("bamboo", SoundType.BAMBOO_WOOD, MapColor.COLOR_YELLOW, "exdeorum");
    public static final WaterCrucibleMaterial FIR_CRUCIBLE = DefaultMaterials.addDefaultWaterCrucible("fir", SoundType.WOOD, MapColor.TERRACOTTA_WHITE, "biomesoplenty");
    public static final WaterCrucibleMaterial REDWOOD_CRUCIBLE = DefaultMaterials.addDefaultWaterCrucible("redwood", SoundType.WOOD, MapColor.TERRACOTTA_ORANGE, "biomesoplenty");
    public static final WaterCrucibleMaterial MAHOGANY_CRUCIBLE = DefaultMaterials.addDefaultWaterCrucible("mahogany", SoundType.WOOD, MapColor.TERRACOTTA_PINK, "biomesoplenty");
    public static final WaterCrucibleMaterial JACARANDA_CRUCIBLE = DefaultMaterials.addDefaultWaterCrucible("jacaranda", SoundType.WOOD, MapColor.QUARTZ, "biomesoplenty");
    public static final WaterCrucibleMaterial PALM_CRUCIBLE = DefaultMaterials.addDefaultWaterCrucible("palm", SoundType.WOOD, MapColor.TERRACOTTA_YELLOW, "biomesoplenty");
    public static final WaterCrucibleMaterial WILLOW_CRUCIBLE = DefaultMaterials.addDefaultWaterCrucible("willow", SoundType.WOOD, MapColor.TERRACOTTA_LIGHT_GREEN, "biomesoplenty");
    public static final WaterCrucibleMaterial DEAD_CRUCIBLE = DefaultMaterials.addDefaultWaterCrucible("dead", SoundType.WOOD, MapColor.STONE, "biomesoplenty");
    public static final WaterCrucibleMaterial MAGIC_CRUCIBLE = DefaultMaterials.addDefaultWaterCrucible("magic", SoundType.WOOD, MapColor.COLOR_BLUE, "biomesoplenty");
    public static final WaterCrucibleMaterial UMBRAN_CRUCIBLE = DefaultMaterials.addDefaultWaterCrucible("umbran", SoundType.WOOD, MapColor.TERRACOTTA_BLUE, "biomesoplenty");
    public static final WaterCrucibleMaterial CASCADING_ARCHWOOD_CRUCIBLE = DefaultMaterials.addDefaultWaterCrucible("blue_archwood", SoundType.WOOD, MapColor.COLOR_LIGHT_BLUE, "ars_nouveau");
    public static final WaterCrucibleMaterial BLAZING_ARCHWOOD_CRUCIBLE = DefaultMaterials.addDefaultWaterCrucible("red_archwood", SoundType.WOOD, MapColor.COLOR_RED, "ars_nouveau");
    public static final WaterCrucibleMaterial VEXING_ARCHWOOD_CRUCIBLE = DefaultMaterials.addDefaultWaterCrucible("purple_archwood", SoundType.WOOD, MapColor.TERRACOTTA_PURPLE, "ars_nouveau");
    public static final WaterCrucibleMaterial FLOURISHING_ARCHWOOD_CRUCIBLE = DefaultMaterials.addDefaultWaterCrucible("green_archwood", SoundType.WOOD, MapColor.COLOR_GREEN, "ars_nouveau");
    public static final WaterCrucibleMaterial SKYROOT_CRUCIBLE = DefaultMaterials.addDefaultWaterCrucible("skyroot", SoundType.WOOD, MapColor.WOOD, "aether");
    public static final WaterCrucibleMaterial GOLDEN_OAK_CRUCIBLE = DefaultMaterials.addDefaultWaterCrucible("golden_oak", SoundType.WOOD, MapColor.WOOD, "aether");
    public static final WaterCrucibleMaterial BLUEBRIGHT_CRUCIBLE = DefaultMaterials.addDefaultWaterCrucible("bluebright", SoundType.WOOD, MapColor.WOOD, "blue_skies");
    public static final WaterCrucibleMaterial STARLIT_CRUCIBLE = DefaultMaterials.addDefaultWaterCrucible("starlit", SoundType.WOOD, MapColor.WOOD, "blue_skies");
    public static final WaterCrucibleMaterial FROSTBRIGHT_CRUCIBLE = DefaultMaterials.addDefaultWaterCrucible("frostbright", SoundType.WOOD, MapColor.WOOD, "blue_skies");
    public static final WaterCrucibleMaterial COMET_CRUCIBLE = DefaultMaterials.addDefaultWaterCrucible("comet", SoundType.WOOD, MapColor.WOOD, "blue_skies");
    public static final WaterCrucibleMaterial LUNAR_CRUCIBLE = DefaultMaterials.addDefaultWaterCrucible("lunar", SoundType.WOOD, MapColor.WOOD, "blue_skies");
    public static final WaterCrucibleMaterial DUSK_CRUCIBLE = DefaultMaterials.addDefaultWaterCrucible("dusk", SoundType.WOOD, MapColor.WOOD, "blue_skies");
    public static final WaterCrucibleMaterial MAPLE_CRUCIBLE = DefaultMaterials.addDefaultWaterCrucible("maple", SoundType.WOOD, MapColor.WOOD, "blue_skies");

    private static BarrelMaterial addDefaultWoodBarrel(String name, SoundType soundType, boolean fireproof, MapColor color, String requiredModId) {
        return DefaultMaterials.addDefaultBarrel(name, soundType, 2.0f, false, fireproof, color, requiredModId, false);
    }

    private static BarrelMaterial addDefaultBarrel(String name, SoundType soundType, float strength, boolean needsCorrectTool, boolean fireproof, MapColor color, String requiredModId, boolean transparent) {
        BarrelMaterial material = new BarrelMaterial(soundType, strength, needsCorrectTool, fireproof, color.id, requiredModId, transparent);
        BARRELS.register(name, material);
        return material;
    }

    private static SieveMaterial addDefaultSieve(String name, SoundType soundType, String requiredModId) {
        return DefaultMaterials.addDefaultSieve(name, soundType, false, requiredModId);
    }

    private static SieveMaterial addDefaultSieve(String name, SoundType soundType, boolean needsCorrectTool, String requiredModID) {
        SieveMaterial material = new SieveMaterial(soundType, 2.0f, needsCorrectTool, requiredModID);
        SIEVES.register(name, material);
        return material;
    }

    private static CompressedSieveMaterial addDefaultCompressedSieve(String name, SoundType soundType, String requiredModID) {
        return DefaultMaterials.addDefaultCompressedSieve(name, soundType, false, requiredModID);
    }

    private static CompressedSieveMaterial addDefaultCompressedSieve(String name, SoundType soundType, boolean needsCorrectTool, String requiredModId) {
        CompressedSieveMaterial material = new CompressedSieveMaterial(soundType, 2.0f, needsCorrectTool, requiredModId);
        COMPRESSED_SIEVES.register(name, material);
        return material;
    }

    private static LavaCrucibleMaterial addDefaultLavaCrucible(String name, SoundType soundType, float strength, boolean needsCorrectTool, MapColor color, String requiredModId) {
        LavaCrucibleMaterial material = new LavaCrucibleMaterial(soundType, strength, needsCorrectTool, color.id, requiredModId);
        LAVA_CRUCIBLES.register(name, material);
        return material;
    }

    private static WaterCrucibleMaterial addDefaultWaterCrucible(String name, SoundType soundType, MapColor color, String requiredModId) {
        WaterCrucibleMaterial material = new WaterCrucibleMaterial(soundType, 1.5f, false, color.id, requiredModId);
        WATER_CRUCIBLES.register(name, material);
        return material;
    }

    public static void registerMaterials() {
        BARRELS.search(BarrelMaterial::readFromJson);
        SIEVES.search(SieveMaterial::readFromJson);
        COMPRESSED_SIEVES.search(CompressedSieveMaterial::readFromJson);
        LAVA_CRUCIBLES.search(parser -> AbstractCrucibleMaterial.readFromJson(parser, LavaCrucibleMaterial::new));
        WATER_CRUCIBLES.search(parser -> AbstractCrucibleMaterial.readFromJson(parser, WaterCrucibleMaterial::new));
    }
}

